/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jdbc.admin.cli;

import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.Resources;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.util.HashMap;
import java.util.Properties;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.jdbc.admin.cli.JDBCConnectionPoolManager;
import org.glassfish.resource.common.ResourceStatus;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;

@Service(name="create-jdbc-connection-pool")
@Scoped(value=PerLookup.class)
@I18n(value="create.jdbc.connection.pool")
public class CreateJdbcConnectionPool
implements AdminCommand {
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(CreateJdbcConnectionPool.class);
    @Param(name="datasourceclassname")
    String datasourceclassname;
    @Param(optional=true, acceptableValues="javax.sql.DataSource,javax.sql.XADataSource,javax.sql.ConnectionPoolDataSource,java.sql.Driver")
    String restype;
    @Param(name="steadypoolsize", optional=true)
    String steadypoolsize = "8";
    @Param(name="maxpoolsize", optional=true)
    String maxpoolsize = "32";
    @Param(name="maxwait", optional=true)
    String maxwait = "60000";
    @Param(name="poolresize", optional=true)
    String poolresize = "2";
    @Param(name="idletimeout", optional=true)
    String idletimeout = "300";
    @Param(optional=true)
    String initsql;
    @Param(name="isolationlevel", optional=true)
    String isolationlevel;
    @Param(name="isisolationguaranteed", optional=true, defaultValue="true")
    Boolean isisolationguaranteed;
    @Param(name="isconnectvalidatereq", optional=true, defaultValue="false")
    Boolean isconnectvalidatereq;
    @Param(optional=true, acceptableValues="auto-commit,meta-data,table,custom-validation")
    String validationmethod = "table";
    @Param(name="validationtable", optional=true)
    String validationtable;
    @Param(name="failconnection", optional=true, defaultValue="false")
    Boolean failconnection;
    @Param(name="allownoncomponentcallers", optional=true, defaultValue="false")
    Boolean allownoncomponentcallers;
    @Param(name="nontransactionalconnections", optional=true, defaultValue="false")
    Boolean nontransactionalconnections;
    @Param(name="validateatmostonceperiod", optional=true)
    String validateatmostonceperiod = "0";
    @Param(name="leaktimeout", optional=true)
    String leaktimeout = "0";
    @Param(name="leakreclaim", optional=true, defaultValue="false")
    Boolean leakreclaim;
    @Param(name="creationretryattempts", optional=true)
    String creationretryattempts = "0";
    @Param(name="creationretryinterval", optional=true)
    String creationretryinterval = "10";
    @Param(optional=true)
    String sqltracelisteners;
    @Param(name="statementtimeout", optional=true)
    String statementtimeout = "-1";
    @Param(name="lazyconnectionenlistment", optional=true, defaultValue="false")
    Boolean lazyconnectionenlistment;
    @Param(name="lazyconnectionassociation", optional=true, defaultValue="false")
    Boolean lazyconnectionassociation;
    @Param(name="associatewiththread", optional=true, defaultValue="false")
    Boolean associatewiththread;
    @Param(optional=true, defaultValue="1")
    String associatewiththreadconnectionscount;
    @Param(optional=true)
    String driverclassname;
    @Param(name="matchconnections", optional=true, defaultValue="false")
    Boolean matchconnections;
    @Param(name="maxconnectionusagecount", optional=true)
    String maxconnectionusagecount = "0";
    @Param(optional=true, defaultValue="false")
    Boolean ping;
    @Param(optional=true, defaultValue="true")
    Boolean pooling;
    @Param(optional=true, defaultValue="0")
    String statementcachesize;
    @Param(optional=true)
    String validationclassname;
    @Param(name="wrapjdbcobjects", optional=true, defaultValue="true")
    Boolean wrapjdbcobjects;
    @Param(name="description", optional=true)
    String description;
    @Param(name="property", optional=true)
    Properties properties;
    @Param(optional=true)
    String target = "server";
    @Param(name="jdbc_connection_pool_id", primary=true)
    String jdbc_connection_pool_id;
    @Inject
    Resources resources;
    @Inject
    Domain domain;

    public void execute(AdminCommandContext context) {
        ResourceStatus rs;
        ActionReport report = context.getActionReport();
        Server targetServer = this.domain.getServerNamed(this.target);
        HashMap<String, String> attrList = new HashMap<String, String>();
        attrList.put("name", this.jdbc_connection_pool_id);
        attrList.put("datasource-classname", this.datasourceclassname);
        attrList.put("description", this.description);
        attrList.put("res-type", this.restype);
        attrList.put("steady-pool-size", this.steadypoolsize);
        attrList.put("max-pool-size", this.maxpoolsize);
        attrList.put("max-wait-time-in-millis", this.maxwait);
        attrList.put("pool-resize-quantity", this.poolresize);
        attrList.put("init-sql", this.initsql);
        attrList.put("idle-timeout-in-seconds", this.idletimeout);
        attrList.put("transaction-isolation-level", this.isolationlevel);
        attrList.put("is-isolation-level-guaranteed", this.isisolationguaranteed.toString());
        attrList.put("is-connection-validation-required", this.isconnectvalidatereq.toString());
        attrList.put("connection-validation-method", this.validationmethod);
        attrList.put("validation-table-name", this.validationtable);
        attrList.put("fail-all-connections", this.failconnection.toString());
        attrList.put("non-transactional-connections", this.nontransactionalconnections.toString());
        attrList.put("allow-non-component-callers", this.allownoncomponentcallers.toString());
        attrList.put("validate-atmost-once-period-in-seconds", this.validateatmostonceperiod);
        attrList.put("connection-leak-timeout-in-seconds", this.leaktimeout);
        attrList.put("connection-leak-reclaim", this.leakreclaim.toString());
        attrList.put("connection-creation-retry-attempts", this.creationretryattempts);
        attrList.put("connection-creation-retry-interval-in-seconds", this.creationretryinterval);
        attrList.put("driver-classname", this.driverclassname);
        attrList.put("sql-trace-listeners", this.sqltracelisteners);
        attrList.put("statement-timeout", this.statementtimeout);
        attrList.put("statement-cache-size", this.statementcachesize);
        attrList.put("lazy-connection-association", this.lazyconnectionassociation.toString());
        attrList.put("lazy-connection-enlistment", this.lazyconnectionenlistment.toString());
        attrList.put("associate-with-thread", this.associatewiththread.toString());
        attrList.put("associate-with-thread-connections-count", this.associatewiththreadconnectionscount);
        attrList.put("match-connections", this.matchconnections.toString());
        attrList.put("max-connection-usage-count", this.maxconnectionusagecount);
        attrList.put("ping", this.ping.toString());
        attrList.put("pooling", this.pooling.toString());
        attrList.put("validation-classname", this.validationclassname);
        attrList.put("wrap-jdbc-objects", this.wrapjdbcobjects.toString());
        try {
            JDBCConnectionPoolManager connPoolMgr = new JDBCConnectionPoolManager();
            rs = connPoolMgr.create(this.resources, attrList, this.properties, targetServer);
        }
        catch (Exception e) {
            String actual = e.getMessage();
            String def = "JDBC connection pool: {0} could not be created, reason: {1}";
            report.setMessage(localStrings.getLocalString("create.jdbc.connection.pool.fail", def, new Object[]{this.jdbc_connection_pool_id, actual}));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setFailureCause((Throwable)e);
            return;
        }
        ActionReport.ExitCode ec = ActionReport.ExitCode.SUCCESS;
        if (rs.getStatus() == 1) {
            ec = ActionReport.ExitCode.FAILURE;
            if (rs.getMessage() != null) {
                report.setMessage(rs.getMessage());
            } else {
                report.setMessage(localStrings.getLocalString("create.jdbc.connection.pool.fail", "JDBC connection pool {0} creation failed", new Object[]{this.jdbc_connection_pool_id, ""}));
            }
            if (rs.getException() != null) {
                report.setFailureCause(rs.getException());
            }
        }
        report.setActionExitCode(ec);
    }
}

