/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.mbeans;

import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Hashtable;
import java.util.logging.Level;
import javax.management.Attribute;
import javax.management.MBeanException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.modelmbean.ModelMBean;
import org.apache.catalina.Connector;
import org.apache.catalina.Contained;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.DefaultContext;
import org.apache.catalina.Engine;
import org.apache.catalina.Host;
import org.apache.catalina.Loader;
import org.apache.catalina.Logger;
import org.apache.catalina.Manager;
import org.apache.catalina.Realm;
import org.apache.catalina.Server;
import org.apache.catalina.Service;
import org.apache.catalina.deploy.ContextEnvironment;
import org.apache.catalina.deploy.ContextResource;
import org.apache.catalina.deploy.ContextResourceLink;
import org.apache.catalina.deploy.NamingResources;
import org.apache.catalina.mbeans.MBeanFactory;
import org.apache.catalina.mbeans.ServerLifecycleListener;
import org.apache.catalina.valves.ValveBase;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.tomcat.util.modeler.ManagedBean;
import org.apache.tomcat.util.modeler.Registry;
import org.glassfish.web.valve.GlassFishValve;

public class MBeanUtils {
    private static java.util.logging.Logger log = java.util.logging.Logger.getLogger(MBeanUtils.class.getName());
    private static final ClassLoader serverLifecycleListenerClassLoader = ServerLifecycleListener.class.getClassLoader();
    private static String[][] exceptions = new String[][]{{"org.apache.ajp.tomcat4.Ajp13Connector", "Ajp13Connector"}, {"com.sun.grizzly.tcp.tomcat4.Ajp13Connector", "CoyoteConnector"}, {"org.apache.catalina.core.StandardDefaultContext", "DefaultContext"}, {"org.apache.catalina.users.JDBCGroup", "Group"}, {"org.apache.catalina.users.JDBCRole", "Role"}, {"org.apache.catalina.users.JDBCUser", "User"}, {"org.apache.catalina.users.MemoryGroup", "Group"}, {"org.apache.catalina.users.MemoryRole", "Role"}, {"org.apache.catalina.users.MemoryUser", "User"}};
    private static Registry registry = MBeanUtils.createRegistry();
    private static MBeanServer mserver = MBeanUtils.createServer();
    static Hashtable seq = new Hashtable();

    private static final String encodeStr(String t) {
        return URLEncoder.encode(t);
    }

    static String createManagedName(Object component) {
        String className = component.getClass().getName();
        for (int i = 0; i < exceptions.length; ++i) {
            if (!className.equals(exceptions[i][0])) continue;
            return exceptions[i][1];
        }
        int period = className.lastIndexOf(46);
        if (period >= 0) {
            className = className.substring(period + 1);
        }
        return className;
    }

    static ModelMBean createMBean(Connector connector) throws Exception {
        String mname = MBeanUtils.createManagedName(connector);
        ManagedBean managed = registry.findManagedBean(mname);
        if (managed == null) {
            Exception e = new Exception("ManagedBean is not found with " + mname);
            throw new MBeanException(e);
        }
        String domain = managed.getDomain();
        if (domain == null) {
            domain = mserver.getDefaultDomain();
        }
        ModelMBean mbean = managed.createMBean(connector);
        ObjectName oname = MBeanUtils.createObjectName(domain, connector);
        if (mserver.isRegistered(oname)) {
            mserver.unregisterMBean(oname);
        }
        mserver.registerMBean(mbean, oname);
        return mbean;
    }

    static ModelMBean createMBean(Context context) throws Exception {
        String mname = MBeanUtils.createManagedName(context);
        ManagedBean managed = registry.findManagedBean(mname);
        if (managed == null) {
            Exception e = new Exception("ManagedBean is not found with " + mname);
            throw new MBeanException(e);
        }
        String domain = managed.getDomain();
        if (domain == null) {
            domain = mserver.getDefaultDomain();
        }
        ModelMBean mbean = managed.createMBean(context);
        ObjectName oname = MBeanUtils.createObjectName(domain, context);
        if (mserver.isRegistered(oname)) {
            if (log.isLoggable(Level.FINE)) {
                log.fine("Already registered " + oname);
            }
            mserver.unregisterMBean(oname);
        }
        mserver.registerMBean(mbean, oname);
        return mbean;
    }

    static ModelMBean createMBean(ContextEnvironment environment) throws Exception {
        String mname = MBeanUtils.createManagedName(environment);
        ManagedBean managed = registry.findManagedBean(mname);
        if (managed == null) {
            Exception e = new Exception("ManagedBean is not found with " + mname);
            throw new MBeanException(e);
        }
        String domain = managed.getDomain();
        if (domain == null) {
            domain = mserver.getDefaultDomain();
        }
        ModelMBean mbean = managed.createMBean(environment);
        ObjectName oname = MBeanUtils.createObjectName(domain, environment);
        if (mserver.isRegistered(oname)) {
            mserver.unregisterMBean(oname);
        }
        mserver.registerMBean(mbean, oname);
        return mbean;
    }

    static ModelMBean createMBean(ContextResource resource) throws Exception {
        String mname = MBeanUtils.createManagedName(resource);
        ManagedBean managed = registry.findManagedBean(mname);
        if (managed == null) {
            Exception e = new Exception("ManagedBean is not found with " + mname);
            throw new MBeanException(e);
        }
        String domain = managed.getDomain();
        if (domain == null) {
            domain = mserver.getDefaultDomain();
        }
        ModelMBean mbean = managed.createMBean(resource);
        ObjectName oname = MBeanUtils.createObjectName(domain, resource);
        if (mserver.isRegistered(oname)) {
            mserver.unregisterMBean(oname);
        }
        mserver.registerMBean(mbean, oname);
        return mbean;
    }

    static ModelMBean createMBean(ContextResourceLink resourceLink) throws Exception {
        String mname = MBeanUtils.createManagedName(resourceLink);
        ManagedBean managed = registry.findManagedBean(mname);
        if (managed == null) {
            Exception e = new Exception("ManagedBean is not found with " + mname);
            throw new MBeanException(e);
        }
        String domain = managed.getDomain();
        if (domain == null) {
            domain = mserver.getDefaultDomain();
        }
        ModelMBean mbean = managed.createMBean(resourceLink);
        ObjectName oname = MBeanUtils.createObjectName(domain, resourceLink);
        if (mserver.isRegistered(oname)) {
            mserver.unregisterMBean(oname);
        }
        mserver.registerMBean(mbean, oname);
        return mbean;
    }

    static ModelMBean createMBean(DefaultContext context) throws Exception {
        String mname = MBeanUtils.createManagedName(context);
        ManagedBean managed = registry.findManagedBean(mname);
        if (managed == null) {
            Exception e = new Exception("ManagedBean is not found with " + mname);
            throw new MBeanException(e);
        }
        String domain = managed.getDomain();
        if (domain == null) {
            domain = mserver.getDefaultDomain();
        }
        ModelMBean mbean = managed.createMBean(context);
        ObjectName oname = MBeanUtils.createObjectName(domain, context);
        if (mserver.isRegistered(oname)) {
            mserver.unregisterMBean(oname);
        }
        mserver.registerMBean(mbean, oname);
        return mbean;
    }

    static ModelMBean createMBean(Engine engine) throws Exception {
        String mname = MBeanUtils.createManagedName(engine);
        ManagedBean managed = registry.findManagedBean(mname);
        if (managed == null) {
            Exception e = new Exception("ManagedBean is not found with " + mname);
            throw new MBeanException(e);
        }
        String domain = managed.getDomain();
        if (domain == null) {
            domain = mserver.getDefaultDomain();
        }
        ModelMBean mbean = managed.createMBean(engine);
        ObjectName oname = MBeanUtils.createObjectName(domain, engine);
        if (mserver.isRegistered(oname)) {
            mserver.unregisterMBean(oname);
        }
        mserver.registerMBean(mbean, oname);
        return mbean;
    }

    static ModelMBean createMBean(Host host) throws Exception {
        String mname = MBeanUtils.createManagedName(host);
        ManagedBean managed = registry.findManagedBean(mname);
        if (managed == null) {
            Exception e = new Exception("ManagedBean is not found with " + mname);
            throw new MBeanException(e);
        }
        String domain = managed.getDomain();
        if (domain == null) {
            domain = mserver.getDefaultDomain();
        }
        ModelMBean mbean = managed.createMBean(host);
        ObjectName oname = MBeanUtils.createObjectName(domain, host);
        if (mserver.isRegistered(oname)) {
            mserver.unregisterMBean(oname);
        }
        mserver.registerMBean(mbean, oname);
        return mbean;
    }

    static ModelMBean createMBean(Loader loader) throws Exception {
        String mname = MBeanUtils.createManagedName(loader);
        ManagedBean managed = registry.findManagedBean(mname);
        if (managed == null) {
            Exception e = new Exception("ManagedBean is not found with " + mname);
            throw new MBeanException(e);
        }
        String domain = managed.getDomain();
        if (domain == null) {
            domain = mserver.getDefaultDomain();
        }
        ModelMBean mbean = managed.createMBean(loader);
        ObjectName oname = MBeanUtils.createObjectName(domain, loader);
        if (mserver.isRegistered(oname)) {
            mserver.unregisterMBean(oname);
        }
        mserver.registerMBean(mbean, oname);
        return mbean;
    }

    static ModelMBean createMBean(Logger logger) throws Exception {
        String mname = MBeanUtils.createManagedName(logger);
        ManagedBean managed = registry.findManagedBean(mname);
        if (managed == null) {
            Exception e = new Exception("ManagedBean is not found with " + mname);
            throw new MBeanException(e);
        }
        String domain = managed.getDomain();
        if (domain == null) {
            domain = mserver.getDefaultDomain();
        }
        ModelMBean mbean = managed.createMBean(logger);
        ObjectName oname = MBeanUtils.createObjectName(domain, logger);
        if (mserver.isRegistered(oname)) {
            mserver.unregisterMBean(oname);
        }
        mserver.registerMBean(mbean, oname);
        return mbean;
    }

    static ModelMBean createMBean(Manager manager) throws Exception {
        String mname = MBeanUtils.createManagedName(manager);
        ManagedBean managed = registry.findManagedBean(mname);
        if (managed == null) {
            Exception e = new Exception("ManagedBean is not found with " + mname);
            throw new MBeanException(e);
        }
        String domain = managed.getDomain();
        if (domain == null) {
            domain = mserver.getDefaultDomain();
        }
        ModelMBean mbean = managed.createMBean(manager);
        ObjectName oname = MBeanUtils.createObjectName(domain, manager);
        if (mserver.isRegistered(oname)) {
            mserver.unregisterMBean(oname);
        }
        mserver.registerMBean(mbean, oname);
        return mbean;
    }

    static ModelMBean createMBean(MBeanFactory factory) throws Exception {
        String mname = MBeanUtils.createManagedName(factory);
        ManagedBean managed = registry.findManagedBean(mname);
        if (managed == null) {
            Exception e = new Exception("ManagedBean is not found with " + mname);
            throw new MBeanException(e);
        }
        String domain = managed.getDomain();
        if (domain == null) {
            domain = mserver.getDefaultDomain();
        }
        ModelMBean mbean = managed.createMBean(factory);
        ObjectName oname = MBeanUtils.createObjectName(domain, factory);
        if (mserver.isRegistered(oname)) {
            mserver.unregisterMBean(oname);
        }
        mserver.registerMBean(mbean, oname);
        return mbean;
    }

    static ModelMBean createMBean(NamingResources resource) throws Exception {
        String mname = MBeanUtils.createManagedName(resource);
        ManagedBean managed = registry.findManagedBean(mname);
        if (managed == null) {
            Exception e = new Exception("ManagedBean is not found with " + mname);
            throw new MBeanException(e);
        }
        String domain = managed.getDomain();
        if (domain == null) {
            domain = mserver.getDefaultDomain();
        }
        ModelMBean mbean = managed.createMBean(resource);
        ObjectName oname = MBeanUtils.createObjectName(domain, resource);
        if (mserver.isRegistered(oname)) {
            mserver.unregisterMBean(oname);
        }
        mserver.registerMBean(mbean, oname);
        return mbean;
    }

    static ModelMBean createMBean(Realm realm) throws Exception {
        String mname = MBeanUtils.createManagedName(realm);
        ManagedBean managed = registry.findManagedBean(mname);
        if (managed == null) {
            Exception e = new Exception("ManagedBean is not found with " + mname);
            throw new MBeanException(e);
        }
        String domain = managed.getDomain();
        if (domain == null) {
            domain = mserver.getDefaultDomain();
        }
        ModelMBean mbean = managed.createMBean(realm);
        ObjectName oname = MBeanUtils.createObjectName(domain, realm);
        if (mserver.isRegistered(oname)) {
            mserver.unregisterMBean(oname);
        }
        mserver.registerMBean(mbean, oname);
        return mbean;
    }

    static ModelMBean createMBean(Server server) throws Exception {
        String mname = MBeanUtils.createManagedName(server);
        ManagedBean managed = registry.findManagedBean(mname);
        if (managed == null) {
            Exception e = new Exception("ManagedBean is not found with " + mname);
            throw new MBeanException(e);
        }
        String domain = managed.getDomain();
        if (domain == null) {
            domain = mserver.getDefaultDomain();
        }
        ModelMBean mbean = managed.createMBean(server);
        ObjectName oname = MBeanUtils.createObjectName(domain, server);
        if (mserver.isRegistered(oname)) {
            mserver.unregisterMBean(oname);
        }
        mserver.registerMBean(mbean, oname);
        return mbean;
    }

    static ModelMBean createMBean(Service service) throws Exception {
        String mname = MBeanUtils.createManagedName(service);
        ManagedBean managed = registry.findManagedBean(mname);
        if (managed == null) {
            Exception e = new Exception("ManagedBean is not found with " + mname);
            throw new MBeanException(e);
        }
        String domain = managed.getDomain();
        if (domain == null) {
            domain = mserver.getDefaultDomain();
        }
        ModelMBean mbean = managed.createMBean(service);
        ObjectName oname = MBeanUtils.createObjectName(domain, service);
        if (mserver.isRegistered(oname)) {
            mserver.unregisterMBean(oname);
        }
        mserver.registerMBean(mbean, oname);
        return mbean;
    }

    static ModelMBean createMBean(GlassFishValve valve) throws Exception {
        String mname = MBeanUtils.createManagedName(valve);
        ManagedBean managed = registry.findManagedBean(mname);
        if (managed == null) {
            Exception e = new Exception("ManagedBean is not found with " + mname);
            throw new MBeanException(e);
        }
        String domain = managed.getDomain();
        if (domain == null) {
            domain = mserver.getDefaultDomain();
        }
        ModelMBean mbean = managed.createMBean(valve);
        ObjectName oname = MBeanUtils.createObjectName(domain, valve);
        if (mserver.isRegistered(oname)) {
            mserver.unregisterMBean(oname);
        }
        mserver.registerMBean(mbean, oname);
        return mbean;
    }

    static ObjectName createObjectName(String domain, Connector connector) throws MalformedObjectNameException {
        ObjectName name = null;
        if (connector.getClass().getName().indexOf("CoyoteConnector") >= 0) {
            try {
                String address = (String)PropertyUtils.getSimpleProperty(connector, "address");
                Integer port = (Integer)PropertyUtils.getSimpleProperty(connector, "port");
                Service service = connector.getService();
                String serviceName = null;
                if (service != null) {
                    serviceName = service.getName();
                }
                StringBuffer sb = new StringBuffer(domain);
                sb.append(":type=Connector");
                sb.append(",port=" + port);
                if (address != null && address.length() > 0) {
                    sb.append(",address=" + address);
                }
                name = new ObjectName(sb.toString());
                return name;
            }
            catch (Exception e) {
                throw new MalformedObjectNameException("Cannot create object name for " + connector + e);
            }
        }
        throw new MalformedObjectNameException("Cannot create object name for " + connector);
    }

    static ObjectName createObjectName(String domain, Context context) throws MalformedObjectNameException {
        ObjectName name = null;
        Host host = (Host)context.getParent();
        Service service = ((Engine)host.getParent()).getService();
        String path = context.getPath();
        if (path.length() < 1) {
            path = "/";
        }
        name = new ObjectName(domain + ":j2eeType=WebModule,name=//" + host.getName() + path + ",J2EEApplication=none,J2EEServer=none");
        return name;
    }

    public static ObjectName createObjectName(String domain, ContextEnvironment environment) throws MalformedObjectNameException {
        ObjectName name = null;
        Object container = environment.getNamingResources().getContainer();
        if (container instanceof Server) {
            name = new ObjectName(domain + ":type=Environment" + ",resourcetype=Global,name=" + environment.getName());
        } else if (container instanceof Context) {
            String path = ((Context)container).getPath();
            if (path.length() < 1) {
                path = "/";
            }
            Host host = (Host)((Context)container).getParent();
            Engine engine = (Engine)host.getParent();
            Service service = engine.getService();
            name = new ObjectName(domain + ":type=Environment" + ",resourcetype=Context,path=" + path + ",host=" + host.getName() + ",name=" + environment.getName());
        } else if (container instanceof DefaultContext) {
            if ((container = ((DefaultContext)container).getParent()) instanceof Host) {
                Host host = (Host)container;
                Service service = ((Engine)host.getParent()).getService();
                name = new ObjectName(domain + ":type=Environment" + ",resourcetype=HostDefaultContext,host=" + host.getName() + ",name=" + environment.getName());
            } else if (container instanceof Engine) {
                Engine engine = (Engine)container;
                Service service = engine.getService();
                name = new ObjectName(domain + ":type=Environment" + ",resourcetype=ServiceDefaultContext,name=" + environment.getName());
            }
        }
        return name;
    }

    public static ObjectName createObjectName(String domain, ContextResource resource) throws MalformedObjectNameException {
        ObjectName name = null;
        String encodedResourceName = MBeanUtils.encodeStr(resource.getName());
        Object container = resource.getNamingResources().getContainer();
        if (container instanceof Server) {
            name = new ObjectName(domain + ":type=Resource" + ",resourcetype=Global,class=" + resource.getType() + ",name=" + encodedResourceName);
        } else if (container instanceof Context) {
            String path = ((Context)container).getPath();
            if (path.length() < 1) {
                path = "/";
            }
            Host host = (Host)((Context)container).getParent();
            Engine engine = (Engine)host.getParent();
            Service service = engine.getService();
            name = new ObjectName(domain + ":type=Resource" + ",resourcetype=Context,path=" + path + ",host=" + host.getName() + ",class=" + resource.getType() + ",name=" + encodedResourceName);
        } else if (container instanceof DefaultContext) {
            if ((container = ((DefaultContext)container).getParent()) instanceof Host) {
                Host host = (Host)container;
                Service service = ((Engine)host.getParent()).getService();
                name = new ObjectName(domain + ":type=Resource" + ",resourcetype=HostDefaultContext,host=" + host.getName() + ",class=" + resource.getType() + ",name=" + encodedResourceName);
            } else if (container instanceof Engine) {
                Engine engine = (Engine)container;
                Service service = engine.getService();
                name = new ObjectName(domain + ":type=Resource" + ",resourcetype=ServiceDefaultContext,class=" + resource.getType() + ",name=" + encodedResourceName);
            }
        }
        return name;
    }

    public static ObjectName createObjectName(String domain, ContextResourceLink resourceLink) throws MalformedObjectNameException {
        ObjectName name = null;
        String encodedResourceLinkName = MBeanUtils.encodeStr(resourceLink.getName());
        Object container = resourceLink.getNamingResources().getContainer();
        if (container instanceof Server) {
            name = new ObjectName(domain + ":type=ResourceLink" + ",resourcetype=Global" + ",name=" + encodedResourceLinkName);
        } else if (container instanceof Context) {
            String path = ((Context)container).getPath();
            if (path.length() < 1) {
                path = "/";
            }
            Host host = (Host)((Context)container).getParent();
            Engine engine = (Engine)host.getParent();
            Service service = engine.getService();
            name = new ObjectName(domain + ":type=ResourceLink" + ",resourcetype=Context,path=" + path + ",host=" + host.getName() + ",name=" + encodedResourceLinkName);
        } else if (container instanceof DefaultContext) {
            if ((container = ((DefaultContext)container).getParent()) instanceof Host) {
                Host host = (Host)container;
                Service service = ((Engine)host.getParent()).getService();
                name = new ObjectName(domain + ":type=ResourceLink" + ",resourcetype=HostDefaultContext,host=" + host.getName() + ",name=" + encodedResourceLinkName);
            } else if (container instanceof Engine) {
                Engine engine = (Engine)container;
                Service service = engine.getService();
                name = new ObjectName(domain + ":type=ResourceLink" + ",resourcetype=ServiceDefaultContext,name=" + encodedResourceLinkName);
            }
        }
        return name;
    }

    static ObjectName createObjectName(String domain, DefaultContext context) throws MalformedObjectNameException {
        ObjectName name = null;
        Container container = context.getParent();
        if (container instanceof Host) {
            Host host = (Host)container;
            Service service = ((Engine)host.getParent()).getService();
            name = new ObjectName(domain + ":type=DefaultContext,host=" + host.getName());
        } else if (container instanceof Engine) {
            Engine engine = (Engine)container;
            Service service = engine.getService();
            name = new ObjectName(domain + ":type=DefaultContext");
        }
        return name;
    }

    static ObjectName createObjectName(String domain, Engine engine) throws MalformedObjectNameException {
        ObjectName name = null;
        name = new ObjectName(domain + ":type=Engine");
        return name;
    }

    static ObjectName createObjectName(String domain, Host host) throws MalformedObjectNameException {
        ObjectName name = null;
        Engine engine = (Engine)host.getParent();
        Service service = engine.getService();
        name = new ObjectName(domain + ":type=Host,host=" + host.getName());
        return name;
    }

    static ObjectName createObjectName(String domain, Loader loader) throws MalformedObjectNameException {
        DefaultContext defaultContext;
        ObjectName name = null;
        Container container = loader.getContainer();
        if (container instanceof Engine) {
            Service service = ((Engine)container).getService();
            name = new ObjectName(domain + ":type=Loader");
        } else if (container instanceof Host) {
            Engine engine = (Engine)container.getParent();
            Service service = engine.getService();
            name = new ObjectName(domain + ":type=Loader,host=" + container.getName());
        } else if (container instanceof Context) {
            String path = ((Context)container).getPath();
            if (path.length() < 1) {
                path = "/";
            }
            Host host = (Host)container.getParent();
            Engine engine = (Engine)host.getParent();
            Service service = engine.getService();
            name = new ObjectName(domain + ":type=Loader,path=" + path + ",host=" + host.getName());
        } else if (container == null && (defaultContext = loader.getDefaultContext()) != null) {
            Container parent = defaultContext.getParent();
            if (parent instanceof Engine) {
                Service service = ((Engine)parent).getService();
                name = new ObjectName(domain + ":type=DefaultLoader");
            } else if (parent instanceof Host) {
                Engine engine = (Engine)parent.getParent();
                Service service = engine.getService();
                name = new ObjectName(domain + ":type=DefaultLoader,host=" + parent.getName());
            }
        }
        return name;
    }

    static ObjectName createObjectName(String domain, Logger logger) throws MalformedObjectNameException {
        ObjectName name = null;
        Container container = logger.getContainer();
        if (container instanceof Engine) {
            Service service = ((Engine)container).getService();
            name = new ObjectName(domain + ":type=Logger");
        } else if (container instanceof Host) {
            Engine engine = (Engine)container.getParent();
            Service service = engine.getService();
            name = new ObjectName(domain + ":type=Logger,host=" + container.getName());
        } else if (container instanceof Context) {
            String path = ((Context)container).getPath();
            if (path.length() < 1) {
                path = "/";
            }
            Host host = (Host)container.getParent();
            Engine engine = (Engine)host.getParent();
            Service service = engine.getService();
            name = new ObjectName(domain + ":type=Logger,path=" + path + ",host=" + host.getName());
        }
        return name;
    }

    static ObjectName createObjectName(String domain, Manager manager) throws MalformedObjectNameException {
        DefaultContext defaultContext;
        ObjectName name = null;
        Container container = manager.getContainer();
        if (container instanceof Engine) {
            Service service = ((Engine)container).getService();
            name = new ObjectName(domain + ":type=Manager");
        } else if (container instanceof Host) {
            Engine engine = (Engine)container.getParent();
            Service service = engine.getService();
            name = new ObjectName(domain + ":type=Manager,host=" + container.getName());
        } else if (container instanceof Context) {
            String path = ((Context)container).getPath();
            if (path.length() < 1) {
                path = "/";
            }
            Host host = (Host)container.getParent();
            Engine engine = (Engine)host.getParent();
            Service service = engine.getService();
            name = new ObjectName(domain + ":type=Manager,path=" + path + ",host=" + host.getName());
        } else if (container == null && (defaultContext = manager.getDefaultContext()) != null) {
            Container parent = defaultContext.getParent();
            if (parent instanceof Engine) {
                Service service = ((Engine)parent).getService();
                name = new ObjectName(domain + ":type=DefaultManager");
            } else if (parent instanceof Host) {
                Engine engine = (Engine)parent.getParent();
                Service service = engine.getService();
                name = new ObjectName(domain + ":type=DefaultManager,host=" + parent.getName());
            }
        }
        return name;
    }

    static ObjectName createObjectName(String domain, NamingResources resources) throws MalformedObjectNameException {
        ObjectName name = null;
        Object container = resources.getContainer();
        if (container instanceof Server) {
            name = new ObjectName(domain + ":type=NamingResources" + ",resourcetype=Global");
        } else if (container instanceof Context) {
            String path = ((Context)container).getPath();
            if (path.length() < 1) {
                path = "/";
            }
            Host host = (Host)((Context)container).getParent();
            Engine engine = (Engine)host.getParent();
            Service service = engine.getService();
            name = new ObjectName(domain + ":type=NamingResources" + ",resourcetype=Context,path=" + path + ",host=" + host.getName());
        } else if (container instanceof DefaultContext) {
            if ((container = ((DefaultContext)container).getParent()) instanceof Host) {
                Host host = (Host)container;
                Service service = ((Engine)host.getParent()).getService();
                name = new ObjectName(domain + ":type=NamingResources" + ",resourcetype=HostDefaultContext,host=" + host.getName());
            } else if (container instanceof Engine) {
                Engine engine = (Engine)container;
                Service service = engine.getService();
                name = new ObjectName(domain + ":type=NamingResources" + ",resourcetype=ServiceDefaultContext");
            }
        }
        return name;
    }

    static ObjectName createObjectName(String domain, MBeanFactory factory) throws MalformedObjectNameException {
        ObjectName name = new ObjectName(domain + ":type=MBeanFactory");
        return name;
    }

    static ObjectName createObjectName(String domain, Realm realm) throws MalformedObjectNameException {
        ObjectName name = null;
        Container container = realm.getContainer();
        if (container instanceof Engine) {
            Service service = ((Engine)container).getService();
            name = new ObjectName(domain + ":type=Realm");
        } else if (container instanceof Host) {
            Engine engine = (Engine)container.getParent();
            Service service = engine.getService();
            name = new ObjectName(domain + ":type=Realm,host=" + container.getName());
        } else if (container instanceof Context) {
            String path = ((Context)container).getPath();
            if (path.length() < 1) {
                path = "/";
            }
            Host host = (Host)container.getParent();
            Engine engine = (Engine)host.getParent();
            Service service = engine.getService();
            name = new ObjectName(domain + ":type=Realm,path=" + path + ",host=" + host.getName());
        }
        return name;
    }

    static ObjectName createObjectName(String domain, Server server) throws MalformedObjectNameException {
        ObjectName name = null;
        name = new ObjectName(domain + ":type=Server");
        return name;
    }

    static ObjectName createObjectName(String domain, Service service) throws MalformedObjectNameException {
        ObjectName name = null;
        name = new ObjectName(domain + ":type=Service,serviceName=" + service.getName());
        return name;
    }

    static ObjectName createObjectName(String domain, GlassFishValve valve) throws MalformedObjectNameException {
        ObjectName name;
        if (valve instanceof ValveBase && (name = ((ValveBase)valve).getObjectName()) != null) {
            return name;
        }
        name = null;
        Container container = null;
        String className = valve.getClass().getName();
        int period = className.lastIndexOf(46);
        if (period >= 0) {
            className = className.substring(period + 1);
        }
        if (valve instanceof Contained) {
            container = ((Contained)((Object)valve)).getContainer();
        }
        if (container == null) {
            throw new MalformedObjectNameException("Cannot create mbean for non-contained valve " + valve);
        }
        if (container instanceof Engine) {
            Service service = ((Engine)container).getService();
            String local = "";
            int seq = MBeanUtils.getSeq(local);
            String ext = "";
            if (seq > 0) {
                ext = ",seq=" + seq;
            }
            name = new ObjectName(domain + ":type=Valve,name=" + className + ext + local);
        } else if (container instanceof Host) {
            Service service = ((Engine)container.getParent()).getService();
            String local = ",host=" + container.getName();
            int seq = MBeanUtils.getSeq(local);
            String ext = "";
            if (seq > 0) {
                ext = ",seq=" + seq;
            }
            name = new ObjectName(domain + ":type=Valve,name=" + className + ext + local);
        } else if (container instanceof Context) {
            String path = ((Context)container).getPath();
            if (path.length() < 1) {
                path = "/";
            }
            Host host = (Host)container.getParent();
            Service service = ((Engine)host.getParent()).getService();
            String local = ",path=" + path + ",host=" + host.getName();
            int seq = MBeanUtils.getSeq(local);
            String ext = "";
            if (seq > 0) {
                ext = ",seq=" + seq;
            }
            name = new ObjectName(domain + ":type=Valve,name=" + className + ext + local);
        }
        return name;
    }

    static int getSeq(String key) {
        int[] i = (int[])seq.get(key);
        if (i == null) {
            i = new int[]{0};
            seq.put(key, i);
        } else {
            i[0] = i[0] + 1;
        }
        return i[0];
    }

    public static synchronized Registry createRegistry() {
        if (registry == null) {
            registry = Registry.getRegistry(null, null);
            ClassLoader cl = serverLifecycleListenerClassLoader;
            registry.loadDescriptors("org.apache.catalina.mbeans", cl);
            registry.loadDescriptors("org.apache.catalina.authenticator", cl);
            registry.loadDescriptors("org.apache.catalina.core", cl);
            registry.loadDescriptors("org.apache.catalina", cl);
            registry.loadDescriptors("org.apache.catalina.deploy", cl);
            registry.loadDescriptors("org.apache.catalina.loader", cl);
            registry.loadDescriptors("org.apache.catalina.logger", cl);
            registry.loadDescriptors("org.apache.catalina.realm", cl);
            registry.loadDescriptors("org.apache.catalina.session", cl);
            registry.loadDescriptors("org.apache.catalina.startup", cl);
            registry.loadDescriptors("org.apache.catalina.users", cl);
            registry.loadDescriptors("org.apache.catalina.valves", cl);
            registry.loadDescriptors("org.apache.catalina.connector", cl);
        }
        return registry;
    }

    public static synchronized void loadMBeanDescriptors(String resource) {
        try {
            URL url = ServerLifecycleListener.class.getResource(resource);
            if (url != null) {
                InputStream stream = url.openStream();
                Registry.getRegistry(null, null).loadMetadata(stream);
                stream.close();
            } else {
                log.warning("MBean descriptors not found:" + resource);
            }
        }
        catch (Throwable t) {
            t.printStackTrace(System.out);
        }
    }

    public static synchronized MBeanServer createServer() {
        if (mserver == null) {
            try {
                mserver = Registry.getRegistry(null, null).getMBeanServer();
            }
            catch (Throwable t) {
                t.printStackTrace(System.out);
                System.exit(1);
            }
        }
        return mserver;
    }

    public static void createRMIAdaptor(String adaptorType, String host, int port) throws Exception {
        String namingProviderObjectName = null;
        String namingProviderClassName = null;
        String adaptorObjectName = null;
        String adaptorClassName = null;
        String adaptorMbeanClassName = null;
        boolean delay = false;
        String jndiName = "jrmp";
        String contextFactory = null;
        String providerUrl = null;
        if (host == null || host.trim().length() == 0) {
            host = "localhost";
        }
        if (adaptorType.equals("jrmp")) {
            namingProviderObjectName = "Naming:type=rmiregistry";
            namingProviderClassName = "mx4j.tools.naming.NamingService";
            adaptorObjectName = "Adaptor:protocol=JRMP";
            adaptorClassName = "mx4j.adaptor.rmi.jrmp.JRMPAdaptor";
            adaptorMbeanClassName = "mx4j.adaptor.rmi.jrmp.JRMPAdaptorMBean";
            contextFactory = "com.sun.jndi.rmi.registry.RegistryContextFactory";
            if (port == -1) {
                port = 1099;
            }
            providerUrl = "rmi://" + host + ":" + Integer.toString(port);
        } else if (adaptorType.equals("iiop")) {
            namingProviderObjectName = "Naming:type=tnameserv";
            namingProviderClassName = "mx4j.tools.naming.CosNamingService";
            delay = true;
            adaptorObjectName = "Adaptor:protocol=IIOP";
            adaptorClassName = "mx4j.adaptor.rmi.iiop.IIOPAdaptor";
            adaptorMbeanClassName = "mx4j.adaptor.rmi.iiop.IIOPAdaptorMBean";
            contextFactory = "com.sun.jndi.cosnaming.CNCtxFactory";
            if (port == -1) {
                port = 900;
            }
            providerUrl = "iiop://" + host + ":" + Integer.toString(port);
        } else {
            throw new IllegalArgumentException("Unknown adaptor type");
        }
        ObjectName naming = new ObjectName(namingProviderObjectName);
        mserver.createMBean(namingProviderClassName, naming, null);
        if (delay) {
            mserver.setAttribute(naming, new Attribute("Delay", 5000));
        }
        mserver.invoke(naming, "start", null, null);
        ObjectName adaptor = new ObjectName(adaptorObjectName);
        mserver.createMBean(adaptorClassName, adaptor, null);
        Class<?> proxyClass = Class.forName("mx4j.util.StandardMBeanProxy");
        Object[] args = null;
        Class[] types = null;
        Method method = null;
        types = new Class[]{Class.class, MBeanServer.class, ObjectName.class};
        args = new Object[]{Class.forName(adaptorMbeanClassName), mserver, adaptor};
        method = proxyClass.getMethod("create", types);
        Object bean = method.invoke(null, args);
        Class<?> beanClass = bean.getClass();
        args = new Object[]{jndiName};
        types = new Class[]{String.class};
        method = beanClass.getMethod("setJNDIName", types);
        method.invoke(bean, args);
        args = new Object[2];
        types = new Class[]{Object.class, Object.class};
        method = beanClass.getMethod("putJNDIProperty", types);
        args[0] = "java.naming.factory.initial";
        args[1] = contextFactory;
        method.invoke(bean, args);
        args[0] = "java.naming.provider.url";
        args[1] = providerUrl;
        method.invoke(bean, args);
        method = beanClass.getMethod("start", null);
        method.invoke(bean, (Object[])null);
    }

    static void destroyMBean(Connector connector, Service service) throws Exception {
        connector.setService(service);
        String mname = MBeanUtils.createManagedName(connector);
        ManagedBean managed = registry.findManagedBean(mname);
        if (managed == null) {
            return;
        }
        String domain = managed.getDomain();
        if (domain == null) {
            domain = mserver.getDefaultDomain();
        }
        ObjectName oname = MBeanUtils.createObjectName(domain, connector);
        connector.setService(null);
        if (mserver.isRegistered(oname)) {
            mserver.unregisterMBean(oname);
        }
    }

    static void destroyMBean(Context context) throws Exception {
        ObjectName oname;
        String mname = MBeanUtils.createManagedName(context);
        ManagedBean managed = registry.findManagedBean(mname);
        if (managed == null) {
            return;
        }
        String domain = managed.getDomain();
        if (domain == null) {
            domain = mserver.getDefaultDomain();
        }
        if (mserver.isRegistered(oname = MBeanUtils.createObjectName(domain, context))) {
            mserver.unregisterMBean(oname);
        }
    }

    static void destroyMBean(ContextEnvironment environment) throws Exception {
        ObjectName oname;
        String mname = MBeanUtils.createManagedName(environment);
        ManagedBean managed = registry.findManagedBean(mname);
        if (managed == null) {
            return;
        }
        String domain = managed.getDomain();
        if (domain == null) {
            domain = mserver.getDefaultDomain();
        }
        if (mserver.isRegistered(oname = MBeanUtils.createObjectName(domain, environment))) {
            mserver.unregisterMBean(oname);
        }
    }

    static void destroyMBean(ContextResource resource) throws Exception {
        ObjectName oname;
        String mname = MBeanUtils.createManagedName(resource);
        ManagedBean managed = registry.findManagedBean(mname);
        if (managed == null) {
            return;
        }
        String domain = managed.getDomain();
        if (domain == null) {
            domain = mserver.getDefaultDomain();
        }
        if (mserver.isRegistered(oname = MBeanUtils.createObjectName(domain, resource))) {
            mserver.unregisterMBean(oname);
        }
    }

    static void destroyMBean(ContextResourceLink resourceLink) throws Exception {
        ObjectName oname;
        String mname = MBeanUtils.createManagedName(resourceLink);
        ManagedBean managed = registry.findManagedBean(mname);
        if (managed == null) {
            return;
        }
        String domain = managed.getDomain();
        if (domain == null) {
            domain = mserver.getDefaultDomain();
        }
        if (mserver.isRegistered(oname = MBeanUtils.createObjectName(domain, resourceLink))) {
            mserver.unregisterMBean(oname);
        }
    }

    static void destroyMBean(DefaultContext context) throws Exception {
        ObjectName oname;
        String mname = MBeanUtils.createManagedName(context);
        ManagedBean managed = registry.findManagedBean(mname);
        if (managed == null) {
            return;
        }
        String domain = managed.getDomain();
        if (domain == null) {
            domain = mserver.getDefaultDomain();
        }
        if (mserver.isRegistered(oname = MBeanUtils.createObjectName(domain, context))) {
            mserver.unregisterMBean(oname);
        }
    }

    static void destroyMBean(Engine engine) throws Exception {
        ObjectName oname;
        String mname = MBeanUtils.createManagedName(engine);
        ManagedBean managed = registry.findManagedBean(mname);
        if (managed == null) {
            return;
        }
        String domain = managed.getDomain();
        if (domain == null) {
            domain = mserver.getDefaultDomain();
        }
        if (mserver.isRegistered(oname = MBeanUtils.createObjectName(domain, engine))) {
            mserver.unregisterMBean(oname);
        }
    }

    static void destroyMBean(Host host) throws Exception {
        ObjectName oname;
        String mname = MBeanUtils.createManagedName(host);
        ManagedBean managed = registry.findManagedBean(mname);
        if (managed == null) {
            return;
        }
        String domain = managed.getDomain();
        if (domain == null) {
            domain = mserver.getDefaultDomain();
        }
        if (mserver.isRegistered(oname = MBeanUtils.createObjectName(domain, host))) {
            mserver.unregisterMBean(oname);
        }
    }

    static void destroyMBean(Loader loader) throws Exception {
        ObjectName oname;
        String mname = MBeanUtils.createManagedName(loader);
        ManagedBean managed = registry.findManagedBean(mname);
        if (managed == null) {
            return;
        }
        String domain = managed.getDomain();
        if (domain == null) {
            domain = mserver.getDefaultDomain();
        }
        if (mserver.isRegistered(oname = MBeanUtils.createObjectName(domain, loader))) {
            mserver.unregisterMBean(oname);
        }
    }

    static void destroyMBean(Logger logger) throws Exception {
        ObjectName oname;
        String mname = MBeanUtils.createManagedName(logger);
        ManagedBean managed = registry.findManagedBean(mname);
        if (managed == null) {
            return;
        }
        String domain = managed.getDomain();
        if (domain == null) {
            domain = mserver.getDefaultDomain();
        }
        if (mserver.isRegistered(oname = MBeanUtils.createObjectName(domain, logger))) {
            mserver.unregisterMBean(oname);
        }
    }

    static void destroyMBean(Manager manager) throws Exception {
        ObjectName oname;
        String mname = MBeanUtils.createManagedName(manager);
        ManagedBean managed = registry.findManagedBean(mname);
        if (managed == null) {
            return;
        }
        String domain = managed.getDomain();
        if (domain == null) {
            domain = mserver.getDefaultDomain();
        }
        if (mserver.isRegistered(oname = MBeanUtils.createObjectName(domain, manager))) {
            mserver.unregisterMBean(oname);
        }
    }

    static void destroyMBean(NamingResources resources) throws Exception {
        ObjectName oname;
        String mname = MBeanUtils.createManagedName(resources);
        ManagedBean managed = registry.findManagedBean(mname);
        if (managed == null) {
            return;
        }
        String domain = managed.getDomain();
        if (domain == null) {
            domain = mserver.getDefaultDomain();
        }
        if (mserver.isRegistered(oname = MBeanUtils.createObjectName(domain, resources))) {
            mserver.unregisterMBean(oname);
        }
    }

    static void destroyMBean(Realm realm) throws Exception {
        ObjectName oname;
        String mname = MBeanUtils.createManagedName(realm);
        ManagedBean managed = registry.findManagedBean(mname);
        if (managed == null) {
            return;
        }
        String domain = managed.getDomain();
        if (domain == null) {
            domain = mserver.getDefaultDomain();
        }
        if (mserver.isRegistered(oname = MBeanUtils.createObjectName(domain, realm))) {
            mserver.unregisterMBean(oname);
        }
    }

    static void destroyMBean(Server server) throws Exception {
        ObjectName oname;
        String mname = MBeanUtils.createManagedName(server);
        ManagedBean managed = registry.findManagedBean(mname);
        if (managed == null) {
            return;
        }
        String domain = managed.getDomain();
        if (domain == null) {
            domain = mserver.getDefaultDomain();
        }
        if (mserver.isRegistered(oname = MBeanUtils.createObjectName(domain, server))) {
            mserver.unregisterMBean(oname);
        }
    }

    static void destroyMBean(Service service) throws Exception {
        ObjectName oname;
        String mname = MBeanUtils.createManagedName(service);
        ManagedBean managed = registry.findManagedBean(mname);
        if (managed == null) {
            return;
        }
        String domain = managed.getDomain();
        if (domain == null) {
            domain = mserver.getDefaultDomain();
        }
        if (mserver.isRegistered(oname = MBeanUtils.createObjectName(domain, service))) {
            mserver.unregisterMBean(oname);
        }
    }

    static void destroyMBean(GlassFishValve valve, Container container) throws Exception {
        ((Contained)((Object)valve)).setContainer(container);
        String mname = MBeanUtils.createManagedName(valve);
        ManagedBean managed = registry.findManagedBean(mname);
        if (managed == null) {
            return;
        }
        String domain = managed.getDomain();
        if (domain == null) {
            domain = mserver.getDefaultDomain();
        }
        ObjectName oname = MBeanUtils.createObjectName(domain, valve);
        try {
            ((Contained)((Object)valve)).setContainer(null);
        }
        catch (Throwable t) {
            // empty catch block
        }
        if (mserver.isRegistered(oname)) {
            mserver.unregisterMBean(oname);
        }
    }
}

