/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.impl.interceptors;

import com.sun.corba.ee.impl.interceptors.SlotTable;
import com.sun.corba.ee.impl.logging.InterceptorsSystemException;
import com.sun.corba.ee.spi.orb.ORB;
import java.util.ArrayList;
import java.util.List;

public class SlotTableStack {
    private List<SlotTable> tableContainer;
    private int currentIndex;
    private SlotTablePool tablePool;
    private ORB orb;
    private InterceptorsSystemException wrapper;

    SlotTableStack(ORB orb, SlotTable table) {
        this.orb = orb;
        this.wrapper = orb.getLogWrapperTable().get_RPC_PROTOCOL_Interceptors();
        this.currentIndex = 0;
        this.tableContainer = new ArrayList<SlotTable>();
        this.tablePool = new SlotTablePool();
        this.tableContainer.add(this.currentIndex, table);
        ++this.currentIndex;
    }

    void pushSlotTable() {
        SlotTable table = this.tablePool.getSlotTable();
        if (table == null) {
            SlotTable tableTemp = this.peekSlotTable();
            table = new SlotTable(this.orb, tableTemp.getSize());
        }
        if (this.currentIndex == this.tableContainer.size()) {
            this.tableContainer.add(this.currentIndex, table);
        } else {
            if (this.currentIndex > this.tableContainer.size()) {
                throw this.wrapper.slotTableInvariant(this.currentIndex, this.tableContainer.size());
            }
            this.tableContainer.set(this.currentIndex, table);
        }
        ++this.currentIndex;
    }

    void popSlotTable() {
        if (this.currentIndex <= 1) {
            throw this.wrapper.cantPopOnlyPicurrent();
        }
        --this.currentIndex;
        SlotTable table = this.tableContainer.get(this.currentIndex);
        this.tableContainer.set(this.currentIndex, null);
        table.resetSlots();
        this.tablePool.putSlotTable(table);
    }

    SlotTable peekSlotTable() {
        return this.tableContainer.get(this.currentIndex - 1);
    }

    private class SlotTablePool {
        private SlotTable[] pool = new SlotTable[5];
        private final int HIGH_WATER_MARK = 5;
        private int currentIndex = 0;

        SlotTablePool() {
        }

        void putSlotTable(SlotTable table) {
            if (this.currentIndex >= 5) {
                return;
            }
            this.pool[this.currentIndex] = table;
            ++this.currentIndex;
        }

        SlotTable getSlotTable() {
            if (this.currentIndex == 0) {
                return null;
            }
            --this.currentIndex;
            return this.pool[this.currentIndex];
        }
    }
}

