/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.impl.osgi.loader;

import com.sun.corba.ee.spi.orbutil.generic.UnaryFunction;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Map;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.osgi.framework.SynchronousBundleListener;

public class OSGIListener
implements BundleActivator,
SynchronousBundleListener {
    private static final String ORB_PROVIDER_KEY = "ORB-Class-Provider";
    private static Map<String, Bundle> classNameMap = new HashMap<String, Bundle>();
    private static final boolean DEBUG = Boolean.getBoolean("com.sun.corba.ee.ORBDebugOSGIListener");
    private static UnaryFunction<String, Class<?>> classNameResolver = new ClassNameResolverImpl();

    private static synchronized void mapContents() {
        if (DEBUG) {
            OSGIListener.msg("Contents of classNameMap:");
            for (Map.Entry<String, Bundle> entry : classNameMap.entrySet()) {
                OSGIListener.msg(entry.getKey() + "=>" + entry.getValue().getSymbolicName());
            }
        }
    }

    private static void msg(String arg) {
        ClassLoader cl = OSGIListener.class.getClassLoader();
        System.out.println("OSGIListener(" + cl + "): " + arg);
    }

    private static String getBundleEventType(int type) {
        if (type == 1) {
            return "INSTALLED";
        }
        if (type == 512) {
            return "LAZY_ACTIVATION";
        }
        if (type == 32) {
            return "RESOLVED";
        }
        if (type == 2) {
            return "STARTED";
        }
        if (type == 128) {
            return "STARTING";
        }
        if (type == 4) {
            return "STOPPED";
        }
        if (type == 256) {
            return "STOPPING";
        }
        if (type == 16) {
            return "UNINSTALLED";
        }
        if (type == 64) {
            return "UNRESOLVED";
        }
        if (type == 8) {
            return "UPDATED";
        }
        return "ILLEGAL-EVENT-TYPE";
    }

    public static UnaryFunction<String, Class<?>> classNameResolver() {
        return classNameResolver;
    }

    private static synchronized void insertORBProviders(Bundle bundle) {
        String orbProvider;
        Dictionary dict = bundle.getHeaders();
        String name = bundle.getSymbolicName();
        if (dict != null && (orbProvider = (String)dict.get(ORB_PROVIDER_KEY)) != null) {
            for (String className : orbProvider.split(",")) {
                if (DEBUG) {
                    OSGIListener.msg("Inserting: Bundle " + name + " provides ORB class \"" + className + "\"");
                }
                classNameMap.put(className, bundle);
            }
        }
    }

    private static synchronized void removeORBProviders(Bundle bundle) {
        String orbProvider;
        Dictionary dict = bundle.getHeaders();
        String name = bundle.getSymbolicName();
        if (dict != null && (orbProvider = (String)dict.get(ORB_PROVIDER_KEY)) != null) {
            for (String className : orbProvider.split(",")) {
                classNameMap.remove(className);
                if (!DEBUG) continue;
                OSGIListener.msg("Removing: Bundle " + name + " provides ORB class \"" + className + "\"");
            }
        }
    }

    private static synchronized Bundle getBundleForClass(String className) {
        return classNameMap.get(className);
    }

    public void start(BundleContext context) {
        context.addBundleListener((BundleListener)this);
        if (DEBUG) {
            OSGIListener.msg("Starting up: probing all existing bundles for providers");
        }
        for (Bundle bundle : context.getBundles()) {
            OSGIListener.insertORBProviders(bundle);
        }
        OSGIListener.mapContents();
    }

    public void stop(BundleContext context) {
        Bundle myBundle = context.getBundle();
        OSGIListener.removeORBProviders(myBundle);
        OSGIListener.mapContents();
    }

    public void bundleChanged(BundleEvent event) {
        int type = event.getType();
        Bundle bundle = event.getBundle();
        String name = bundle.getSymbolicName();
        if (DEBUG) {
            OSGIListener.msg("Event type " + OSGIListener.getBundleEventType(type) + " on bundle " + name);
        }
        if (type == 2) {
            OSGIListener.insertORBProviders(bundle);
        } else if (type == 1) {
            OSGIListener.removeORBProviders(bundle);
        }
        OSGIListener.mapContents();
    }

    private static class ClassNameResolverImpl
    implements UnaryFunction<String, Class<?>> {
        private ClassNameResolverImpl() {
        }

        public Class<?> evaluate(String arg) {
            Bundle bundle;
            if (DEBUG) {
                OSGIListener.msg("Looking for class \"" + arg + "\"");
            }
            if ((bundle = OSGIListener.getBundleForClass(arg)) == null) {
                if (DEBUG) {
                    OSGIListener.msg("Class not found");
                }
                return null;
            }
            if (DEBUG) {
                OSGIListener.msg("Found class in bundle " + bundle);
            }
            try {
                return bundle.loadClass(arg);
            }
            catch (ClassNotFoundException ex) {
                throw new RuntimeException(ex);
            }
        }

        public String toString() {
            return "OSGiClassNameResolver";
        }
    }
}

