/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.naming.util;

import com.sun.enterprise.naming.util.ObjectInputOutputStreamFactory;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.OutputStream;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.packageadmin.PackageAdmin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OSGiObjectInputOutputStreamFactoryImpl
implements ObjectInputOutputStreamFactory {
    private BundleContext ctx;
    PackageAdmin pkgAdm;
    private static final long NOT_A_BUNDLE_ID = -1L;

    public OSGiObjectInputOutputStreamFactoryImpl(BundleContext ctx) {
        this.ctx = ctx;
        ServiceReference ref = ctx.getServiceReference(PackageAdmin.class.getName());
        this.pkgAdm = (PackageAdmin)PackageAdmin.class.cast(ctx.getService(ref));
    }

    @Override
    public ObjectInputStream createObjectInputStream(InputStream in) throws IOException {
        return new OSGiObjectInputStream(in);
    }

    @Override
    public ObjectOutputStream createObjectOutputStream(OutputStream out) throws IOException {
        return new OSGiObjectOutputStream(out);
    }

    @Override
    public Class<?> resolveClass(ObjectInputStream in, ObjectStreamClass desc) throws IOException, ClassNotFoundException {
        long bundleId = in.readLong();
        if (bundleId != -1L) {
            Bundle b = this.ctx.getBundle(bundleId);
            return b.loadClass(desc.getName());
        }
        return null;
    }

    @Override
    public void annotateClass(ObjectOutputStream out, Class<?> cl) throws IOException {
        long id = -1L;
        Bundle b = this.pkgAdm.getBundle(cl);
        if (b != null) {
            id = b.getBundleId();
        }
        out.writeLong(id);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class OSGiObjectInputStream
    extends ObjectInputStream {
        public OSGiObjectInputStream(InputStream in) throws IOException {
            super(in);
        }

        @Override
        protected Class<?> resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
            Class<?> clazz = OSGiObjectInputOutputStreamFactoryImpl.this.resolveClass(this, desc);
            if (clazz == null) {
                clazz = super.resolveClass(desc);
            }
            return clazz;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class OSGiObjectOutputStream
    extends ObjectOutputStream {
        private OSGiObjectOutputStream(OutputStream out) throws IOException {
            super(out);
        }

        @Override
        protected void annotateClass(Class<?> cl) throws IOException {
            OSGiObjectInputOutputStreamFactoryImpl.this.annotateClass(this, cl);
        }
    }
}

