/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.webservices.monitoring;

import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.WebServiceEndpoint;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;
import org.glassfish.external.probe.provider.annotations.ProbeListener;
import org.glassfish.external.probe.provider.annotations.ProbeParam;
import org.glassfish.gmbal.Description;
import org.glassfish.gmbal.ManagedAttribute;
import org.glassfish.gmbal.ManagedObject;
import org.glassfish.webservices.monitoring.Deployment109EndpointData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ManagedObject
@Description(value="Stats for Web Services deployed using 109 deployment")
public class Deployment109StatsProvider {
    private final ConcurrentHashMap<String, Deployment109EndpointData> endpoints = new ConcurrentHashMap();
    private final Logger logger = Logger.getLogger(Deployment109StatsProvider.class.getName());

    @ProbeListener(value="glassfish:webservices:109:deploy")
    public void deploy(@ProbeParam(value="name") String name, @ProbeParam(value="app") Application app, @ProbeParam(value="endpoint") WebServiceEndpoint endpoint) {
        Deployment109EndpointData data = new Deployment109EndpointData(app, endpoint);
        this.endpoints.put(name, data);
    }

    @ProbeListener(value="glassfish:webservices:109:undeploy")
    public void undeploy(@ProbeParam(value="name") String name) {
        this.endpoints.remove(name);
    }

    @ManagedAttribute
    @Description(value="Endpoints with 109 deployment")
    public Collection<Deployment109EndpointData> getEndpoints() {
        return Collections.unmodifiableCollection(this.endpoints.values());
    }
}

