/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.cli.optional;

import com.sun.appserv.management.client.prefs.LoginInfo;
import com.sun.appserv.management.client.prefs.LoginInfoStore;
import com.sun.appserv.management.client.prefs.LoginInfoStoreFactory;
import com.sun.enterprise.admin.cli.optional.BaseLifeCycleCommand;
import com.sun.enterprise.admin.servermgmt.DomainConfig;
import com.sun.enterprise.admin.servermgmt.pe.PEDomainsManager;
import com.sun.enterprise.cli.framework.CLILogger;
import com.sun.enterprise.cli.framework.CommandException;
import com.sun.enterprise.cli.framework.CommandValidationException;
import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.util.io.FileUtils;
import com.sun.enterprise.util.net.NetUtils;
import com.sun.logging.LogDomains;
import java.io.File;
import java.util.Properties;
import java.util.StringTokenizer;
import org.glassfish.api.admin.config.Container;
import org.glassfish.api.admin.config.DomainContext;
import org.glassfish.api.admin.config.DomainInitializer;
import org.glassfish.api.embedded.LifecycleException;
import org.glassfish.api.embedded.Server;
import org.jvnet.hk2.component.Habitat;

public class CreateDomainCommand
extends BaseLifeCycleCommand {
    private static final String DOMAIN_PATH = "path";
    private static final String INSTANCE_PORT = "instanceport";
    private static final String DOCROOT = "docroot";
    private static final String TEMPLATE = "template";
    private static final String DOMAIN_PROPERTIES = "domainproperties";
    private static final String CHECKPORTS_OPTION = "checkports";
    private static final String PORTBASE_OPTION = "portbase";
    private static final int DEFAULT_HTTPSSL_PORT = 8181;
    private static final int DEFAULT_IIOPSSL_PORT = 3820;
    private static final int DEFAULT_IIOPMUTUALAUTH_PORT = 3920;
    private static final int DEFAULT_INSTANCE_PORT = 8080;
    private static final int DEFAULT_JMS_PORT = 7676;
    private static final String DEFAULT_JMS_USER = "admin";
    private static final String DEFAULT_JMS_PASSWORD = "admin";
    private static final int DEFAULT_IIOP_PORT = 3700;
    private static final int DEFAULT_JMX_PORT = 8686;
    private static final int PORT_MAX_VAL = 65535;
    private static final int PORTBASE_ADMINPORT_SUFFIX = 48;
    private static final int PORTBASE_HTTPSSL_SUFFIX = 81;
    private static final int PORTBASE_IIOPSSL_SUFFIX = 38;
    private static final int PORTBASE_IIOPMUTUALAUTH_SUFFIX = 39;
    private static final int PORTBASE_INSTANCE_SUFFIX = 80;
    private static final int PORTBASE_JMS_SUFFIX = 76;
    private static final int PORTBASE_IIOP_SUFFIX = 37;
    private static final int PORTBASE_JMX_SUFFIX = 86;
    public static final String DOMAINDIR_OPTION = "domaindir";
    public static final String PROFILE_OPTION = "profile";
    private static final String SAVELOGIN_OPTION = "savelogin";
    private static final String KEYTOOLOPTIONS = "keytooloptions";
    private String domainName = null;
    private String adminUser = null;
    private String adminPassword = null;
    private String masterPassword = null;
    private boolean checkPorts;

    public boolean validateOptions() throws CommandValidationException {
        boolean ret = super.validateOptions();
        this.checkPorts = this.getBooleanOption(CHECKPORTS_OPTION);
        return ret;
    }

    public void verifyPortBase() throws CommandValidationException {
        if (this.usePortBase()) {
            int portbase = this.convertPortStr(this.getOption(PORTBASE_OPTION));
            this.setOptionsWithPortBase(portbase);
        } else if (this.getOption("adminport") == null) {
            throw new CommandValidationException(this.getLocalizedString("RequireEitherOrOption", new Object[]{"adminport", PORTBASE_OPTION}));
        }
    }

    private void setOptionsWithPortBase(int portbase) throws CommandValidationException {
        this.verifyPortBasePortIsValid("adminport", portbase + 48);
        this.setOption("adminport", String.valueOf(portbase + 48));
        this.verifyPortBasePortIsValid(INSTANCE_PORT, portbase + 80);
        this.setOption(INSTANCE_PORT, String.valueOf(portbase + 80));
        StringBuffer sb = new StringBuffer();
        this.verifyPortBasePortIsValid("http.ssl.port", portbase + 81);
        sb.append("http.ssl.port");
        sb.append("=");
        sb.append(String.valueOf(portbase + 81));
        sb.append(":");
        this.verifyPortBasePortIsValid("orb.ssl.port", portbase + 38);
        sb.append("orb.ssl.port");
        sb.append("=");
        sb.append(String.valueOf(portbase + 38));
        sb.append(":");
        this.verifyPortBasePortIsValid("orb.mutualauth.port", portbase + 39);
        sb.append("orb.mutualauth.port");
        sb.append("=");
        sb.append(String.valueOf(portbase + 39));
        sb.append(":");
        this.verifyPortBasePortIsValid("jms.port", portbase + 76);
        sb.append("jms.port");
        sb.append("=");
        sb.append(String.valueOf(portbase + 76));
        sb.append(":");
        this.verifyPortBasePortIsValid("orb.listener.port", portbase + 37);
        sb.append("orb.listener.port");
        sb.append("=");
        sb.append(String.valueOf(portbase + 37));
        sb.append(":");
        this.verifyPortBasePortIsValid("domain.jmxPort", portbase + 86);
        sb.append("domain.jmxPort");
        sb.append("=");
        sb.append(String.valueOf(portbase + 86));
        this.setOption(DOMAIN_PROPERTIES, sb.toString());
    }

    public void validatePassword(String password, String type) throws CommandValidationException {
        if (!this.isPasswordValid(password)) {
            throw new CommandValidationException(this.getLocalizedString("PasswordLimit", new Object[]{type}));
        }
        CLILogger.getInstance().printDebugMessage("domainName = " + this.domainName);
    }

    protected String getAdminPassword() throws CommandValidationException, CommandException {
        String deprecatePassword = this.getPassword("adminpassword", true, false, true, false, null, null, false, false, false, false);
        String tempPassword = null;
        if (deprecatePassword != null) {
            return deprecatePassword;
        }
        tempPassword = this.getPassword("password", "AdminPasswordPrompt", "AdminPasswordConfirmationPrompt", true, false, false, false, null, null, true, true, true, true);
        return tempPassword;
    }

    public void runCommand() throws CommandException, CommandValidationException {
        this.validateOptions();
        try {
            this.domainName = (String)this.operands.firstElement();
            PEDomainsManager manager = new PEDomainsManager();
            DomainConfig config = this.getDomainConfig(this.domainName);
            manager.validateDomain(config, false);
            this.verifyPortBase();
        }
        catch (Exception e) {
            CLILogger.getInstance().printDetailMessage(e.getLocalizedMessage());
            throw new CommandException(this.getLocalizedString("CouldNotCreateDomain", new Object[]{this.domainName}), (Throwable)e);
        }
        this.adminUser = this.getAdminUser();
        if (this.adminUser == null || this.adminUser.length() == 0) {
            this.adminUser = "anonymous";
            this.adminPassword = "";
            this.masterPassword = "changeit";
        } else if (this.adminUser.equals("anonymous") && (this.adminPassword == null || this.adminPassword.length() == 0)) {
            this.adminPassword = "";
            this.masterPassword = "changeit";
        } else {
            this.adminPassword = this.getAdminPassword();
            this.validatePassword(this.adminPassword, "adminpassword");
            this.masterPassword = this.getMasterPassword();
            this.validatePassword(this.masterPassword, "masterpassword");
        }
        try {
            if (this.getOption("adminport") != null) {
                this.verifyPortIsValid(this.getOption("adminport"));
            }
            if (this.getOption(INSTANCE_PORT) != null) {
                this.verifyPortIsValid(this.getOption(INSTANCE_PORT));
            }
            Properties domainProperties = this.getDomainProperties(this.getOption(DOMAIN_PROPERTIES));
            domainProperties.remove("domain.adminPort");
            this.createTheDomain(this.getDomainsRoot(), domainProperties);
        }
        catch (Exception e) {
            CLILogger.getInstance().printDetailMessage(e.getLocalizedMessage());
            throw new CommandException(this.getLocalizedString("CouldNotCreateDomain", new Object[]{this.domainName}), (Throwable)e);
        }
    }

    private void verifyPortIsValid(String portNum) throws CommandException, CommandValidationException {
        int portToVerify = this.convertPortStr(portNum);
        NetUtils.PortAvailability avail = NetUtils.checkPort((int)portToVerify);
        System.out.println(" *******************" + ((Object)((Object)this)).getClass().getName() + " *******************");
        switch (avail) {
            case illegalNumber: {
                throw new CommandException(this.getLocalizedString("InvalidPortRange", new Object[]{portNum}));
            }
            case inUse: {
                if (this.checkPorts) {
                    throw new CommandException(this.getLocalizedString("PortInUseError", new Object[]{(String)this.operands.firstElement(), portNum}));
                }
                CLILogger.getInstance().printWarning(this.getLocalizedString("PortInUseWarning", new Object[]{portNum}));
                break;
            }
            case noPermission: {
                throw new CommandException(this.getLocalizedString("NoPermissionForPortMsg", new Object[]{portNum, (String)this.operands.firstElement()}));
            }
            case unknown: {
                throw new CommandException(this.getLocalizedString("UnknownPortMsg", new Object[]{portNum}));
            }
            case OK: {
                CLILogger.getInstance().printDebugMessage("Port =" + portToVerify);
            }
        }
    }

    private int convertPortStr(String port) throws CommandValidationException {
        try {
            return Integer.parseInt(port);
        }
        catch (Exception e) {
            throw new CommandValidationException(this.getLocalizedString("InvalidPortNumber", new Object[]{port}));
        }
    }

    private void verifyPortBasePortIsValid(String portName, int portNum) throws CommandValidationException {
        if (portNum <= 0 || portNum > 65535) {
            throw new CommandValidationException(this.getLocalizedString("InvalidPortBaseRange", new Object[]{portNum, portName}));
        }
        if (this.checkPorts && !NetUtils.isPortFree((int)portNum)) {
            throw new CommandValidationException(this.getLocalizedString("PortBasePortInUse", new Object[]{portNum, portName}));
        }
        CLILogger.getInstance().printDebugMessage("Port =" + portNum);
    }

    private Properties getDomainProperties(String propertyValues) throws CommandException, CommandValidationException {
        Properties propertyList = new Properties();
        if (propertyValues == null) {
            return propertyList;
        }
        StringTokenizer st = new StringTokenizer(propertyValues, ":");
        while (st.hasMoreTokens()) {
            String propertyString = st.nextToken();
            while (st.hasMoreTokens() && propertyString.endsWith(Character.toString('\\'))) {
                propertyString = propertyString.concat(st.nextToken());
            }
            int index = propertyString.indexOf(Character.toString('='));
            if (index == -1) {
                throw new CommandValidationException(this.getLocalizedString("InvalidPropertySyntax"));
            }
            String propertyName = propertyString.substring(0, index);
            String propertyValue = propertyString.substring(index + 1);
            propertyList.put(propertyName, propertyValue);
        }
        CLILogger.getInstance().printDebugMessage("domain properties = " + propertyList);
        return propertyList;
    }

    private void createTheDomain(String domainPath, Properties domainProperties) throws Exception {
        Integer adminPort = Integer.valueOf(this.getOption("adminport"));
        CLILogger.getInstance().printDetailMessage(this.getLocalizedString("UsingPort", new Object[]{"Admin", Integer.toString(adminPort)}));
        String domainFilePath = domainPath + File.separator + this.domainName;
        if (FileUtils.safeGetCanonicalFile((File)new File(domainFilePath)).exists()) {
            throw new CommandValidationException(this.getLocalizedString("DomainExists", new Object[]{this.domainName}));
        }
        Integer instancePort = this.getPort(domainProperties, "domain.instancePort", this.getOption(INSTANCE_PORT), Integer.toString(8080), "HTTP Instance");
        Integer jmsPort = this.getPort(domainProperties, "jms.port", null, Integer.toString(7676), "JMS");
        String jmsUser = "admin";
        String jmsPassword = "admin";
        Integer orbPort = this.getPort(domainProperties, "orb.listener.port", null, Integer.toString(3700), "IIOP");
        Integer httpSSLPort = this.getPort(domainProperties, "http.ssl.port", null, Integer.toString(8181), "HTTP_SSL");
        Integer iiopSSLPort = this.getPort(domainProperties, "orb.ssl.port", null, Integer.toString(3820), "IIOP_SSL");
        Integer iiopMutualAuthPort = this.getPort(domainProperties, "orb.mutualauth.port", null, Integer.toString(3920), "IIOP_MUTUALAUTH");
        Integer jmxPort = this.getPort(domainProperties, "domain.jmxPort", null, Integer.toString(8686), "JMX_ADMIN");
        Boolean saveMasterPassword = this.getSaveMasterPassword(this.masterPassword);
        this.checkPortPrivilege(new Integer[]{adminPort, instancePort, jmsPort, orbPort, httpSSLPort, jmsPort, orbPort, httpSSLPort, iiopSSLPort, iiopMutualAuthPort, jmxPort});
        DomainConfig domainConfig = new DomainConfig(this.domainName, adminPort, domainPath, this.adminUser, this.adminPassword, this.masterPassword, saveMasterPassword, instancePort, "admin", "admin", jmsPort, orbPort, httpSSLPort, iiopSSLPort, iiopMutualAuthPort, jmxPort, domainProperties);
        if (this.getOption(TEMPLATE) != null) {
            domainConfig.put((Object)"template.name", (Object)this.getOption(TEMPLATE));
        }
        domainConfig.put((Object)"domain.validatePorts", (Object)this.checkPorts);
        domainConfig.put((Object)KEYTOOLOPTIONS, (Object)this.getOption(KEYTOOLOPTIONS));
        PEDomainsManager manager = new PEDomainsManager();
        manager.createDomain(domainConfig);
        CLILogger.getInstance().printMessage(this.getLocalizedString("DomainCreated", new Object[]{this.domainName}));
        if (this.getBooleanOption(SAVELOGIN_OPTION)) {
            this.saveLogin(adminPort, this.adminUser, this.adminPassword, this.domainName);
        }
    }

    private void setUsageProfile(DomainConfig dc) {
        String pp = this.getCLOption(PROFILE_OPTION);
        String source = this.getLocalizedString("ProfileUserSource");
        if (pp == null) {
            pp = this.getOption(PROFILE_OPTION);
            source = this.getLocalizedString("ProfileConfigFileSource");
        }
        if (pp == null) {
            pp = "developer";
            source = this.getLocalizedString("ProfileGlobalDefaultSource");
        }
        dc.put((Object)"domain.profile", (Object)pp);
        Object[] args = new String[]{pp, source};
        String msg = this.getLocalizedString("UsingProfile", args);
        String templateName = this.getOption(TEMPLATE);
        if (templateName != null) {
            msg = this.getLocalizedString("UsingTemplate", new String[]{templateName});
        }
        CLILogger.getInstance().printMessage(msg);
    }

    private void saveLogin(int port, String user, String password, String dn) {
        block3: {
            CLILogger logger = CLILogger.getInstance();
            try {
                String msg;
                Object[] params;
                LoginInfoStore store = LoginInfoStoreFactory.getStore(null);
                LoginInfo login = new LoginInfo("localhost", port, user, password);
                if (store.exists(login.getHost(), login.getPort())) {
                    params = new Object[]{login.getHost(), "" + login.getPort()};
                    msg = this.getLocalizedString("OverwriteLoginMsgCreateDomain", params);
                    logger.printMessage(msg);
                }
                store.store(login, true);
                params = new String[]{user, dn, store.getName()};
                msg = this.getLocalizedString("LoginInfoStoredCreateDomain", params);
                logger.printMessage(msg);
            }
            catch (Exception e) {
                Object[] params = new String[]{user, dn};
                String msg = this.getLocalizedString("LoginInfoNotStoredCreateDomain", params);
                logger.printWarning(msg);
                if (!logger.isDebug()) break block3;
                logger.printExceptionStackTrace((Throwable)e);
            }
        }
    }

    private Integer getPort(Properties properties, String key, String portStr, String defaultPort, String name) throws CommandValidationException {
        int port = 0;
        boolean portNotSpecified = false;
        boolean invalidPortSpecified = false;
        boolean defaultPortUsed = false;
        if (portStr != null && !portStr.equals("")) {
            port = this.convertPortStr(portStr);
            if (port <= 0 || port > 65535) {
                invalidPortSpecified = true;
            }
        } else if (properties != null) {
            String property = properties.getProperty(key);
            if (property != null && !property.equals("")) {
                port = this.convertPortStr(property);
            } else {
                portNotSpecified = true;
            }
        } else {
            portNotSpecified = true;
        }
        if (portNotSpecified) {
            port = this.convertPortStr(defaultPort);
            defaultPortUsed = true;
        }
        if (this.checkPorts && !NetUtils.isPortFree((int)port)) {
            port = NetUtils.getFreePort();
            if (portNotSpecified) {
                if (defaultPortUsed) {
                    CLILogger.getInstance().printDetailMessage(this.getLocalizedString("DefaultPortInUse", new Object[]{name, defaultPort, Integer.toString(port)}));
                } else {
                    CLILogger.getInstance().printDetailMessage(this.getLocalizedString("PortNotSpecified", new Object[]{name, port}));
                }
            } else if (invalidPortSpecified) {
                CLILogger.getInstance().printDetailMessage(this.getLocalizedString("InvalidPortRangeMsg", new Object[]{name, port}));
            } else {
                CLILogger.getInstance().printDetailMessage(this.getLocalizedString("PortInUseError", new Object[]{name, port}));
            }
        } else if (defaultPortUsed) {
            CLILogger.getInstance().printDetailMessage(this.getLocalizedString("UsingDefaultPort", new Object[]{name, Integer.toString(port)}));
        } else {
            CLILogger.getInstance().printDetailMessage(this.getLocalizedString("UsingPort", new Object[]{name, Integer.toString(port)}));
        }
        if (properties != null) {
            properties.remove(key);
        }
        return port;
    }

    private boolean usePortBase() throws CommandValidationException {
        if (this.getOption(PORTBASE_OPTION) != null) {
            if (this.getCLOption("adminport") != null) {
                throw new CommandValidationException(this.getLocalizedString("MutuallyExclusiveOption", new Object[]{"adminport", PORTBASE_OPTION}));
            }
            if (this.getOption(INSTANCE_PORT) != null) {
                throw new CommandValidationException(this.getLocalizedString("MutuallyExclusiveOption", new Object[]{INSTANCE_PORT, PORTBASE_OPTION}));
            }
            if (this.getOption(DOMAIN_PROPERTIES) != null) {
                throw new CommandValidationException(this.getLocalizedString("MutuallyExclusiveOption", new Object[]{DOMAIN_PROPERTIES, PORTBASE_OPTION}));
            }
            return true;
        }
        return false;
    }

    private void checkPortPrivilege(Integer[] ports) {
        for (Integer port : ports) {
            int p = port;
            if (p >= 1024) continue;
            CLILogger.getInstance().printWarning(this.getLocalizedString("PortPrivilege"));
            break;
        }
    }

    private String getMasterPassword() throws CommandValidationException, CommandException {
        String mpassword = this.getPassword("masterpassword", "", "", false, false, false, false, null, null, false, false, false, false);
        if (mpassword != null) {
            return mpassword;
        }
        if (this.getOption("adminpassword") != null || this.getOption("password") != null) {
            return "changeit";
        }
        mpassword = this.promptMasterPassword();
        if (this.isPasswordValid(mpassword)) {
            return mpassword;
        }
        throw new CommandValidationException(this.getLocalizedString("PasswordLimit", new Object[]{"masterpassword"}));
    }

    private String promptMasterPassword() throws CommandValidationException {
        String optionValueAgain;
        String optionValue = this.getInteractiveOption("masterpassword", this.getLocalizedString("MasterPasswordWithDefaultPrompt"));
        if (optionValue.length() == 0) {
            optionValue = "changeit";
        }
        if ((optionValueAgain = this.getInteractiveOption("masterpassword", this.getLocalizedString("MasterPasswordConfirmationWithDefaultPrompt"))).length() == 0) {
            optionValueAgain = "changeit";
        }
        if (!optionValue.equals(optionValueAgain)) {
            throw new CommandValidationException(this.getLocalizedString("OptionsDoNotMatch", new Object[]{"masterpassword"}));
        }
        return optionValue;
    }

    private void modifyInitialDomainXml() throws LifecycleException {
        org.glassfish.api.embedded.Server server = new Server.Builder("dummylaunch").build();
        server.start();
        Habitat habitat = server.getHabitat();
        Server serverConfig = (Server)habitat.getComponent(Server.class, "server");
        Config config = (Config)habitat.getComponent(Config.class, serverConfig.getConfigRef());
        DomainContext ctx = new DomainContext();
        ctx.setDomainType("dev");
        ctx.setLogger(LogDomains.getLogger(DomainInitializer.class, (String)"javax.enterprise.system"));
        for (DomainInitializer inhabitant : habitat.getAllByContract(DomainInitializer.class)) {
            Container newContainerConfig = inhabitant.getInitialConfig(ctx);
            config.getContainers().add(newContainerConfig);
        }
        server.stop();
    }
}

