/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.cli.optional;

import com.sun.enterprise.admin.cli.optional.BaseLifeCycleCommand;
import com.sun.enterprise.admin.cli.remote.CLIRemoteCommand;
import com.sun.enterprise.admin.cli.remote.CommandInvoker;
import com.sun.enterprise.admin.launcher.GFLauncher;
import com.sun.enterprise.admin.launcher.GFLauncherException;
import com.sun.enterprise.admin.launcher.GFLauncherFactory;
import com.sun.enterprise.admin.launcher.GFLauncherInfo;
import com.sun.enterprise.admin.servermgmt.DomainConfig;
import com.sun.enterprise.admin.servermgmt.pe.PEDomainsManager;
import com.sun.enterprise.cli.framework.CLILogger;
import com.sun.enterprise.cli.framework.CommandException;
import com.sun.enterprise.cli.framework.CommandValidationException;
import com.sun.enterprise.universal.xml.MiniXmlParserException;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.util.Set;

public class ListDomainsCommand
extends BaseLifeCycleCommand {
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(ListDomainsCommand.class);

    public boolean validateOptions() throws CommandValidationException {
        return super.validateOptions();
    }

    public void runCommand() throws CommandException, CommandValidationException {
        if (!this.validateOptions()) {
            throw new CommandValidationException("Validation failed");
        }
        try {
            DomainConfig domainConfig = new DomainConfig(null, this.getDomainsRoot());
            PEDomainsManager manager = new PEDomainsManager();
            String[] domainsList = manager.listDomains(domainConfig);
            if (domainsList.length > 0) {
                for (int i = 0; i < domainsList.length; ++i) {
                    String dn = domainsList[i];
                    String status = this.getStatus(dn);
                    String name = localStrings.getLocalString("list.domains.Name", "Name:");
                    CLILogger.getInstance().printMessage(name + " " + dn + " " + status);
                }
            } else {
                CLILogger.getInstance().printDetailMessage(this.getLocalizedString("NoDomainsToList"));
            }
        }
        catch (Exception ex) {
            CLILogger.getInstance().printDetailMessage(ex.getLocalizedMessage());
            throw new CommandException(this.getLocalizedString("CommandUnSuccessful", new Object[]{this.name}), (Throwable)ex);
        }
    }

    private String getStatus(String dn) {
        try {
            GFLauncher launcher = GFLauncherFactory.getInstance((GFLauncherFactory.ServerType)GFLauncherFactory.ServerType.domain);
            GFLauncherInfo li = launcher.getInfo();
            String parent = this.getOption("domaindir");
            if (parent != null) {
                li.setDomainParentDir(parent);
            }
            launcher.getInfo().setDomainName(dn);
            launcher.setup();
            Set adminPorts = launcher.getInfo().getAdminPorts();
            boolean status = this.isServerAlive(adminPorts.toArray(new Integer[0])[0]);
            if (status) {
                return localStrings.getLocalString("list.domains.StatusRunning", "Status: Running");
            }
            return localStrings.getLocalString("list.domains.StatusNotRunning", "Status: Not Running");
        }
        catch (GFLauncherException gf) {
            return localStrings.getLocalString("list.domains.StatusUnknown", "Status: Unknown");
        }
        catch (MiniXmlParserException me) {
            return localStrings.getLocalString("list.domainsStatusUnknown", "Status: Unknown");
        }
    }

    private boolean isServerAlive(int port) {
        CommandInvoker invoker = new CommandInvoker("version");
        invoker.put("port", "" + port);
        invoker.put("user", this.getOption("user"));
        invoker.put("passwordfile", this.getOption("passwordfile"));
        return CLIRemoteCommand.pingDASQuietly((CommandInvoker)invoker);
    }
}

