/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.cli.optional;

import com.sun.enterprise.admin.cli.optional.BaseLifeCycleCommand;
import com.sun.enterprise.admin.cli.optional.DomainXmlVerifier;
import com.sun.enterprise.cli.framework.CLILogger;
import com.sun.enterprise.cli.framework.CommandException;
import com.sun.enterprise.cli.framework.CommandValidationException;
import com.sun.enterprise.config.serverbeans.Domain;
import java.io.File;
import java.net.URL;
import org.glassfish.api.embedded.Server;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.config.ConfigParser;
import org.jvnet.hk2.config.Dom;
import org.jvnet.hk2.config.DomDocument;

public class VerifyDomainXmlCommand
extends BaseLifeCycleCommand {
    private static final String CONFIG = "config";
    private static final String DOMAIN_XML = "domain.xml";
    private String domainName;
    private String domainsDir;
    private boolean terse = false;
    private boolean verbose = false;

    public void runCommand() throws CommandException, CommandValidationException {
        String domainXMLFile = this.getDomainXMLFile();
        File f = new File(domainXMLFile);
        if (!f.exists()) {
            throw new CommandException(this.getLocalizedString("verify.domainxml.DomainXMLDoesNotExist", new Object[]{this.getDomainName()}));
        }
        try {
            Server server = new Server.Builder("dummylaunch").build();
            server.start();
            Habitat habitat = server.getHabitat();
            ConfigParser parser = new ConfigParser(habitat);
            URL domainURL = new File(domainXMLFile).toURI().toURL();
            DomDocument doc = parser.parse(domainURL);
            Dom domDomain = doc.getRoot();
            Domain domain = (Domain)domDomain.createProxy(Domain.class);
            DomainXmlVerifier validator = new DomainXmlVerifier(domain);
            validator.invokeConfigValidator();
            CLILogger.getInstance().printDetailMessage(this.getLocalizedString("CommandSuccessful", new Object[]{this.name}));
        }
        catch (Exception e) {
            throw new CommandException(e.getMessage());
        }
    }

    private String getDomainXMLFile() throws CommandException, CommandValidationException {
        this.domainsDir = this.getDomainsRoot();
        this.domainName = this.getDomainName();
        this.checkOptions();
        String domainXMLFile = this.domainsDir + File.separator + this.domainName + File.separator + CONFIG + File.separator + DOMAIN_XML;
        CLILogger.getInstance().printDebugMessage("Domain XML file = " + domainXMLFile);
        return domainXMLFile;
    }

    private void checkOptions() throws CommandValidationException {
        if (this.domainsDir == null || this.domainsDir.length() <= 0) {
            throw new CommandValidationException(this.getLocalizedString("InvalidDomainPath", new String[]{this.domainsDir}));
        }
        File domainsDirFile = new File(this.domainsDir);
        if (!domainsDirFile.isDirectory()) {
            throw new CommandValidationException(this.getLocalizedString("InvalidDomainPath", new String[]{this.domainsDir}));
        }
    }
}

