/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.appclient.client.acc;

import com.sun.enterprise.deploy.shared.ArchiveFactory;
import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.ApplicationClientDescriptor;
import com.sun.enterprise.deployment.RootDeploymentDescriptor;
import com.sun.enterprise.deployment.archivist.AppClientArchivist;
import com.sun.enterprise.deployment.archivist.Archivist;
import com.sun.enterprise.deployment.archivist.ArchivistFactory;
import com.sun.enterprise.deployment.util.ModuleDescriptor;
import com.sun.enterprise.deployment.util.XModuleType;
import com.sun.enterprise.universal.i18n.LocalStringsImpl;
import java.io.IOException;
import java.net.URI;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.glassfish.appclient.client.acc.Launchable;
import org.glassfish.appclient.client.acc.UserError;
import org.glassfish.appclient.client.acc.Util;
import org.jvnet.hk2.component.Habitat;
import org.xml.sax.SAXParseException;

public class UndeployedLaunchable
implements Launchable {
    private static final LocalStringsImpl localStrings = new LocalStringsImpl(UndeployedLaunchable.class);
    private final String callerSuppliedMainClassName;
    private ApplicationClientDescriptor acDesc = null;
    private AppClientArchivist archivist = null;
    private final ReadableArchive clientRA;
    private ClassLoader classLoader = null;
    private final Habitat habitat;

    static UndeployedLaunchable newUndeployedLaunchable(Habitat habitat, ReadableArchive ra, String callerSuppliedMainClassName, String callerSuppliedAppName, ClassLoader classLoader) throws IOException, SAXParseException, UserError {
        ArchivistFactory af = Util.getArchivistFactory();
        Archivist archivist = af.getArchivist(ra, classLoader);
        if (archivist.getModuleType().equals((Object)XModuleType.CAR)) {
            return new UndeployedLaunchable(habitat, ra, (AppClientArchivist)archivist, callerSuppliedMainClassName);
        }
        if (archivist.getModuleType().equals((Object)XModuleType.EAR)) {
            Application app = (Application)archivist.open(ra);
            for (ModuleDescriptor md : app.getModules()) {
                boolean useThisClient;
                if (!md.getModuleType().equals((Object)XModuleType.CAR)) continue;
                ApplicationClientDescriptor acd = (ApplicationClientDescriptor)md.getDescriptor();
                String displayName = acd.getDisplayName();
                String appName = acd.getModuleID();
                ArchiveFactory archiveFactory = Util.getArchiveFactory();
                ReadableArchive clientRA = archiveFactory.openArchive(ra.getURI().resolve(md.getArchiveUri()));
                boolean bl = useThisClient = displayName != null && displayName.equals(callerSuppliedAppName) || appName != null && appName.equals(callerSuppliedAppName) || callerSuppliedMainClassName != null && clientRA.exists(UndeployedLaunchable.classToResource(callerSuppliedMainClassName)) || callerSuppliedAppName == null && callerSuppliedMainClassName == null;
                if (useThisClient) {
                    return new UndeployedLaunchable(habitat, clientRA, acd, callerSuppliedMainClassName);
                }
                clientRA.close();
            }
            throw new UserError(localStrings.get("appclient.noMatchingClientInEAR", new Object[]{ra.getURI(), callerSuppliedMainClassName, callerSuppliedAppName}));
        }
        archivist = af.getArchivist(XModuleType.CAR);
        RootDeploymentDescriptor tempACD = archivist.open(ra);
        if (tempACD != null && tempACD instanceof ApplicationClientDescriptor) {
            archivist = af.getArchivist(XModuleType.CAR);
            return new UndeployedLaunchable(habitat, ra, (AppClientArchivist)archivist, callerSuppliedMainClassName);
        }
        throw new UserError(localStrings.get("appclient.unexpectedArchive", new Object[]{ra.getURI()}));
    }

    public URI getURI() {
        return this.clientRA.getURI();
    }

    public String getAnchorDir() {
        return null;
    }

    private static String classToResource(String className) {
        return className.replace('.', '/') + ".class";
    }

    private UndeployedLaunchable(Habitat habitat, ReadableArchive clientRA, ApplicationClientDescriptor acd, String callerSuppliedMainClass) {
        this.callerSuppliedMainClassName = callerSuppliedMainClass;
        this.clientRA = clientRA;
        this.acDesc = acd;
        this.habitat = habitat;
    }

    private UndeployedLaunchable(Habitat habitat, ReadableArchive clientRA, AppClientArchivist archivist, String callerSuppliedMainClass) throws IOException, SAXParseException {
        this.clientRA = clientRA;
        this.archivist = this.completeInit(archivist);
        this.callerSuppliedMainClassName = callerSuppliedMainClass;
        this.habitat = habitat;
    }

    public Class getMainClass() throws ClassNotFoundException {
        try {
            String mainClassName = this.mainClassNameToLaunch();
            return Class.forName(mainClassName, true, this.getClassLoader());
        }
        catch (Exception e) {
            throw new ClassNotFoundException("<mainclass>");
        }
    }

    private ClassLoader getClassLoader() {
        if (this.classLoader == null) {
            this.classLoader = Thread.currentThread().getContextClassLoader();
        }
        return this.classLoader;
    }

    private String mainClassNameToLaunch() throws IOException, SAXParseException {
        return this.callerSuppliedMainClassName != null ? this.callerSuppliedMainClassName : this.getDescriptor(this.getClassLoader()).getMainClassName();
    }

    public ApplicationClientDescriptor getDescriptor(ClassLoader loader) throws IOException, SAXParseException {
        this.classLoader = loader;
        if (this.acDesc == null) {
            AppClientArchivist archivist = this.getArchivist(loader);
            this.acDesc = (ApplicationClientDescriptor)archivist.open(this.clientRA);
            Application.createApplication((Habitat)this.habitat, null, (ModuleDescriptor)this.acDesc.getModuleDescriptor());
        }
        return this.acDesc;
    }

    private AppClientArchivist completeInit(AppClientArchivist arch) {
        arch.setDescriptor((RootDeploymentDescriptor)this.acDesc);
        arch.setAnnotationProcessingRequested(true);
        return arch;
    }

    private AppClientArchivist getArchivist(ClassLoader classLoader) throws IOException {
        if (this.archivist == null) {
            ArchivistFactory af = Util.getArchivistFactory();
            this.archivist = this.completeInit((AppClientArchivist)af.getArchivist(this.clientRA, classLoader));
        }
        this.archivist.setClassLoader(classLoader);
        return this.archivist;
    }

    public void validateDescriptor() {
        try {
            this.getArchivist(this.classLoader).validate(this.classLoader);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

