/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.data;

import com.sun.messaging.jmq.io.Packet;
import com.sun.messaging.jmq.io.PacketType;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.auth.AccessController;
import com.sun.messaging.jmq.jmsserver.data.DefaultHandler;
import com.sun.messaging.jmq.jmsserver.data.ErrHandler;
import com.sun.messaging.jmq.jmsserver.data.PacketHandler;
import com.sun.messaging.jmq.jmsserver.service.imq.IMQConnection;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.jmsserver.util.ServiceRestrictionException;
import com.sun.messaging.jmq.util.log.Logger;
import java.security.AccessControlException;

public class PacketRouter {
    private static boolean DEBUG = false;
    private final Logger logger = Globals.getLogger();
    private PacketHandler[] list = new PacketHandler[80];
    private ErrHandler defaultHandler = new DefaultHandler();

    public static boolean getDEBUG() {
        return DEBUG;
    }

    public void addHandler(int n, PacketHandler packetHandler) throws ArrayIndexOutOfBoundsException {
        if (n > 80) {
            throw new ArrayIndexOutOfBoundsException(Globals.getBrokerResources().getString("B4117", "Trying to add handler which has no corresponding packet type [ " + n + "]"));
        }
        this.list[n] = packetHandler;
    }

    public void addHandler(int n, int n2, PacketHandler packetHandler) throws ArrayIndexOutOfBoundsException {
        for (int i = n; i < n2; ++i) {
            this.addHandler(i, packetHandler);
        }
    }

    public PacketHandler getHandler(int n) throws ArrayIndexOutOfBoundsException {
        if (n > 80) {
            throw new ArrayIndexOutOfBoundsException(n);
        }
        return this.list[n];
    }

    public void handleMessage(IMQConnection iMQConnection, Packet packet) {
        int n = packet.getPacketType();
        if (n < 0) {
            this.logger.log(32, Globals.getBrokerResources().getString("B4117", "invalid packet type {0}", String.valueOf(n)));
            this.defaultHandler.sendError(iMQConnection, packet, "invalid packet type " + n, 500);
            return;
        }
        PacketHandler packetHandler = null;
        packetHandler = n >= 80 ? this.defaultHandler : this.list[n];
        if (packetHandler == null) {
            packetHandler = this.defaultHandler;
        }
        try {
            boolean bl;
            if (packetHandler != this.defaultHandler) {
                this.checkServiceRestriction(packet, iMQConnection, packetHandler, n);
                if (!this.checkAccessControl(packet, iMQConnection, packetHandler, n)) {
                    return;
                }
            }
            if (bl = packetHandler.handle(iMQConnection, packet)) {
                packet.destroy();
                packet = null;
            }
        }
        catch (ServiceRestrictionException serviceRestrictionException) {
            assert (this.defaultHandler != null);
            if (this.defaultHandler != null) {
                this.defaultHandler.sendError(iMQConnection, packet, serviceRestrictionException.getMessage(), 503);
            }
        }
        catch (BrokerException brokerException) {
            assert (this.defaultHandler != null);
            if (this.defaultHandler != null) {
                if (brokerException.getStatusCode() == 503) {
                    this.defaultHandler.sendError(iMQConnection, packet, brokerException.getMessage(), 503);
                } else {
                    this.defaultHandler.sendError(iMQConnection, brokerException, packet);
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.defaultHandler.sendError(iMQConnection, new BrokerException(Globals.getBrokerResources().getKString("B4117", "Unexpected Error processing message"), exception), packet);
        }
    }

    private boolean checkAccessControl(Packet packet, IMQConnection iMQConnection, PacketHandler packetHandler, int n) {
        AccessController accessController = iMQConnection.getAccessController();
        if (n != 10 && n != 54 && n != 12 && n != 28) {
            block15: {
                if (!accessController.isAuthenticated()) {
                    String string = Globals.getBrokerResources().getKString("B3059", PacketType.getString(n));
                    if (this.defaultHandler != null) {
                        this.defaultHandler.sendError(iMQConnection, packet, string, 500);
                    } else {
                        this.logger.log(32, string);
                    }
                    return false;
                }
                try {
                    PacketHandler.checkPermission(packet, iMQConnection);
                    return true;
                }
                catch (AccessControlException accessControlException) {
                    try {
                        packetHandler.handleForbidden(iMQConnection, packet, n + 1);
                    }
                    catch (BrokerException brokerException) {
                        assert (this.defaultHandler != null);
                        if (this.defaultHandler != null) {
                            this.defaultHandler.sendError(iMQConnection, brokerException, packet);
                        }
                    }
                    catch (Exception exception) {
                        if (this.defaultHandler != null) {
                            this.defaultHandler.sendError(iMQConnection, new BrokerException(Globals.getBrokerResources().getKString("B4117", "Unexpected Error processing message"), exception), packet);
                        }
                    }
                }
                catch (BrokerException brokerException) {
                    if (this.defaultHandler != null) {
                        this.defaultHandler.sendError(iMQConnection, packet, brokerException.getMessage(), brokerException.getStatusCode());
                    }
                }
                catch (Exception exception) {
                    if (this.defaultHandler == null) break block15;
                    this.defaultHandler.sendError(iMQConnection, new BrokerException(Globals.getBrokerResources().getKString("B4117", "Unexpected Error processing message"), exception), packet);
                }
            }
            return false;
        }
        return true;
    }

    private void checkServiceRestriction(Packet packet, IMQConnection iMQConnection, PacketHandler packetHandler, int n) throws BrokerException, Exception {
        if (n != 10 && n != 54 && n != 12 && n != 28) {
            packetHandler.checkServiceRestriction(packet, iMQConnection);
        }
    }
}

