/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.data;

import com.sun.messaging.jmq.io.Packet;
import com.sun.messaging.jmq.io.SysMessageID;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.core.BrokerAddress;
import com.sun.messaging.jmq.jmsserver.core.Destination;
import com.sun.messaging.jmq.jmsserver.core.DestinationUID;
import com.sun.messaging.jmq.jmsserver.core.PacketReference;
import com.sun.messaging.jmq.jmsserver.data.BaseTransaction;
import com.sun.messaging.jmq.jmsserver.data.ClusterTransaction;
import com.sun.messaging.jmq.jmsserver.data.RemoteTransaction;
import com.sun.messaging.jmq.jmsserver.data.TransactionAcknowledgement;
import com.sun.messaging.jmq.jmsserver.data.TransactionBroker;
import com.sun.messaging.jmq.jmsserver.data.TransactionList;
import com.sun.messaging.jmq.jmsserver.data.TransactionState;
import com.sun.messaging.jmq.jmsserver.data.TransactionUID;
import com.sun.messaging.jmq.jmsserver.data.TransactionWork;
import com.sun.messaging.jmq.jmsserver.data.TransactionWorkMessage;
import com.sun.messaging.jmq.jmsserver.data.TransactionWorkMessageAck;
import com.sun.messaging.jmq.jmsserver.persist.Store;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.util.log.Logger;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;

public class TransactionListLoader {
    Logger logger = Globals.getLogger();
    Store store = null;
    TransactionList transactionList;

    public TransactionListLoader(Store store, TransactionList transactionList) {
        this.store = store;
        this.transactionList = transactionList;
    }

    public void loadTransactions() throws BrokerException, IOException {
        this.logger.log(8, "B1136");
        this.loadLocalTransactions();
        this.loadClusterTransactions();
        this.loadRemoteTransactions();
    }

    public void loadLocalTransactions() throws BrokerException, IOException {
        List<BaseTransaction> list = this.store.getIncompleteTransactions(1);
        String string = " loading " + list.size() + " incomplete Local transactions:  ";
        this.logger.log(4, string);
        for (BaseTransaction baseTransaction : list) {
            TransactionUID transactionUID = baseTransaction.getTid();
            string = " loadTransactions: processing local transaction " + transactionUID;
            this.logger.log(4, string);
            TransactionState transactionState = baseTransaction.getTransactionState();
            this.transactionList.addTransactionID(transactionUID, transactionState, false);
            TransactionWork transactionWork = baseTransaction.getTransactionWork();
            this.handleTransactionWork(transactionUID, transactionWork);
        }
    }

    public void loadClusterTransactions() throws BrokerException, IOException {
        List<BaseTransaction> list = this.store.getIncompleteTransactions(3);
        String string = " loading " + list.size() + " incomplete cluster transactions:  ";
        this.logger.log(4, string);
        for (ClusterTransaction clusterTransaction : list) {
            TransactionUID transactionUID = clusterTransaction.getTid();
            string = " loadTransactions: processing cluster transaction " + transactionUID;
            this.logger.log(4, string);
            TransactionState transactionState = clusterTransaction.getTransactionState();
            this.transactionList.addTransactionID(transactionUID, transactionState, false);
            TransactionBroker[] transactionBrokerArray = clusterTransaction.getTransactionBrokers();
            this.transactionList.logClusterTransaction(transactionUID, transactionState, transactionBrokerArray, true, false);
            TransactionWork transactionWork = clusterTransaction.getTransactionWork();
            this.handleTransactionWork(transactionUID, transactionWork);
        }
    }

    public void loadRemoteTransactions() throws BrokerException, IOException {
        List<BaseTransaction> list = this.store.getIncompleteTransactions(2);
        String string = " loading " + list.size() + " incomplete remote transactions:  ";
        this.logger.log(4, string);
        for (RemoteTransaction remoteTransaction : list) {
            TransactionUID transactionUID = remoteTransaction.getTid();
            string = " loadTransactions: processing remote transaction " + transactionUID;
            this.logger.log(4, string);
            TransactionState transactionState = remoteTransaction.getTransactionState();
            TransactionAcknowledgement[] transactionAcknowledgementArray = remoteTransaction.getTxnAcks();
            BrokerAddress brokerAddress = remoteTransaction.getTxnHomeBroker();
            this.transactionList.logRemoteTransaction(transactionUID, transactionState, transactionAcknowledgementArray, brokerAddress, true, true, false);
        }
    }

    void handleTransactionWork(TransactionUID transactionUID, TransactionWork transactionWork) throws BrokerException {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        int n;
        Destination.loadDestinations();
        Iterator iterator = Destination.getAllDestinations();
        while (iterator.hasNext()) {
            Destination destination = (Destination)iterator.next();
            destination.load();
        }
        for (n = 0; n < transactionWork.numSentMessages(); ++n) {
            object4 = transactionWork.getSentMessages().get(n);
            object3 = ((TransactionWorkMessage)object4).getMessage();
            object2 = ((TransactionWorkMessage)object4).getDestUID();
            object = PacketReference.createReference((Packet)object3, (DestinationUID)object2, null);
            Destination destination = Destination.getDestination((DestinationUID)object2);
            this.logger.log(4, " loadTransactions: processing prepared sent message " + ((Packet)object3).getMessageID());
            boolean bl = destination.queueMessage((PacketReference)object, true);
            this.transactionList.addMessage(((PacketReference)object).getTransactionID(), ((PacketReference)object).getSysMessageID(), true);
        }
        for (n = 0; n < transactionWork.numMessageAcknowledgments(); ++n) {
            object4 = transactionWork.getMessageAcknowledgments().get(n);
            object3 = ((TransactionWorkMessageAck)object4).getSysMessageID();
            this.logger.log(4, " loadTransactions: processing prepared acknowledged message " + object3);
            this.transactionList.addAcknowledgement(transactionUID, (SysMessageID)object3, ((TransactionWorkMessageAck)object4).getConsumerID(), ((TransactionWorkMessageAck)object4).getConsumerID(), true, false);
            this.transactionList.addOrphanAck(transactionUID, (SysMessageID)object3, ((TransactionWorkMessageAck)object4).getConsumerID(), ((TransactionWorkMessageAck)object4).getConsumerID());
            this.logger.log(4, " trying to unroute prepared acknowledged message " + object3);
            object2 = Destination.get((SysMessageID)object3);
            object = ((PacketReference)object2).getDestination();
            ((Destination)object).unrouteLoadedTransactionAckMessage((PacketReference)object2, ((TransactionWorkMessageAck)object4).getConsumerID());
        }
    }
}

