/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.cli.commands;

import com.sun.enterprise.admin.cli.CLICommand;
import com.sun.enterprise.admin.cli.Environment;
import com.sun.enterprise.admin.cli.ProgramOptions;
import com.sun.enterprise.cli.framework.CommandException;
import com.sun.enterprise.cli.framework.CommandValidationException;
import com.sun.enterprise.cli.framework.ValidOption;
import com.sun.enterprise.universal.i18n.LocalStringsImpl;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;

public class ExportCommand
extends CLICommand {
    private static final LocalStringsImpl strings = new LocalStringsImpl(ExportCommand.class);

    public ExportCommand(String name, ProgramOptions programOpts, Environment env) throws CommandException {
        super(name, programOpts, env);
    }

    protected void prepare() throws CommandException, CommandValidationException {
        HashSet<ValidOption> opts = new HashSet<ValidOption>();
        ExportCommand.addOption(opts, "help", '?', "BOOLEAN", false, "false");
        this.commandOpts = Collections.unmodifiableSet(opts);
        this.operandName = "environment-variable";
        this.operandType = "STRING";
        this.operandMin = 0;
        this.operandMax = Integer.MAX_VALUE;
    }

    public int executeCommand() throws CommandException, CommandValidationException {
        int ret = 0;
        if (this.operands.size() == 0) {
            for (Map.Entry<String, String> e : this.env.entrySet()) {
                logger.printMessage(e.getKey() + " = " + e.getValue());
            }
        } else {
            for (String arg : this.operands) {
                String value;
                String name;
                int eq = arg.indexOf(61);
                if (eq < 0) {
                    name = arg;
                    value = null;
                } else {
                    name = arg.substring(0, eq);
                    value = arg.substring(eq + 1);
                }
                if (!name.startsWith("AS_ADMIN_")) {
                    logger.printMessage(strings.get("badEnvVarSet", new Object[]{name}));
                    ret = -1;
                    continue;
                }
                if (value == null) {
                    logger.printMessage(name + " = " + this.env.get(name));
                    continue;
                }
                this.env.put(name, value);
            }
        }
        return ret;
    }
}

