/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.cli.commands;

import com.sun.enterprise.admin.cli.CLIConstants;
import com.sun.enterprise.admin.cli.Environment;
import com.sun.enterprise.admin.cli.LocalDomainCommand;
import com.sun.enterprise.admin.cli.ProgramOptions;
import com.sun.enterprise.admin.cli.remote.DASUtils;
import com.sun.enterprise.admin.launcher.GFLauncher;
import com.sun.enterprise.admin.launcher.GFLauncherException;
import com.sun.enterprise.admin.launcher.GFLauncherFactory;
import com.sun.enterprise.admin.launcher.GFLauncherInfo;
import com.sun.enterprise.cli.framework.CommandException;
import com.sun.enterprise.cli.framework.CommandValidationException;
import com.sun.enterprise.cli.framework.ValidOption;
import com.sun.enterprise.universal.i18n.LocalStringsImpl;
import com.sun.enterprise.universal.xml.MiniXmlParserException;
import java.io.IOException;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StartDomainCommand
extends LocalDomainCommand {
    private GFLauncherInfo info;
    private static final LocalStringsImpl strings = new LocalStringsImpl(StartDomainCommand.class);

    public StartDomainCommand(String name, ProgramOptions po, Environment env) {
        super(name, po, env);
    }

    @Override
    protected void prepare() throws CommandException, CommandValidationException {
        this.processProgramOptions();
        LinkedHashSet<ValidOption> opts = new LinkedHashSet<ValidOption>();
        StartDomainCommand.addOption(opts, "debug", '\u0000', "BOOLEAN", false, "false");
        StartDomainCommand.addOption(opts, "domaindir", '\u0000', "STRING", false, null);
        StartDomainCommand.addOption(opts, "help", '?', "BOOLEAN", false, "false");
        StartDomainCommand.addOption(opts, "upgrade", '\u0000', "BOOLEAN", false, "false");
        StartDomainCommand.addOption(opts, "verbose", '\u0000', "BOOLEAN", false, "false");
        this.commandOpts = Collections.unmodifiableSet(opts);
        this.operandName = "domain_name";
        this.operandType = "STRING";
        this.operandMin = 0;
        this.operandMax = 1;
    }

    @Override
    protected int executeCommand() throws CommandException {
        String gfejar = System.getenv("GFE_JAR");
        if (gfejar != null && gfejar.length() > 0) {
            this.runCommandEmbedded();
        } else {
            this.runCommandNotEmbedded();
        }
        return 0;
    }

    private void runCommandNotEmbedded() throws CommandException {
        try {
            String parent;
            GFLauncher launcher = GFLauncherFactory.getInstance((GFLauncherFactory.ServerType)GFLauncherFactory.ServerType.domain);
            this.info = launcher.getInfo();
            if (!this.operands.isEmpty()) {
                this.info.setDomainName((String)this.operands.get(0));
            }
            if ((parent = (String)this.options.get("domaindir")) != null) {
                this.info.setDomainParentDir(parent);
            }
            boolean verbose = this.getBooleanOption("verbose");
            this.info.setVerbose(verbose);
            this.info.setDebug(this.getBooleanOption("debug"));
            this.info.setUpgrade(this.getBooleanOption("upgrade"));
            this.info.setRespawnInfo(this.programOpts.getClassName(), this.programOpts.getClassPath(), this.programOpts.getProgramArguments());
            this.setMasterPassword(this.info);
            launcher.setup();
            if (this.isServerAlive(this.info.getAdminPorts())) {
                int definitePort = (Integer)this.info.getAdminPorts().iterator().next();
                String msg = strings.get("ServerRunning", new Object[]{definitePort + ""});
                logger.printWarning(msg);
                return;
            }
            boolean isRestart = Boolean.getBoolean("AS_RESTART");
            if (isRestart) {
                this.waitForParentToDie();
            }
            launcher.launch();
            if (verbose) {
                while (launcher.getExitValue() == 10) {
                    logger.printMessage(strings.get("restart"));
                    if (CLIConstants.debugMode) {
                        System.setProperty("WALL_CLOCK_START", "" + System.currentTimeMillis());
                    }
                    launcher.relaunch();
                }
            } else {
                this.waitForDAS(this.info.getAdminPorts());
                this.report(this.info);
            }
        }
        catch (GFLauncherException gfle) {
            throw new CommandException(gfle.getMessage());
        }
        catch (MiniXmlParserException me) {
            throw new CommandException(me);
        }
    }

    private void setMasterPassword(GFLauncherInfo info) throws CommandException {
        boolean ok;
        String mpn = "AS_ADMIN_MASTERPASSWORD";
        String mpv = (String)this.passwords.get(mpn);
        if (mpv == null) {
            mpv = this.checkMasterPasswordFile();
        }
        if (mpv == null) {
            mpv = "changeit";
        }
        if (!(ok = this.verifyMasterPassword(mpv))) {
            mpv = this.retry(3);
        }
        info.addSecurityToken(mpn, mpv);
    }

    private String retry(int times) throws CommandException {
        logger.printMessage("No valid master password found");
        for (int i = 0; i < times; ++i) {
            String prompt = "Enter master password (" + (times - i) + " attempt(s) remain)> ";
            String mpv = super.readPassword(prompt);
            if (mpv == null) {
                throw new CommandException("No console, no prompting possible");
            }
            if (this.verifyMasterPassword(mpv)) {
                return mpv;
            }
            logger.printMessage("Sorry, incorrect master password, retry");
        }
        throw new CommandException("Number of attempts (" + times + ") exhausted, giving up");
    }

    private void runCommandEmbedded() throws CommandException {
        try {
            GFLauncher launcher = GFLauncherFactory.getInstance((GFLauncherFactory.ServerType)GFLauncherFactory.ServerType.embedded);
            this.info = launcher.getInfo();
            if (!this.operands.isEmpty()) {
                this.info.setDomainName((String)this.operands.get(0));
            } else {
                this.info.setDomainName("domain1");
            }
            String parent = (String)this.options.get("domaindir");
            if (parent != null) {
                this.info.setDomainParentDir(parent);
            } else {
                this.info.setDomainParentDir(System.getenv("S1AS_HOME") + "/domains");
            }
            boolean verbose = this.getBooleanOption("verbose");
            this.info.setVerbose(verbose);
            this.info.setDebug(this.getBooleanOption("debug"));
            launcher.setup();
            Set ports = this.info.getAdminPorts();
            if (this.isServerAlive(ports)) {
                throw new CommandException("The Admin port is already taken: ");
            }
            launcher.launch();
            this.waitForDAS(ports);
            this.report(this.info);
        }
        catch (GFLauncherException gfle) {
            throw new CommandException(gfle.getMessage());
        }
        catch (MiniXmlParserException me) {
            throw new CommandException(me);
        }
    }

    private void waitForDAS(Set<Integer> ports) throws CommandException {
        if (ports == null || ports.size() <= 0) {
            String msg = strings.get("noPorts");
            throw new CommandException(strings.get("CommandUnSuccessfulWithArg", new Object[]{this.name, msg}));
        }
        long startWait = System.currentTimeMillis();
        logger.printMessage(strings.get("WaitDAS"));
        boolean alive = false;
        block2: while (!this.timedOut(startWait)) {
            for (int port : ports) {
                if (!this.isServerAlive(port)) continue;
                alive = true;
                break block2;
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException ex) {}
        }
        if (!alive) {
            String msg = strings.get("dasNoStart", new Object[]{this.info.getDomainName(), 90L});
            throw new CommandException(msg);
        }
    }

    private boolean isServerAlive(int port) {
        logger.printDebugMessage("Check if server is alive on port " + port);
        this.programOpts.setPort(port);
        this.programOpts.setInteractive(false);
        return DASUtils.pingDASQuietly(this.programOpts, this.env);
    }

    private boolean isServerAlive(Set<Integer> ports) {
        if (ports == null || ports.size() == 0) {
            return false;
        }
        return this.isServerAlive(ports.iterator().next());
    }

    private boolean timedOut(long startTime) {
        return System.currentTimeMillis() - startTime > 90000L;
    }

    private void report(GFLauncherInfo info) {
        String msg = strings.get("DomainLocation", new Object[]{info.getDomainName(), info.getDomainRootDir().getAbsolutePath()});
        logger.printMessage(msg);
        Integer ap = -1;
        try {
            ap = (Integer)info.getAdminPorts().iterator().next();
        }
        catch (Exception e) {
            // empty catch block
        }
        msg = strings.get("DomainAdminPort", new Object[]{"" + ap});
        logger.printMessage(msg);
    }

    private void waitForParentToDie() {
        try {
            while (System.in.read() >= 0) {
            }
        }
        catch (IOException ex) {
            Logger lg = Logger.getLogger(StartDomainCommand.class.getName());
            lg.log(Level.SEVERE, null, ex);
        }
    }
}

