/*
 * Decompiled with CFR 0.152.
 */
package org.lassfish.jms.admin.cli;

import com.sun.enterprise.config.serverbeans.AdminObjectResource;
import com.sun.enterprise.config.serverbeans.ConnectorConnectionPool;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.util.ArrayList;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;

@Service(name="list-jms-resources")
@Scoped(value=PerLookup.class)
@I18n(value="list.jms.resources")
public class ListJMSResources
implements AdminCommand {
    private static final String QUEUE = "javax.jms.Queue";
    private static final String TOPIC = "javax.jms.Topic";
    private static final String QUEUE_CF = "javax.jms.QueueConnectionFactory";
    private static final String TOPIC_CF = "javax.jms.TopicConnectionFactory";
    private static final String UNIFIED_CF = "javax.jms.ConnectionFactory";
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(ListJMSResources.class);
    @Param(name="restype", optional=true)
    String resourceType;
    @Inject
    ConnectorConnectionPool[] connectionpools;
    @Inject
    AdminObjectResource[] resources;

    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        ArrayList<String> list = new ArrayList<String>();
        if (this.resourceType == null) {
            try {
                for (AdminObjectResource adminObjectResource : this.resources) {
                    if (!QUEUE.equals(adminObjectResource.getResType()) && !TOPIC.equals(adminObjectResource.getResType())) continue;
                    list.add(adminObjectResource.getJndiName());
                }
                for (AdminObjectResource adminObjectResource : this.connectionpools) {
                    if (!QUEUE_CF.equals(adminObjectResource.getConnectionDefinitionName()) && !TOPIC_CF.equals(adminObjectResource.getConnectionDefinitionName()) && !UNIFIED_CF.equals(adminObjectResource.getConnectionDefinitionName())) continue;
                    list.add(adminObjectResource.getName());
                }
                if (list.isEmpty()) {
                    ActionReport.MessagePart part = report.getTopMessagePart().addChild();
                    part.setMessage(localStrings.getLocalString("nothingToList", "Nothing to list."));
                }
                for (String jndiName : list) {
                    ActionReport.MessagePart part = report.getTopMessagePart().addChild();
                    part.setMessage(jndiName);
                }
            }
            catch (Exception e) {
                report.setMessage(localStrings.getLocalString("list.jms.resources.fail", "Unable to list JMS Resources") + " " + e.getLocalizedMessage());
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                report.setFailureCause((Throwable)e);
                return;
            }
        } else if (this.resourceType.equals(TOPIC_CF) || this.resourceType.equals(QUEUE_CF) || this.resourceType.equals(UNIFIED_CF)) {
            for (AdminObjectResource adminObjectResource : this.connectionpools) {
                if (!this.resourceType.equals(adminObjectResource.getConnectionDefinitionName())) continue;
                list.add(adminObjectResource.getName());
            }
        } else if (this.resourceType.equals(TOPIC) || this.resourceType.equals(QUEUE)) {
            for (AdminObjectResource adminObjectResource : this.resources) {
                if (!this.resourceType.equals(adminObjectResource.getResType())) continue;
                list.add(adminObjectResource.getJndiName());
            }
        }
        for (String jndiName : list) {
            ActionReport.MessagePart part = report.getTopMessagePart().addChild();
            part.setMessage(jndiName);
        }
        report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
    }
}

