/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.amx.impl.mbean;

import java.util.ArrayList;
import java.util.Set;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;
import javax.management.MBeanServer;
import javax.management.MBeanServerConnection;
import javax.management.MBeanServerNotification;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import org.glassfish.admin.amx.base.DomainRoot;
import org.glassfish.admin.amx.core.AMXValidator;
import org.glassfish.admin.amx.impl.util.ImplUtil;
import org.glassfish.admin.amx.util.jmx.JMXUtil;

public final class ComplianceMonitor
implements NotificationListener {
    private static ComplianceMonitor INSTANCE = null;
    private final DomainRoot mDomainRoot;
    private final MBeanServer mServer;
    private volatile boolean mStarted = false;
    private final ValidatorThread mValidatorThread;

    private ComplianceMonitor(DomainRoot domainRoot) {
        this.mDomainRoot = domainRoot;
        this.mServer = (MBeanServer)domainRoot.extra().mbeanServerConnection();
        this.mValidatorThread = new ValidatorThread(this.mServer);
    }

    public int getNumComplianceFailures() {
        return this.mValidatorThread.getNumComplianceFailures();
    }

    private void listen() {
        try {
            JMXUtil.listenToMBeanServerDelegate((MBeanServerConnection)this.mServer, (NotificationListener)this, null, null);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        Set existing = JMXUtil.queryAllInDomain((MBeanServer)this.mServer, (String)this.mDomainRoot.objectName().getDomain());
        for (ObjectName objectName : existing) {
            this.validate(objectName);
        }
    }

    public void validate(ObjectName objectName) {
        this.mValidatorThread.add(objectName);
    }

    public static synchronized ComplianceMonitor getInstance(DomainRoot domainRoot) {
        if (INSTANCE == null) {
            INSTANCE = new ComplianceMonitor(domainRoot);
            INSTANCE.listen();
        }
        return INSTANCE;
    }

    public void start() {
        if (!this.mStarted) {
            this.mValidatorThread.start();
        }
    }

    public void handleNotification(Notification notifIn, Object handback) {
        MBeanServerNotification notif;
        ObjectName objectName;
        if (notifIn instanceof MBeanServerNotification && notifIn.getType().equals("JMX.mbean.registered") && (objectName = (notif = (MBeanServerNotification)notifIn).getMBeanName()).getDomain().equals(this.mDomainRoot.objectName().getDomain())) {
            this.mValidatorThread.add(objectName);
        }
    }

    private static void debug(Object o) {
        System.out.println(o.toString());
    }

    private static final class ValidatorThread
    extends Thread {
        private final MBeanServer mServer;
        private final LinkedBlockingQueue<ObjectName> mMBeans = new LinkedBlockingQueue();
        private final AtomicInteger mComplianceFailures = new AtomicInteger();
        private static final ObjectName QUIT = JMXUtil.newObjectName((String)"quit:type=quit");

        ValidatorThread(MBeanServer server) {
            super("ComplianceMonitor.ValidatorThread");
            this.mServer = server;
        }

        public int getNumComplianceFailures() {
            return this.mComplianceFailures.get();
        }

        void quit() {
            this.add(QUIT);
        }

        public void add(ObjectName objectName) {
            this.mMBeans.add(objectName);
        }

        public void run() {
            try {
                this.doRun();
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }

        protected void doRun() throws Exception {
            while (true) {
                ObjectName next = this.mMBeans.take();
                ArrayList<ObjectName> toValidate = new ArrayList<ObjectName>();
                toValidate.add(next);
                this.mMBeans.drainTo(toValidate);
                if (this.mMBeans.contains(QUIT)) break;
                AMXValidator validator = new AMXValidator((MBeanServerConnection)this.mServer);
                try {
                    ObjectName[] objectNames = new ObjectName[toValidate.size()];
                    toValidate.toArray(objectNames);
                    AMXValidator.ValidationResult result = validator.validate(objectNames);
                    if (result.numFailures() == 0) continue;
                    this.mComplianceFailures.addAndGet(result.numFailures());
                    ImplUtil.getLogger().info(result.toString());
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
        }
    }
}

