/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.amx.impl.mbean;

import com.sun.appserv.server.util.Version;
import com.sun.enterprise.universal.Duration;
import com.sun.enterprise.universal.io.SmartFile;
import java.io.File;
import java.util.Collection;
import java.util.Set;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.glassfish.admin.amx.base.BulkAccess;
import org.glassfish.admin.amx.base.DomainRoot;
import org.glassfish.admin.amx.base.Ext;
import org.glassfish.admin.amx.base.Pathnames;
import org.glassfish.admin.amx.base.Query;
import org.glassfish.admin.amx.base.Sample;
import org.glassfish.admin.amx.base.SystemStatus;
import org.glassfish.admin.amx.base.Tools;
import org.glassfish.admin.amx.impl.mbean.AMXImplBase;
import org.glassfish.admin.amx.impl.mbean.BulkAccessImpl;
import org.glassfish.admin.amx.impl.mbean.ComplianceMonitor;
import org.glassfish.admin.amx.impl.mbean.ExtImpl;
import org.glassfish.admin.amx.impl.mbean.MonitoringRootImpl;
import org.glassfish.admin.amx.impl.mbean.PathnamesImpl;
import org.glassfish.admin.amx.impl.mbean.QueryMgrImpl;
import org.glassfish.admin.amx.impl.mbean.SampleImpl;
import org.glassfish.admin.amx.impl.mbean.ToolsImpl;
import org.glassfish.admin.amx.impl.util.ImplUtil;
import org.glassfish.admin.amx.impl.util.InjectedValues;
import org.glassfish.admin.amx.impl.util.Issues;
import org.glassfish.admin.amx.impl.util.ObjectNameBuilder;
import org.glassfish.admin.amx.monitoring.MonitoringRoot;
import org.glassfish.admin.amx.util.CollectionUtil;
import org.glassfish.admin.amx.util.FeatureAvailability;
import org.glassfish.admin.amx.util.jmx.JMXUtil;
import org.glassfish.server.ServerEnvironmentImpl;

public class DomainRootImpl
extends AMXImplBase {
    private final String mAppserverDomainName;
    private final File mInstanceRoot = new File(System.getProperty("com.sun.aas.instanceRoot"));
    private volatile ComplianceMonitor mCompliance;

    public DomainRootImpl() {
        super(null, DomainRoot.class);
        this.mAppserverDomainName = this.mInstanceRoot.getName();
    }

    public void stopDomain() {
        this.getDomainRootProxy().getExt().getRuntime().stopDomain();
    }

    public ObjectName getQueryMgr() {
        return this.child(Query.class);
    }

    public ObjectName getJ2EEDomain() {
        return this.child("J2EEDomain");
    }

    public ObjectName getMonitoringRoot() {
        return this.child(MonitoringRoot.class);
    }

    public ObjectName getPathnames() {
        return this.child(Pathnames.class);
    }

    public ObjectName getSystemStatus() {
        return this.child(SystemStatus.class);
    }

    public ObjectName getBulkAccess() {
        return this.child(BulkAccess.class);
    }

    protected ObjectName preRegisterHook(MBeanServer server, ObjectName selfObjectName) throws Exception {
        Set existing = JMXUtil.queryAllInDomain((MBeanServer)server, (String)selfObjectName.getDomain());
        if (existing.size() != 0) {
            ImplUtil.getLogger().info("MBeans exist in AMX domain prior to DomainRoot (violates Parent requirement): " + CollectionUtil.toString((Collection)existing, (String)", "));
        }
        return selfObjectName;
    }

    public void preRegisterDone() throws Exception {
        super.preRegisterDone();
    }

    protected void postRegisterHook(Boolean registrationSucceeded) {
        super.postRegisterHook(registrationSucceeded);
        if (registrationSucceeded.booleanValue()) {
            this.mCompliance = ComplianceMonitor.getInstance(this.getDomainRootProxy());
            this.mCompliance.start();
        }
    }

    public int getNumComplianceFailures() {
        return this.mCompliance.getNumComplianceFailures();
    }

    public String getAppserverDomainName() {
        return this.mAppserverDomainName;
    }

    protected final void registerChildren() {
        super.registerChildren();
        ObjectName self = this.getObjectName();
        ObjectNameBuilder objectNames = new ObjectNameBuilder(this.getMBeanServer(), self);
        ObjectName childObjectName = null;
        AMXImplBase mbean = null;
        MBeanServer server = this.getMBeanServer();
        childObjectName = objectNames.buildChildObjectName(Pathnames.class);
        mbean = new PathnamesImpl(self);
        this.registerChild(mbean, childObjectName);
        childObjectName = objectNames.buildChildObjectName(Query.class);
        mbean = new QueryMgrImpl(self);
        this.registerChild(mbean, childObjectName);
        childObjectName = objectNames.buildChildObjectName(Tools.class);
        mbean = new ToolsImpl(self);
        this.registerChild(mbean, childObjectName);
        childObjectName = objectNames.buildChildObjectName(BulkAccess.class);
        mbean = new BulkAccessImpl(self);
        this.registerChild(mbean, childObjectName);
        childObjectName = objectNames.buildChildObjectName(Sample.class);
        mbean = new SampleImpl(self);
        this.registerChild(mbean, childObjectName);
        childObjectName = objectNames.buildChildObjectName(Ext.class);
        mbean = new ExtImpl(self);
        this.registerChild(mbean, childObjectName);
        childObjectName = objectNames.buildChildObjectName(MonitoringRoot.class);
        mbean = new MonitoringRootImpl(self);
        this.registerChild(mbean, childObjectName);
    }

    public boolean getAMXReady() {
        this.waitAMXReady();
        return true;
    }

    public void waitAMXReady() {
        FeatureAvailability.getInstance().waitForFeature("AMXReady", this.getClass().getName());
    }

    public String getDebugPort() {
        Issues.getAMXIssues().notDone("DomainRootImpl.getDebugPort");
        return "9999";
    }

    public String getApplicationServerFullVersion() {
        return Version.getFullVersion();
    }

    public String getInstanceRoot() {
        return SmartFile.sanitize((String)("" + System.getProperty("com.sun.aas.instanceRoot")));
    }

    public String getDomainDir() {
        return SmartFile.sanitize((String)this.mInstanceRoot.toString());
    }

    public String getConfigDir() {
        return this.getDomainDir() + "/" + "config";
    }

    public String getInstallDir() {
        return SmartFile.sanitize((String)("" + System.getProperty("com.sun.aas.installRoot")));
    }

    public Object[] getUptimeMillis() {
        ServerEnvironmentImpl env = InjectedValues.getInstance().getServerEnvironment();
        long elapsed = System.currentTimeMillis() - env.getStartupContext().getCreationTime();
        Duration duration = new Duration(elapsed);
        return new Object[]{elapsed, duration.toString()};
    }
}

