/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.scripting.jruby.monitor;

import java.util.logging.Logger;
import org.glassfish.external.probe.provider.annotations.ProbeListener;
import org.glassfish.external.probe.provider.annotations.ProbeParam;
import org.glassfish.gmbal.Description;
import org.glassfish.gmbal.ManagedAttribute;
import org.glassfish.gmbal.ManagedObject;
import org.glassfish.scripting.jruby.monitor.JRubyRuntimePool;

@ManagedObject
@Description(value="JRuby runtime pool monitoring data")
public class JRubyRuntimePoolStatsProvider {
    private final Logger logger = Logger.getLogger(JRubyRuntimePoolStatsProvider.class.getName());
    private final String appName;
    private final String contextPath;
    private JRubyRuntimePool runtimePool;

    public JRubyRuntimePoolStatsProvider(String appName, String contextPath) {
        this.appName = appName;
        this.contextPath = contextPath;
    }

    @ManagedAttribute
    @Description(value="Application name")
    public String getApplicationName() {
        return this.appName;
    }

    @ManagedAttribute
    @Description(value="Application context-path")
    public String getContextPath() {
        return this.contextPath;
    }

    @ManagedAttribute
    @Description(value="JRuby runtime pool map per application")
    public JRubyRuntimePool getJRubyRuntimePool() {
        return this.runtimePool;
    }

    @ProbeListener(value="glassfish:jruby:runtime-pool:runtimePoolStartEvent")
    @Description(value="JRuby runtime pool creation Event")
    public void runtimePoolStartedEvent(@ProbeParam(value="appName") String appName, @ProbeParam(value="hardMinimum") int hardMinimum, @ProbeParam(value="hardMaximum") int hardMaximum, @ProbeParam(value="activeRuntimes") int activeRuntimes, @ProbeParam(value="queueSize") int queueSize, @ProbeParam(value="queueUpThreshold") int queueUpThreshold, @ProbeParam(value="queueDownThreshold") int queueDownThreshold, @ProbeParam(value="newThreshold") int newThreshold) {
        if (appName == null) {
            this.logger.warning("appName is null in runtimePoolStartedEvent! Looks like the event is not triggered properly, ignoring this monitoring event.");
            return;
        }
        this.runtimePool = new JRubyRuntimePool.Builder(hardMinimum, hardMaximum).activeRuntimes(activeRuntimes).queueSize(queueSize).queueUpThreshold(queueUpThreshold).queueDownThreshold(queueDownThreshold).newThreshold(newThreshold).build();
    }

    @ProbeListener(value="glassfish:jruby:runtime-pool:runtimePoolUpdateEvent")
    @Description(value="JRuby runtime pool update Event")
    public void runtimePoolUpdatedEvent(@ProbeParam(value="appName") String appName, @ProbeParam(value="activeRuntimes") int activeRuntimes, @ProbeParam(value="queueSize") int queueSize, @ProbeParam(value="queueUpThreshold") int queueUpThreshold, @ProbeParam(value="queueDownThreshold") int queueDownThreshold, @ProbeParam(value="newThreshold") int newThreshold) {
        if (appName == null) {
            this.logger.warning("appName is null in runtimePoolUpdatedEvent! Looks like the event is not triggered properly, ignoring this monitoring event.");
            return;
        }
        JRubyRuntimePool.Builder builder = new JRubyRuntimePool.Builder(this.runtimePool.getHardMinimum(), this.runtimePool.getHardMaximum()).activeRuntimes(activeRuntimes).queueSize(queueSize).queueUpThreshold(queueUpThreshold).queueDownThreshold(queueDownThreshold).newThreshold(newThreshold);
        this.runtimePool.update(builder);
    }
}

