/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.rx.rm.runtime;

import com.sun.istack.NotNull;
import com.sun.istack.Nullable;
import com.sun.xml.ws.api.SOAPVersion;
import com.sun.xml.ws.api.addressing.AddressingVersion;
import com.sun.xml.ws.commons.ScheduledTaskManager;
import com.sun.xml.ws.rx.RxConfiguration;
import com.sun.xml.ws.rx.rm.RmVersion;
import com.sun.xml.ws.rx.rm.runtime.DestinationMessageHandler;
import com.sun.xml.ws.rx.rm.runtime.RedeliveryTask;
import com.sun.xml.ws.rx.rm.runtime.SourceMessageHandler;
import com.sun.xml.ws.rx.rm.runtime.WsrmProtocolHandler;
import com.sun.xml.ws.rx.rm.runtime.sequence.Sequence;
import com.sun.xml.ws.rx.rm.runtime.sequence.SequenceManager;
import com.sun.xml.ws.rx.rm.runtime.sequence.UnknownSequenceException;
import com.sun.xml.ws.rx.util.Communicator;
import com.sun.xml.ws.rx.util.SuspendedFiberStorage;
import java.util.concurrent.ScheduledFuture;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class RuntimeContext {
    public final RxConfiguration configuration;
    public final AddressingVersion addressingVersion;
    public final SOAPVersion soapVersion;
    public final RmVersion rmVersion;
    private volatile SequenceManager sequenceManager;
    public final Communicator communicator;
    public final SuspendedFiberStorage suspendedFiberStorage;
    public final WsrmProtocolHandler protocolHandler;
    public final ScheduledTaskManager scheduledTaskManager;
    final RedeliveryTask redeliveryTask;
    final SourceMessageHandler sourceMessageHandler;
    final DestinationMessageHandler destinationMessageHandler;

    public static Builder getBuilder(@NotNull RxConfiguration configuration, @NotNull Communicator communicator) {
        return new Builder(configuration, communicator);
    }

    private RuntimeContext(RxConfiguration configuration, SequenceManager sequenceManager, Communicator communicator, SuspendedFiberStorage suspendedFiberStorage, ScheduledTaskManager scheduledTaskManager, SourceMessageHandler srcMsgHandler, DestinationMessageHandler dstMsgHandler, RedeliveryTask redeliveryTask) {
        this.configuration = configuration;
        this.sequenceManager = sequenceManager;
        this.communicator = communicator;
        this.suspendedFiberStorage = suspendedFiberStorage;
        this.scheduledTaskManager = scheduledTaskManager;
        this.sourceMessageHandler = srcMsgHandler;
        this.destinationMessageHandler = dstMsgHandler;
        this.addressingVersion = configuration.getAddressingVersion();
        this.soapVersion = configuration.getSoapVersion();
        this.rmVersion = configuration.getRmVersion();
        this.redeliveryTask = redeliveryTask;
        this.protocolHandler = WsrmProtocolHandler.getInstance(configuration, communicator, this);
    }

    public ScheduledFuture<?> startTask(Runnable task) {
        return this.scheduledTaskManager.startTask(task);
    }

    public ScheduledFuture<?> startTask(Runnable task, long delay, long period) {
        return this.scheduledTaskManager.startTask(task, delay, period);
    }

    public ScheduledFuture<?> startRedeliveryTask() {
        return this.scheduledTaskManager.startTask(this.redeliveryTask, this.configuration.getMessageRetransmissionInterval(), this.configuration.getMessageRetransmissionInterval());
    }

    public ScheduledFuture<?> startAckRequesterTask(Runnable ackRequesterTask) {
        return this.scheduledTaskManager.startTask(ackRequesterTask, this.configuration.getAcknowledgementRequestInterval(), this.configuration.getAcknowledgementRequestInterval());
    }

    public void stopAllTasks() {
        this.scheduledTaskManager.stopAll();
    }

    public Sequence getSequence(String sequenceId) throws UnknownSequenceException {
        assert (this.sequenceManager != null);
        return this.sequenceManager.getSequence(sequenceId);
    }

    public Sequence getOutboundSequence(String sequenceId) throws UnknownSequenceException {
        assert (this.sequenceManager != null);
        return this.sequenceManager.getSequence(sequenceId);
    }

    public Sequence getBoundSequence(String sequenceId) throws UnknownSequenceException {
        assert (this.sequenceManager != null);
        return this.sequenceManager.getBoundSequence(sequenceId);
    }

    public String getBoundSequenceId(String sequenceId) throws UnknownSequenceException {
        assert (this.sequenceManager != null);
        Sequence boundSequence = this.sequenceManager.getBoundSequence(sequenceId);
        return boundSequence != null ? boundSequence.getId() : null;
    }

    public SequenceManager sequenceManager() {
        assert (this.sequenceManager != null);
        return this.sequenceManager;
    }

    public void setSequenceManager(@NotNull SequenceManager newValue) {
        assert (newValue != null);
        this.sequenceManager = newValue;
        this.sourceMessageHandler.setSequenceManager(newValue);
        this.destinationMessageHandler.setSequenceManager(newValue);
        this.redeliveryTask.setTimeSynchronizer(newValue);
    }

    public static final class Builder {
        @NotNull
        private final RxConfiguration configuration;
        @NotNull
        private final Communicator communicator;
        @NotNull
        private final RedeliveryTask redeliveryTask;
        @Nullable
        private SequenceManager sequenceManager;
        @Nullable
        private SourceMessageHandler sourceMessageHandler;
        @Nullable
        private DestinationMessageHandler destinationMessageHandler;

        public Builder(@NotNull RxConfiguration configuration, @NotNull Communicator communicator) {
            assert (configuration != null);
            assert (communicator != null);
            this.configuration = configuration;
            this.communicator = communicator;
            this.sourceMessageHandler = new SourceMessageHandler(null);
            this.destinationMessageHandler = new DestinationMessageHandler(null);
            this.redeliveryTask = new RedeliveryTask(this.sourceMessageHandler, null);
        }

        public Builder sequenceManager(SequenceManager sequenceManager) {
            this.sequenceManager = sequenceManager;
            this.sourceMessageHandler.setSequenceManager(sequenceManager);
            this.destinationMessageHandler.setSequenceManager(sequenceManager);
            this.redeliveryTask.setTimeSynchronizer(sequenceManager);
            return this;
        }

        public RuntimeContext build() {
            return new RuntimeContext(this.configuration, this.sequenceManager, this.communicator, new SuspendedFiberStorage(), new ScheduledTaskManager(), this.sourceMessageHandler, this.destinationMessageHandler, this.redeliveryTask);
        }
    }
}

