/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.rx.rm.runtime.sequence.persistent;

import com.sun.istack.logging.Logger;
import com.sun.xml.ws.rx.rm.runtime.sequence.persistent.PersistenceException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.logging.Level;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;

final class ConnectionManager {
    private static final Logger LOGGER = Logger.getLogger(ConnectionManager.class);
    private static final String RM_JDBC_POOL_NAME = "jdbc/ReliableMessagingPool";
    private final DataSource ds = ConnectionManager.getDataSource("jdbc/ReliableMessagingPool");

    public static ConnectionManager getInstance() {
        return new ConnectionManager();
    }

    private static synchronized DataSource getDataSource(String jndiName) throws PersistenceException {
        try {
            InitialContext ic = new InitialContext();
            Object __ds = ic.lookup(jndiName);
            if (!(__ds instanceof DataSource)) {
                throw new PersistenceException(String.format("Object of class '%s' bound in the JNDI under '%s' is not an instance of '%s'.", __ds.getClass().getName(), jndiName, DataSource.class.getName()));
            }
            DataSource ds = (DataSource)DataSource.class.cast(__ds);
            return ds;
        }
        catch (NamingException ex) {
            throw (PersistenceException)((Object)LOGGER.logSevereException((Throwable)((Object)new PersistenceException("Unable to lookup Metro reliable messaging JDBC connection pool", ex))));
        }
    }

    private ConnectionManager() {
    }

    Connection getConnection(boolean autoCommit) throws PersistenceException {
        try {
            Connection connection = this.ds.getConnection("username", "password");
            connection.setTransactionIsolation(4);
            connection.setAutoCommit(autoCommit);
            return connection;
        }
        catch (SQLException ex) {
            throw (PersistenceException)((Object)LOGGER.logSevereException((Throwable)((Object)new PersistenceException("Unable to retrieve JDBC connection to Metro reliable messaging database", ex))));
        }
    }

    PreparedStatement prepareStatement(Connection sqlConnection, String sqlStatement) throws SQLException {
        LOGGER.finer(String.format("Preparing SQL statement:\n%s", sqlStatement));
        return sqlConnection.prepareStatement(sqlStatement);
    }

    void recycle(ResultSet ... resources) {
        for (ResultSet resource : resources) {
            if (resource == null) continue;
            try {
                resource.close();
            }
            catch (SQLException ex) {
                LOGGER.logException((Throwable)ex, Level.WARNING);
            }
        }
    }

    void recycle(PreparedStatement ... resources) {
        for (PreparedStatement resource : resources) {
            if (resource == null) continue;
            try {
                resource.close();
            }
            catch (SQLException ex) {
                LOGGER.logException((Throwable)ex, Level.WARNING);
            }
        }
    }

    void recycle(Connection connection) {
        if (connection != null) {
            try {
                connection.close();
            }
            catch (SQLException ex) {
                LOGGER.logException((Throwable)ex, Level.WARNING);
            }
        }
    }

    void rollback(Connection sqlConnection) {
        try {
            sqlConnection.rollback();
        }
        catch (SQLException ex) {
            LOGGER.warning("Unexpected exception occured while performing transaction rollback", (Throwable)ex);
        }
    }

    void commit(Connection sqlConnection) throws PersistenceException {
        try {
            sqlConnection.commit();
        }
        catch (SQLException ex) {
            throw (PersistenceException)((Object)LOGGER.logSevereException((Throwable)((Object)new PersistenceException("Unexpected exception occured while performing transaction commit", ex))));
        }
    }
}

