/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.rx.rm.runtime.sequence.persistent;

import com.sun.istack.logging.Logger;
import com.sun.xml.ws.rx.rm.runtime.ApplicationMessage;
import com.sun.xml.ws.rx.rm.runtime.JaxwsApplicationMessage;
import com.sun.xml.ws.rx.rm.runtime.sequence.DuplicateMessageRegistrationException;
import com.sun.xml.ws.rx.rm.runtime.sequence.DuplicateSequenceException;
import com.sun.xml.ws.rx.rm.runtime.sequence.Sequence;
import com.sun.xml.ws.rx.rm.runtime.sequence.SequenceData;
import com.sun.xml.ws.rx.rm.runtime.sequence.persistent.ConnectionManager;
import com.sun.xml.ws.rx.rm.runtime.sequence.persistent.PersistenceException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class PersistentSequenceData
implements SequenceData {
    private static final Logger LOGGER = Logger.getLogger(PersistentSequenceData.class);
    private final String endpointUid;
    private final String sequenceId;
    private final SequenceType type;
    private final String boundSecurityTokenReferenceId;
    private final String boundSequenceId;
    private final long expirationTime;
    private final FieldInfo<Integer> fState = new FieldInfo<Integer>("STATUS", 5, Integer.class);
    private final FieldInfo<String> fAckRequestedFlag = new FieldInfo<String>("ACK_REQUESTED_FLAG", 1, String.class);
    private final FieldInfo<Long> fLastMessageId = new FieldInfo<Long>("LAST_MESSAGE_ID", -5, Long.class);
    private final FieldInfo<Long> fLastActivityTime = new FieldInfo<Long>("LAST_ACTIVITY_TIME", -5, Long.class);
    private final FieldInfo<Long> fLastAcknowledgementRequestTime = new FieldInfo<Long>("LAST_ACK_REQUEST_TIME", -5, Long.class);
    private final ConnectionManager cm;

    PersistentSequenceData(ConnectionManager cm, String endpointUid, String sequenceId, SequenceType type, String securityContextTokenId, String boundId, long expirationTime) {
        this.cm = cm;
        this.endpointUid = endpointUid;
        this.sequenceId = sequenceId;
        this.type = type;
        this.boundSecurityTokenReferenceId = securityContextTokenId;
        this.boundSequenceId = boundId;
        this.expirationTime = expirationTime;
    }

    static PersistentSequenceData newInstance(ConnectionManager cm, String enpointUid, String sequenceId, SequenceType type, String securityContextTokenId, long expirationTime, Sequence.State state, boolean ackRequestedFlag, long lastMessageId, long lastActivityTime, long lastAcknowledgementRequestTime) throws DuplicateSequenceException {
        PersistentSequenceData persistentSequenceData;
        Connection con = cm.getConnection(false);
        PreparedStatement ps = null;
        try {
            ps = cm.prepareStatement(con, "INSERT INTO RM.RM_SEQUENCES (ENDPOINT_UID, ID, TYPE, EXP_TIME, STR_ID, STATUS, ACK_REQUESTED_FLAG, LAST_MESSAGE_ID, LAST_ACTIVITY_TIME, LAST_ACK_REQUEST_TIME) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
            int i = 0;
            ps.setString(++i, enpointUid);
            ps.setString(++i, sequenceId);
            ps.setString(++i, type.id);
            ps.setLong(++i, expirationTime);
            ps.setString(++i, securityContextTokenId);
            ps.setInt(++i, state.asInt());
            ps.setString(++i, Boolean.toString(ackRequestedFlag));
            ps.setLong(++i, lastMessageId);
            ps.setLong(++i, lastActivityTime);
            ps.setLong(++i, lastAcknowledgementRequestTime);
            if (ps.executeUpdate() != 1) {
                cm.rollback(con);
                throw (PersistenceException)((Object)LOGGER.logSevereException((Throwable)((Object)new PersistenceException(String.format("Inserting sequence data for %s sequence with id = [ %s ] failed: Expected inserted rows: 1, Actual: %d", new Object[]{type, sequenceId})))));
            }
            PersistentSequenceData data = PersistentSequenceData.loadInstance(con, cm, enpointUid, sequenceId);
            cm.commit(con);
            persistentSequenceData = data;
        }
        catch (SQLException ex) {
            try {
                cm.rollback(con);
                throw (PersistenceException)((Object)LOGGER.logSevereException((Throwable)((Object)new PersistenceException(String.format("Inserting sequence data for %s sequence with id = [ %s ] failed: An unexpected JDBC exception occured", new Object[]{type, sequenceId}), ex))));
            }
            catch (Throwable throwable) {
                cm.recycle(ps);
                cm.recycle(con);
                throw throwable;
            }
        }
        cm.recycle(ps);
        cm.recycle(con);
        return persistentSequenceData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static PersistentSequenceData loadInstance(ConnectionManager cm, String endpointUid, String sequenceId) {
        Connection con = cm.getConnection(true);
        try {
            PersistentSequenceData persistentSequenceData = PersistentSequenceData.loadInstance(con, cm, endpointUid, sequenceId);
            return persistentSequenceData;
        }
        finally {
            cm.recycle(con);
        }
    }

    private static PersistentSequenceData loadInstance(Connection connection, ConnectionManager cm, String endpointUid, String sequenceId) {
        PersistentSequenceData persistentSequenceData;
        ResultSet rs;
        PreparedStatement ps;
        block6: {
            ps = null;
            ps = cm.prepareStatement(connection, "SELECT TYPE, EXP_TIME, BOUND_ID, STR_ID FROM RM_SEQUENCES WHERE ENDPOINT_UID=? AND ID=?");
            ps.setString(1, endpointUid);
            ps.setString(2, sequenceId);
            rs = ps.executeQuery();
            if (rs.next()) break block6;
            PersistentSequenceData persistentSequenceData2 = null;
            cm.recycle(ps);
            return persistentSequenceData2;
        }
        try {
            if (!rs.isFirst() && !rs.isLast()) {
                throw (PersistenceException)((Object)LOGGER.logSevereException((Throwable)((Object)new PersistenceException(String.format("Duplicate sequence records detected for a sequence with id [ %s ]", sequenceId)))));
            }
            persistentSequenceData = new PersistentSequenceData(cm, endpointUid, sequenceId, SequenceType.fromId(rs.getString("TYPE")), rs.getString("STR_ID"), rs.getString("BOUND_ID"), rs.getLong("EXP_TIME"));
        }
        catch (SQLException ex) {
            try {
                throw (PersistenceException)((Object)LOGGER.logSevereException((Throwable)((Object)new PersistenceException(String.format("Loading sequence data for a sequence with id = [ %s ] failed: An unexpected JDBC exception occured", sequenceId), ex))));
            }
            catch (Throwable throwable) {
                cm.recycle(ps);
                throw throwable;
            }
        }
        cm.recycle(ps);
        return persistentSequenceData;
    }

    static void remove(ConnectionManager cm, String endpointUid, String sequenceId) {
        Connection con = cm.getConnection(false);
        PreparedStatement ps = null;
        try {
            ps = cm.prepareStatement(con, "DELETE FROM RM_SEQUENCES WHERE ENDPOINT_UID=? AND ID=?");
            ps.setString(1, endpointUid);
            ps.setString(2, sequenceId);
            int rowsAffected = ps.executeUpdate();
            if (rowsAffected != 1) {
                cm.rollback(con);
                throw (PersistenceException)((Object)LOGGER.logException((Throwable)((Object)new PersistenceException(String.format("Removing sequence with id = [ %s ] failed: Expected deleted rows: 1, Actual: %d", sequenceId, rowsAffected))), Level.WARNING));
            }
            cm.commit(con);
        }
        catch (SQLException ex) {
            try {
                cm.rollback(con);
                throw (PersistenceException)((Object)LOGGER.logSevereException((Throwable)((Object)new PersistenceException(String.format("Removing sequence with id = [ %s ] failed: An unexpected JDBC exception occured", sequenceId), ex))));
            }
            catch (Throwable throwable) {
                cm.recycle(ps);
                cm.recycle(con);
                throw throwable;
            }
        }
        cm.recycle(ps);
        cm.recycle(con);
    }

    static void bind(ConnectionManager cm, String endpointUid, String referenceSequenceId, String boundSequenceId) {
        Connection con = cm.getConnection(false);
        PreparedStatement ps = null;
        try {
            ps = cm.prepareStatement(con, "UPDATE RM_SEQUENCES SET BOUND_ID=? WHERE ENDPOINT_UID=? AND ID=?");
            ps.setString(1, boundSequenceId);
            ps.setString(2, endpointUid);
            ps.setString(3, referenceSequenceId);
            int rowsAffected = ps.executeUpdate();
            if (rowsAffected != 1) {
                cm.rollback(con);
                throw (PersistenceException)((Object)LOGGER.logException((Throwable)((Object)new PersistenceException(String.format("Binding a sequence with id = [ %s ] to a sequence with id [ %s ] failed: Expected updated rows: 1, Actual: %d", boundSequenceId, referenceSequenceId, rowsAffected))), Level.WARNING));
            }
            cm.commit(con);
        }
        catch (SQLException ex) {
            try {
                cm.rollback(con);
                throw (PersistenceException)((Object)LOGGER.logSevereException((Throwable)((Object)new PersistenceException(String.format("Binding a sequence with id = [ %s ] to a sequence with id [ %s ] failed: An unexpected JDBC exception occured", boundSequenceId, referenceSequenceId), ex))));
            }
            catch (Throwable throwable) {
                cm.recycle(ps);
                cm.recycle(con);
                throw throwable;
            }
        }
        cm.recycle(ps);
        cm.recycle(con);
    }

    @Override
    public String getSequenceId() {
        return this.sequenceId;
    }

    public SequenceType getType() {
        return this.type;
    }

    @Override
    public String getBoundSecurityTokenReferenceId() {
        return this.boundSecurityTokenReferenceId;
    }

    public String getBoundSequenceId() {
        return this.boundSequenceId;
    }

    @Override
    public long getExpirationTime() {
        return this.expirationTime;
    }

    private <T> T getFieldData(FieldInfo<T> fi) {
        Object t;
        Connection con = this.cm.getConnection(true);
        PreparedStatement ps = null;
        try {
            ps = this.cm.prepareStatement(con, "SELECT " + fi.columnName + " " + "FROM RM_SEQUENCES " + "WHERE ENDPOINT_UID=? AND ID=?");
            ps.setString(1, this.endpointUid);
            ps.setString(2, this.sequenceId);
            ResultSet rs = ps.executeQuery();
            if (!rs.next()) {
                throw (PersistenceException)((Object)LOGGER.logSevereException((Throwable)((Object)new PersistenceException(String.format("Sequence record not found for a sequence with id [ %s ]", this.sequenceId)))));
            }
            if (!rs.isFirst() && !rs.isLast()) {
                throw (PersistenceException)((Object)LOGGER.logSevereException((Throwable)((Object)new PersistenceException(String.format("Duplicate sequence records detected for a sequence with id [ %s ]", this.sequenceId)))));
            }
            t = fi.javaClass.cast(rs.getObject(fi.columnName));
        }
        catch (SQLException ex) {
            try {
                throw (PersistenceException)((Object)LOGGER.logSevereException((Throwable)((Object)new PersistenceException(String.format("Loading %s column data on a sequence with id = [ %s ]  failed: An unexpected JDBC exception occured", fi.columnName, this.sequenceId), ex))));
            }
            catch (Throwable throwable) {
                this.cm.recycle(ps);
                this.cm.recycle(con);
                throw throwable;
            }
        }
        this.cm.recycle(ps);
        this.cm.recycle(con);
        return t;
    }

    private <T> void setFieldData(FieldInfo<T> fi, T value) {
        Connection con = this.cm.getConnection(false);
        PreparedStatement ps = null;
        try {
            ps = this.cm.prepareStatement(con, "UPDATE RM_SEQUENCES SET " + fi.columnName + "=? " + "WHERE ENDPOINT_UID=? AND ID=?");
            ps.setObject(1, value, fi.sqlType);
            ps.setString(2, this.endpointUid);
            ps.setString(3, this.sequenceId);
            int rowsAffected = ps.executeUpdate();
            if (rowsAffected != 1) {
                this.cm.rollback(con);
                throw (PersistenceException)((Object)LOGGER.logException((Throwable)((Object)new PersistenceException(String.format("Udating %s column data on a sequence with id = [ %s ]  failed: Expected updated rows: 1, Actual: %d", fi.columnName, this.sequenceId, rowsAffected))), Level.WARNING));
            }
            this.cm.commit(con);
        }
        catch (SQLException ex) {
            try {
                this.cm.rollback(con);
                throw (PersistenceException)((Object)LOGGER.logSevereException((Throwable)((Object)new PersistenceException(String.format("Udating %s column data on a sequence with id = [ %s ]  failed: An unexpected JDBC exception occured", fi.columnName, this.sequenceId), ex))));
            }
            catch (Throwable throwable) {
                this.cm.recycle(ps);
                this.cm.recycle(con);
                throw throwable;
            }
        }
        this.cm.recycle(ps);
        this.cm.recycle(con);
    }

    @Override
    public long getLastMessageNumber() {
        return this.getFieldData(this.fLastMessageId);
    }

    @Override
    public void setLastMessageNumber(long newValue) {
        this.setFieldData(this.fLastMessageId, newValue);
    }

    @Override
    public Sequence.State getState() {
        return Sequence.State.asState(this.getFieldData(this.fState));
    }

    @Override
    public void setState(Sequence.State newValue) {
        this.setFieldData(this.fState, newValue.asInt());
    }

    @Override
    public boolean getAckRequestedFlag() {
        return Boolean.valueOf(this.getFieldData(this.fAckRequestedFlag));
    }

    @Override
    public void setAckRequestedFlag(boolean newValue) {
        this.setFieldData(this.fAckRequestedFlag, Boolean.toString(newValue));
    }

    @Override
    public long getLastAcknowledgementRequestTime() {
        return this.getFieldData(this.fLastAcknowledgementRequestTime);
    }

    @Override
    public void setLastAcknowledgementRequestTime(long newValue) {
        this.setFieldData(this.fLastAcknowledgementRequestTime, newValue);
    }

    @Override
    public long getLastActivityTime() {
        return this.getFieldData(this.fLastActivityTime);
    }

    @Override
    public void setLastActivityTime(long newValue) {
        this.setFieldData(this.fLastActivityTime, newValue);
    }

    @Override
    public long incrementAndGetLastMessageNumber(boolean received) {
        throw new UnsupportedOperationException("Not implmented yet");
    }

    @Override
    public void registerUnackedMessageNumber(long messageNumber, boolean received) throws DuplicateMessageRegistrationException {
        throw new UnsupportedOperationException("Not implmented yet");
    }

    @Override
    public void markAsAcknowledged(long messageNumber) {
        Connection con = this.cm.getConnection(false);
        PreparedStatement ps = null;
        try {
            ps = this.cm.prepareStatement(con, "DELETE FROM RM_UNACKED_MESSAGES WHERE ENDPOINT_UID=? AND SEQ_ID=? AND MSG_NUMBER=?");
            ps.setString(1, this.endpointUid);
            ps.setString(2, this.sequenceId);
            ps.setLong(3, messageNumber);
            int rowsAffected = ps.executeUpdate();
            if (rowsAffected != 1) {
                this.cm.rollback(con);
                throw (PersistenceException)((Object)LOGGER.logSevereException((Throwable)((Object)new PersistenceException(String.format("Message acknowledgement failed for %s sequence with id = [ %s ] and message number [ %d ]: Expected deleted rows: 1, Actual: %d", new Object[]{this.type, this.sequenceId, messageNumber, rowsAffected})))));
            }
            this.cm.commit(con);
        }
        catch (SQLException ex) {
            try {
                this.cm.rollback(con);
                throw (PersistenceException)((Object)LOGGER.logSevereException((Throwable)((Object)new PersistenceException(String.format("Message acknowledgement failed for %s sequence with id = [ %s ] and message number [ %d ]: An unexpected JDBC exception occured", new Object[]{this.type, this.sequenceId, messageNumber}), ex))));
            }
            catch (Throwable throwable) {
                this.cm.recycle(ps);
                this.cm.recycle(con);
                throw throwable;
            }
        }
        this.cm.recycle(ps);
        this.cm.recycle(con);
    }

    @Override
    public List<Long> getUnackedMessageNumbers() {
        LinkedList<Long> linkedList;
        Connection con = this.cm.getConnection(true);
        PreparedStatement ps = null;
        try {
            ps = this.cm.prepareStatement(con, "SELECT MSG_NUMBER FROM RM_UNACKED_MESSAGES WHERE ENDPOINT_UID=? AND SEQ_ID=?");
            ps.setString(1, this.endpointUid);
            ps.setString(2, this.sequenceId);
            ResultSet rs = ps.executeQuery();
            LinkedList<Long> result = new LinkedList<Long>();
            while (rs.next()) {
                result.add(rs.getLong("MSG_NUMBER"));
            }
            linkedList = result;
        }
        catch (SQLException ex) {
            try {
                throw (PersistenceException)((Object)LOGGER.logSevereException((Throwable)((Object)new PersistenceException(String.format("Unable to load list of unacked message registration for %s sequence with id = [ %s ]: An unexpected JDBC exception occured", new Object[]{this.type, this.sequenceId}), ex))));
            }
            catch (Throwable throwable) {
                this.cm.recycle(ps);
                this.cm.recycle(con);
                throw throwable;
            }
        }
        this.cm.recycle(ps);
        this.cm.recycle(con);
        return linkedList;
    }

    @Override
    public List<Long> getLastMessageNumberWithUnackedMessageNumbers() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void attachMessageToUnackedMessageNumber(ApplicationMessage message) {
        ByteArrayInputStream bais = null;
        Connection con = this.cm.getConnection(false);
        PreparedStatement ps = null;
        try {
            ps = this.cm.prepareStatement(con, "UPDATE RM_UNACKED_MESSAGES SET IS_RECEIVED=?, CORRELATION_ID=?, NEXT_RESEND_COUNT=?, MSG_DATA=? WHERE ENDPOINT_UID=? AND SEQ_ID=? AND MSG_NUMBER=?");
            int i = 0;
            ps.setString(++i, Boolean.TRUE.toString());
            ps.setString(++i, message.getCorrelationId());
            ps.setLong(++i, message.getNextResendCount());
            byte[] msgData = message.toBytes();
            bais = new ByteArrayInputStream(msgData);
            ps.setBinaryStream(++i, (InputStream)bais, msgData.length);
            ps.setString(++i, this.endpointUid);
            ps.setString(++i, this.sequenceId);
            ps.setLong(++i, message.getMessageNumber());
            int rowsAffected = ps.executeUpdate();
            if (rowsAffected != 1) {
                this.cm.rollback(con);
                throw (PersistenceException)((Object)LOGGER.logSevereException((Throwable)((Object)new PersistenceException(String.format("Storing message data in an unacked message registration for %s sequence with id = [ %s ] and message number [ %d ] has failed: Expected updated rows: 1, Actual: %d", new Object[]{this.type, this.sequenceId, message.getMessageNumber(), rowsAffected})))));
            }
            this.cm.commit(con);
        }
        catch (SQLException ex) {
            try {
                this.cm.rollback(con);
                throw (PersistenceException)((Object)LOGGER.logSevereException((Throwable)((Object)new PersistenceException(String.format("Unable to store message data in an unacked message registration for %s sequence with id = [ %s ] and message number [ %d ]: An unexpected JDBC exception occured", new Object[]{this.type, this.sequenceId, message.getMessageNumber()}), ex))));
            }
            catch (Throwable throwable) {
                this.cm.recycle(ps);
                this.cm.recycle(con);
                if (bais != null) {
                    try {
                        bais.close();
                    }
                    catch (IOException ex2) {
                        LOGGER.warning("Error closing ByteArrayOutputStream after message bytes were sent to DB", (Throwable)ex2);
                    }
                }
                throw throwable;
            }
        }
        this.cm.recycle(ps);
        this.cm.recycle(con);
        if (bais != null) {
            try {
                bais.close();
            }
            catch (IOException ex) {
                LOGGER.warning("Error closing ByteArrayOutputStream after message bytes were sent to DB", (Throwable)ex);
            }
        }
    }

    @Override
    public ApplicationMessage retrieveMessage(String correlationId) {
        JaxwsApplicationMessage jaxwsApplicationMessage;
        ResultSet rs;
        PreparedStatement ps;
        Connection con;
        ByteArrayInputStream bais;
        block15: {
            bais = null;
            con = this.cm.getConnection(true);
            ps = null;
            ps = this.cm.prepareStatement(con, "SELECT MSG_NUMBER, NEXT_RESEND_COUNT, MSG_DATA FROM RM_UNACKED_MESSAGES WHERE ENDPOINT_UID=? AND SEQ_ID=? AND CORRELATION_ID=?");
            ps.setString(1, this.endpointUid);
            ps.setString(2, this.sequenceId);
            ps.setString(3, correlationId);
            rs = ps.executeQuery();
            if (rs.next()) break block15;
            ApplicationMessage applicationMessage = null;
            this.cm.recycle(ps);
            this.cm.recycle(con);
            if (bais != null) {
                try {
                    bais.close();
                }
                catch (IOException ex) {
                    LOGGER.warning("Error closing ByteArrayOutputStream after message bytes were sent to DB", (Throwable)ex);
                }
            }
            return applicationMessage;
        }
        try {
            if (!rs.isFirst() && !rs.isLast()) {
                throw (PersistenceException)((Object)LOGGER.logSevereException((Throwable)((Object)new PersistenceException(String.format("Duplicate records detected for unacked message registration on %s sequence with id = [ %s ] and correlation id [ %d ]", new Object[]{this.type, this.sequenceId, correlationId})))));
            }
            jaxwsApplicationMessage = JaxwsApplicationMessage.newInstance(rs.getBlob("MSG_DATA").getBinaryStream(), rs.getInt("NEXT_RESEND_COUNT"), correlationId, this.sequenceId, rs.getLong("MSG_NUMBER"));
        }
        catch (SQLException ex) {
            try {
                throw (PersistenceException)((Object)LOGGER.logSevereException((Throwable)((Object)new PersistenceException(String.format("Unable to load message data from an unacked message registration for %s sequence with id = [ %s ] and correlation id [ %d ]: An unexpected JDBC exception occured", new Object[]{this.type, this.sequenceId, correlationId}), ex))));
            }
            catch (Throwable throwable) {
                this.cm.recycle(ps);
                this.cm.recycle(con);
                if (bais != null) {
                    try {
                        bais.close();
                    }
                    catch (IOException ex2) {
                        LOGGER.warning("Error closing ByteArrayOutputStream after message bytes were sent to DB", (Throwable)ex2);
                    }
                }
                throw throwable;
            }
        }
        this.cm.recycle(ps);
        this.cm.recycle(con);
        if (bais != null) {
            try {
                bais.close();
            }
            catch (IOException ex) {
                LOGGER.warning("Error closing ByteArrayOutputStream after message bytes were sent to DB", (Throwable)ex);
            }
        }
        return jaxwsApplicationMessage;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class FieldInfo<T> {
        final String columnName;
        final int sqlType;
        final Class<T> javaClass;

        public FieldInfo(String columnName, int sqlType, Class<T> javaClass) {
            this.columnName = columnName;
            this.sqlType = sqlType;
            this.javaClass = javaClass;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum SequenceType {
        Inbound("I"),
        Outbound("O");

        private final String id;

        private SequenceType(String id) {
            this.id = id;
        }

        private static SequenceType fromId(String id) {
            for (SequenceType type : SequenceType.values()) {
                if (!type.id.equals(id)) continue;
                return type;
            }
            return null;
        }
    }
}

