/*
 * Decompiled with CFR 0.152.
 */
package com.sun.mojarra.scales.component;

import com.sun.mojarra.scales.component.LayoutUnit;
import com.sun.mojarra.scales.component.Links;
import com.sun.mojarra.scales.util.CssUtil;
import com.sun.mojarra.scales.util.RenderingHelper;
import com.sun.mojarra.scales.util.ScalesUtil;
import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.component.UIOutput;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;

public class Layout
extends UIOutput {
    public static final String COMPONENT_FAMILY = "com.sun.mojarra.scales.Layout";
    public static final String COMPONENT_TYPE = "com.sun.mojarra.scales.Layout";
    public static final String RENDERER_TYPE = "com.sun.mojarra.scales.Layout";
    private Object[] _state = null;
    protected Boolean fullPage;
    private String style;
    private String styleClass;

    public Layout() {
        this.setRendererType("com.sun.mojarra.scales.Layout");
        FacesContext context = FacesContext.getCurrentInstance();
        if (context != null) {
            String baseUrl = context.getExternalContext().getRequestContextPath();
            Links.addCss("SCALES_EXTERNAL_STYLESHEETS", baseUrl + ScalesUtil.createResourceUrl(context, "/yui/assets/skins/sam/resize.css"));
            Links.addCss("SCALES_EXTERNAL_STYLESHEETS", baseUrl + ScalesUtil.createResourceUrl(context, "/yui/reset-fonts-grids/reset-fonts-grids.css"));
            Links.addCss("SCALES_INLINE_STYLESHEET", ".yui-skin-sam .yui-layout { background-color: #ffffff;}");
            Links.addScript("SCALES_EXTERNAL_SCRIPTS", baseUrl + ScalesUtil.createResourceUrl(context, "/yui/utilities/utilities.js"));
            Links.addScript("SCALES_EXTERNAL_SCRIPTS", baseUrl + ScalesUtil.createResourceUrl(context, "/yui/resize/resize-min.js"));
            Links.addScript("SCALES_EXTERNAL_SCRIPTS", baseUrl + ScalesUtil.createResourceUrl(context, "/yui/layout/layout-min.js"));
            CssUtil.linkResizeOverrides(context);
            CssUtil.linkLayoutOverrides(context);
        }
    }

    public String getFamily() {
        return "com.sun.mojarra.scales.Layout";
    }

    public void encodeBegin(FacesContext context) throws IOException {
        super.encodeBegin(context);
        if (!this.isRendered()) {
            return;
        }
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("div", (UIComponent)this);
        writer.writeAttribute("class", (Object)("yui-skin-sam " + this.getStyleClass()), "class");
        writer.writeAttribute("style", (Object)("visibility: hidden; " + this.getStyle()), "style");
        writer.writeAttribute("id", (Object)this.getClientId(context), "id");
    }

    public void encodeEnd(FacesContext context) throws IOException {
        super.encodeEnd(context);
        if (!this.isRendered()) {
            return;
        }
        ResponseWriter writer = context.getResponseWriter();
        writer.endElement("div");
        writer.write("\n");
        RenderingHelper.writeOnDomReady(writer, "scales.createLayoutManager(" + this.buildLayoutConfig(context) + ");");
    }

    public boolean getRendersChildren() {
        return false;
    }

    protected String buildLayoutConfig(FacesContext context) {
        StringBuilder builder = new StringBuilder();
        String sep = "";
        builder.append("'").append(this.getClientId(context)).append("', ").append(this.getAttributes().get("fullPage")).append(", new Array(");
        for (UIComponent comp : this.getChildren()) {
            if (!(comp instanceof LayoutUnit) || !comp.isRendered()) continue;
            LayoutUnit lu = (LayoutUnit)comp;
            builder.append(sep).append("{position: '").append(lu.getPosition()).append("', body: '").append(lu.getClientId(context)).append("'");
            ScalesUtil.appendToConfigIfNotNull(builder, "header", lu.getHeader(), true, true);
            ScalesUtil.appendToConfigIfNotNull(builder, "width", lu.getWidth(), false, true);
            ScalesUtil.appendToConfigIfNotNull(builder, "height", lu.getHeight(), false, true);
            ScalesUtil.appendToConfigIfNotNull(builder, "resize", lu.getResize(), false, true);
            ScalesUtil.appendToConfigIfNotNull(builder, "minWidth", lu.getMinWidth(), false, true);
            ScalesUtil.appendToConfigIfNotNull(builder, "maxWidth", lu.getMaxWidth(), false, true);
            ScalesUtil.appendToConfigIfNotNull(builder, "minHeight", lu.getMinHeight(), false, true);
            ScalesUtil.appendToConfigIfNotNull(builder, "maxHeight", lu.getMaxHeight(), false, true);
            ScalesUtil.appendToConfigIfNotNull(builder, "gutter", lu.getGutter(), true, true);
            ScalesUtil.appendToConfigIfNotNull(builder, "footer", lu.getFooter(), true, true);
            ScalesUtil.appendToConfigIfNotNull(builder, "collapse", lu.getCollapse(), false, true);
            ScalesUtil.appendToConfigIfNotNull(builder, "scroll", lu.getScroll(), false, true);
            ScalesUtil.appendToConfigIfNotNull(builder, "animate", lu.getAnimate(), false, true);
            builder.append("}");
            sep = ",";
        }
        builder.append(")");
        return builder.toString();
    }

    public Boolean getFullPage() {
        return ScalesUtil.getPropertyValue((UIComponent)this, this.fullPage, "fullPage", Boolean.TRUE);
    }

    public void setFullPage(Boolean fullPage) {
        this.fullPage = fullPage;
    }

    public String getStyle() {
        return ScalesUtil.getPropertyValue((UIComponent)this, this.style, "style", "");
    }

    public void setStyle(String style) {
        this.style = style;
    }

    public String getStyleClass() {
        return ScalesUtil.getPropertyValue((UIComponent)this, this.styleClass, "styleClass", "");
    }

    public void setStyleClass(String styleClass) {
        this.styleClass = styleClass;
    }

    public Object saveState(FacesContext context) {
        if (this._state == null) {
            this._state = new Object[4];
        }
        this._state[0] = super.saveState(context);
        this._state[1] = this.fullPage;
        this._state[2] = this.style;
        this._state[3] = this.styleClass;
        return this._state;
    }

    public void restoreState(FacesContext context, Object state) {
        this._state = (Object[])state;
        super.restoreState(context, this._state[0]);
        this.fullPage = (Boolean)this._state[1];
        this.style = (String)this._state[2];
        this.styleClass = (String)this._state[3];
    }
}

