/*
 * Decompiled with CFR 0.152.
 */
package com.sun.mojarra.scales.component;

import com.sun.mojarra.scales.component.Links;
import com.sun.mojarra.scales.util.CssUtil;
import com.sun.mojarra.scales.util.RenderingHelper;
import com.sun.mojarra.scales.util.ScalesUtil;
import java.io.IOException;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;

public class YuiSlider
extends UIInput {
    public static final String COMPONENT_FAMILY = "com.sun.mojarra.scales.YuiSlider";
    public static final String RENDERER_TYPE = "com.sun.mojarra.scales.YuiSlider";
    public static final String COMPONENT_TYPE = "com.sun.mojarra.scales.YuiSlider";
    private Boolean animate;
    private Double animationDuration;
    private Integer min;
    private Float scaleFactor;
    private Integer max;
    private Integer tick;
    private String orientation;
    private String update;
    private String style;
    private String styleClass;
    private Object[] _state = null;

    public YuiSlider() {
        this.setRendererType("com.sun.mojarra.scales.YuiSlider");
        FacesContext context = FacesContext.getCurrentInstance();
        if (context != null) {
            String baseUrl = context.getExternalContext().getRequestContextPath();
            Links.addScript("SCALES_EXTERNAL_SCRIPTS", baseUrl + ScalesUtil.createResourceUrl(context, "/yui/slider/slider-min.js"));
            Links.addCss("SCALES_EXTERNAL_STYLESHEETS", baseUrl + ScalesUtil.createResourceUrl(context, "/yui/assets/skins/sam/skin.css"));
            CssUtil.linkSliderOverrides(context);
        }
    }

    public String getFamily() {
        return "com.sun.mojarra.scales.YuiSlider";
    }

    public void encodeBegin(FacesContext context) throws IOException {
        super.encodeBegin(context);
        if (!this.isRendered()) {
            return;
        }
        ResponseWriter writer = context.getResponseWriter();
        String clientId = this.getClientId(context);
        boolean isHorizontal = "horizontal".equalsIgnoreCase(this.getOrientation());
        String baseUrl = ScalesUtil.getStaticResourceUrl(context, "");
        Integer value = (Integer)this.getValue();
        int counterDimension = Math.round((float)(this.getMax() - this.getMin()) * this.getScaleFactor() + 14.0f);
        RenderingHelper.outputElement(writer, (UIComponent)this, "input", new String[][]{{"type", "hidden"}, {"id", clientId}, {"name", clientId}, {"value", value != null ? value.toString() : "0"}});
        writer.startElement("div", (UIComponent)this);
        writer.writeAttribute("id", (Object)(clientId + "_slider"), "id");
        writer.writeAttribute("class", (Object)this.getStyleClass(), "class");
        writer.writeAttribute("style", (Object)("background-image: url('" + baseUrl + "scales/img/slider-bg-" + this.getOrientation() + ".gif'); background-repeat: repeat-" + (isHorizontal ? "x" : "y") + ";" + (isHorizontal ? "height" : "width") + ": 28px;" + (isHorizontal ? "width" : "height") + ": " + counterDimension + "px; " + this.getStyle()), "style");
        writer.startElement("div", (UIComponent)this);
        writer.writeAttribute("id", (Object)(clientId + "_sliderthumb"), "id");
        writer.startElement("img", (UIComponent)this);
        writer.writeAttribute("src", (Object)(baseUrl + "scales/img/slider-thumb-" + this.getOrientation().toLowerCase() + ".gif"), "src");
        writer.endElement("img");
        writer.endElement("div");
        writer.endElement("div");
        RenderingHelper.writeOnDomReady(writer, "scales.createSlider('" + clientId + "', {" + this.buildConfig() + "});");
    }

    protected String buildConfig() {
        StringBuilder builder = new StringBuilder();
        ScalesUtil.appendToConfig(builder, "orientation", this.getOrientation(), true, false);
        ScalesUtil.appendToConfig(builder, "min", this.getMin(), false, true);
        ScalesUtil.appendToConfig(builder, "max", this.getMax(), false, true);
        ScalesUtil.appendToConfig(builder, "tick", this.getTick(), false, true);
        ScalesUtil.appendToConfig(builder, "scaleFactor", Float.valueOf(this.getScaleFactor()), false, true);
        ScalesUtil.appendToConfig(builder, "animate", this.getAnimate(), false, true);
        ScalesUtil.appendToConfig(builder, "animationDuration", this.getAnimationDuration(), false, true);
        ScalesUtil.appendToConfigIfNotNull(builder, "update", this.getUpdate(), true, true);
        ScalesUtil.appendToConfig(builder, "value", this.getValue(), false, true);
        return builder.toString();
    }

    public void decode(FacesContext facesContext) {
        Map requestMap = facesContext.getExternalContext().getRequestParameterMap();
        String clientId = this.getClientId(facesContext);
        String string_submit_val = (String)requestMap.get(clientId);
        Integer integer = Integer.decode(string_submit_val);
        this.setSubmittedValue(integer);
    }

    public Boolean getAnimate() {
        return ScalesUtil.getPropertyValue((UIComponent)this, this.animate, "animate", Boolean.TRUE);
    }

    public void setAnimate(Boolean animate) {
        this.animate = animate;
    }

    public Double getAnimationDuration() {
        return ScalesUtil.getPropertyValue((UIComponent)this, this.animationDuration, "animationDuration", 0.2);
    }

    public void setAnimationDuration(Double animationDuration) {
        this.animationDuration = animationDuration;
    }

    public String getUpdate() {
        return ScalesUtil.getPropertyValue((UIComponent)this, this.update, "update", null);
    }

    public void setUpdate(String update) {
        this.update = update;
    }

    public int getMax() {
        return ScalesUtil.getPropertyValue((UIComponent)this, this.max, "max", 100);
    }

    public void setMax(int max) {
        this.max = max;
    }

    public int getMin() {
        return ScalesUtil.getPropertyValue((UIComponent)this, this.min, "min", 1);
    }

    public void setMin(int min) {
        this.min = min;
    }

    public String getOrientation() {
        return ScalesUtil.getPropertyValue((UIComponent)this, this.orientation, "orientation", "horoizontal");
    }

    public void setOrientation(String orientation) {
        this.orientation = orientation;
    }

    public float getScaleFactor() {
        return ScalesUtil.getPropertyValue((UIComponent)this, this.scaleFactor, "scaleFactor", Float.valueOf(1.0f)).floatValue();
    }

    public void setScaleFactor(float scaleFactor) {
        this.scaleFactor = Float.valueOf(scaleFactor);
    }

    public String getStyle() {
        return ScalesUtil.getPropertyValue((UIComponent)this, this.style, "style", "");
    }

    public void setStyle(String style) {
        this.style = style;
    }

    public String getStyleClass() {
        return ScalesUtil.getPropertyValue((UIComponent)this, this.styleClass, "styleClass", "");
    }

    public void setStyleClass(String styleClass) {
        this.styleClass = styleClass;
    }

    public int getTick() {
        return ScalesUtil.getPropertyValue((UIComponent)this, this.tick, "tick", 1);
    }

    public void setTick(int tick) {
        this.tick = tick;
    }

    public void restoreState(FacesContext _context, Object _state) {
        this._state = (Object[])_state;
        super.restoreState(_context, this._state[0]);
        this.animate = (Boolean)this._state[1];
        this.animationDuration = (Double)this._state[2];
        this.min = (Integer)this._state[4];
        this.style = (String)this._state[5];
        this.styleClass = (String)this._state[6];
        this.scaleFactor = (Float)this._state[7];
        this.max = (Integer)this._state[8];
        this.tick = (Integer)this._state[9];
        this.orientation = (String)this._state[10];
        this.update = (String)this._state[11];
    }

    public Object saveState(FacesContext _context) {
        if (this._state == null) {
            this._state = new Object[12];
        }
        this._state[0] = super.saveState(_context);
        this._state[1] = this.animate;
        this._state[2] = this.animationDuration;
        this._state[4] = this.min;
        this._state[5] = this.style;
        this._state[6] = this.styleClass;
        this._state[7] = this.scaleFactor;
        this._state[8] = this.max;
        this._state[9] = this.tick;
        this._state[10] = this.orientation;
        this._state[11] = this.update;
        return this._state;
    }
}

