/*
 * Decompiled with CFR 0.152.
 */
package com.sun.mojarra.scales.renderer;

import com.sun.mojarra.scales.component.Links;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.render.Renderer;

public class LinksRenderer
extends Renderer {
    public void encodeBegin(FacesContext context, UIComponent component) throws IOException {
        if (context == null) {
            throw new NullPointerException("param 'context' is null");
        }
        if (component == null) {
            throw new NullPointerException("param 'component' is null");
        }
        if (!component.isRendered()) {
            return;
        }
        if (!(component instanceof Links)) {
            throw new IllegalStateException("Was expecting Links.  Found " + component.getClass().getName());
        }
        Links links = (Links)component;
        Set<String> scripts = Links.getScripts("SCALES_EXTERNAL_SCRIPTS");
        Set<String> onReady = Links.getScripts("SCALES_DOM_READY_SCRIPTS");
        Set<String> externalCss = Links.getCss("SCALES_EXTERNAL_STYLESHEETS");
        Set<String> inlineCss = Links.getCss("SCALES_INLINE_STYLESHEET");
        Map<String, String> tags = Links.getMeta();
        if (scripts.size() > 0 || onReady.size() > 0 || externalCss.size() > 0 || tags.size() > 0 || inlineCss.size() > 0) {
            Iterator<String> i;
            ResponseWriter writer = context.getResponseWriter();
            if (tags != null) {
                for (Map.Entry<String, String> entry : tags.entrySet()) {
                    writer.startElement("meta", (UIComponent)links);
                    writer.writeAttribute("name", (Object)entry.getKey(), "name");
                    writer.writeAttribute("content", (Object)entry.getValue(), "content");
                    writer.endElement("meta");
                }
                tags.clear();
            }
            for (String styleSheet : externalCss) {
                writer.startElement("link", (UIComponent)links);
                writer.writeURIAttribute("href", (Object)styleSheet, "href");
                writer.writeAttribute("rel", (Object)"stylesheet", "rel");
                writer.writeAttribute("type", (Object)"text/css", "type");
                writer.endElement("link");
            }
            for (String script : scripts) {
                writer.startElement("script", (UIComponent)links);
                writer.writeAttribute("type", (Object)"text/javascript", "type");
                writer.writeURIAttribute("src", (Object)script, "src");
                writer.endElement("script");
            }
            if (onReady.size() > 0) {
                writer.startElement("script", (UIComponent)links);
                writer.writeAttribute("type", (Object)"text/javascript", "type");
                writer.write("YAHOO.util.Event.onDOMReady(function() {");
                i = onReady.iterator();
                while (i.hasNext()) {
                    writer.write(i.next());
                }
                writer.write("});");
                writer.endElement("script");
                onReady.clear();
            }
            if (inlineCss.size() > 0) {
                writer.startElement("style", (UIComponent)links);
                writer.writeAttribute("type", (Object)"text/css", "type");
                i = inlineCss.iterator();
                while (i.hasNext()) {
                    writer.write(i.next());
                }
                writer.endElement("style");
            }
            scripts.clear();
            externalCss.clear();
        }
    }
}

