/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.runtime;

import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLConnection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletContainerInitializer;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRegistration;
import javax.servlet.descriptor.JspConfigDescriptor;
import javax.servlet.descriptor.TaglibDescriptor;
import org.apache.jasper.JasperException;
import org.apache.jasper.compiler.Localizer;
import org.apache.jasper.xmlparser.ParserUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TldScanner
implements ServletContainerInitializer {
    private static Logger log = Logger.getLogger(TldScanner.class.getName());
    public static final int ABS_URI = 0;
    public static final int ROOT_REL_URI = 1;
    public static final int NOROOT_REL_URI = 2;
    private static final String WEB_XML = "/WEB-INF/web.xml";
    private static final String FILE_PROTOCOL = "file:";
    private static final String JAR_FILE_SUFFIX = ".jar";
    private static HashSet<String> systemUris = new HashSet();
    private static HashSet<String> systemUrisJsf = new HashSet();
    private HashMap<String, String[]> mappings;
    private ServletContext ctxt;
    private boolean isValidationEnabled;
    private boolean useMyFaces = false;
    private boolean scanListeners;

    public TldScanner() {
    }

    public TldScanner(ServletContext ctxt, boolean isValidationEnabled) {
        this.ctxt = ctxt;
        this.isValidationEnabled = isValidationEnabled;
        Boolean b = (Boolean)ctxt.getAttribute("com.sun.faces.useMyFaces");
        if (b != null) {
            this.useMyFaces = b;
        }
    }

    public void onStartup(Set<Class<?>> c, ServletContext ctxt) throws ServletException {
        this.ctxt = ctxt;
        Boolean b = (Boolean)ctxt.getAttribute("com.sun.faces.useMyFaces");
        if (b != null) {
            this.useMyFaces = b;
        }
        ServletRegistration reg = ctxt.getServletRegistration("jsp");
        String validating = reg.getInitParameter("validating");
        this.isValidationEnabled = "true".equals(validating);
        this.scanListeners = true;
        this.scanTlds();
        ctxt.setAttribute("com.sun.jsp.tldUriToLocationMap", this.mappings);
    }

    public String[] getLocation(String uri) throws JasperException {
        if (this.mappings == null) {
            this.mappings = (HashMap)this.ctxt.getAttribute("com.sun.jsp.tldUriToLocationMap");
            if (this.mappings == null) {
                this.scanListeners = false;
                this.scanTlds();
            }
        }
        return this.mappings.get(uri);
    }

    public static int uriType(String uri) {
        if (uri.indexOf(58) != -1) {
            return 0;
        }
        if (uri.startsWith("/")) {
            return 1;
        }
        return 2;
    }

    private void scanTlds() throws JasperException {
        this.mappings = new HashMap();
        try {
            this.processWebDotXml();
            this.scanJars();
            this.processTldsInFileSystem("/WEB-INF/");
        }
        catch (Exception ex) {
            throw new JasperException(Localizer.getMessage("jsp.error.internal.tldinit"), ex);
        }
    }

    private void processWebDotXml() throws Exception {
        JspConfigDescriptor jspConfig = this.ctxt.getJspConfigDescriptor();
        if (jspConfig == null) {
            return;
        }
        for (TaglibDescriptor taglib : jspConfig.getTaglibs()) {
            if (taglib == null) continue;
            String tagUri = taglib.getTaglibURI();
            String tagLoc = taglib.getTaglibLocation();
            if (tagUri == null || tagLoc == null || systemUris.contains(tagUri) || !this.useMyFaces && systemUrisJsf.contains(tagUri)) continue;
            if (TldScanner.uriType(tagLoc) == 2) {
                tagLoc = "/WEB-INF/" + tagLoc;
            }
            String tagLoc2 = null;
            if (tagLoc.endsWith(JAR_FILE_SUFFIX)) {
                tagLoc = this.ctxt.getResource(tagLoc).toString();
                tagLoc2 = "META-INF/taglib.tld";
            }
            if (log.isLoggable(Level.FINE)) {
                log.fine("Add tld map from web.xml: " + tagUri + "=>" + tagLoc + "," + tagLoc2);
            }
            this.mappings.put(tagUri, new String[]{tagLoc, tagLoc2});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void scanJar(JarURLConnection conn, List<String> tldNames) throws JasperException, IOException {
        JarFile jarFile = null;
        String resourcePath = conn.getJarFileURL().toString();
        try {
            conn.setUseCaches(false);
            jarFile = conn.getJarFile();
            if (tldNames != null) {
                for (String tldName : tldNames) {
                    JarEntry entry = jarFile.getJarEntry(tldName);
                    InputStream stream = jarFile.getInputStream(entry);
                    this.scanTld(resourcePath, tldName, stream, false);
                }
            } else {
                Enumeration<JarEntry> entries = jarFile.entries();
                while (entries.hasMoreElements()) {
                    JarEntry entry = entries.nextElement();
                    String name = entry.getName();
                    if (!name.startsWith("META-INF/") || !name.endsWith(".tld")) continue;
                    InputStream stream = jarFile.getInputStream(entry);
                    this.scanTld(resourcePath, name, stream, false);
                }
            }
            Object var10_13 = null;
            if (jarFile == null) return;
        }
        catch (Throwable throwable) {
            Object var10_14 = null;
            if (jarFile == null) throw throwable;
            try {
                jarFile.close();
                throw throwable;
            }
            catch (Throwable t) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            jarFile.close();
            return;
        }
        catch (Throwable t) {}
    }

    private void processTldsInFileSystem(String startPath) throws JasperException {
        Set dirList = this.ctxt.getResourcePaths(startPath);
        if (dirList != null) {
            for (String path : dirList) {
                if (path.endsWith("/")) {
                    this.processTldsInFileSystem(path);
                }
                if (!path.endsWith(".tld")) continue;
                if (path.startsWith("/WEB-INF/tags/") && !path.endsWith("implicit.tld")) {
                    throw new JasperException(Localizer.getMessage("jsp.error.tldinit.tldInWebInfTags", path));
                }
                InputStream stream = this.ctxt.getResourceAsStream(path);
                this.scanTld(path, null, stream, true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void scanTld(String resourcePath, String entryName, InputStream stream, boolean isLocal) throws JasperException {
        block17: {
            block13: {
                tld = new ParserUtils().parseXMLDocument(resourcePath, stream, this.isValidationEnabled);
                uriNode = tld.findChild("uri");
                if (uriNode != null) break block14;
                var12_7 = null;
                ** if (stream == null) goto lbl-1000
lbl-1000:
                // 1 sources

                {
                    try {
                        stream.close();
                    }
                    catch (Throwable t) {
                        // empty catch block
                    }
                }
lbl-1000:
                // 3 sources

                {
                    block14: {
                        return;
                    }
                    uri = uriNode.getBody();
                    if (uri != null) break block15;
                }
                var12_8 = null;
                if (stream == null) ** GOTO lbl-1000
                try {
                    stream.close();
                }
                catch (Throwable t) {
                    // empty catch block
                }
lbl-1000:
                // 3 sources

                {
                    block15: {
                        return;
                    }
                    if ((!isLocal || this.mappings.get(uri) != null || TldScanner.systemUris.contains(uri) || TldScanner.systemUrisJsf.contains(uri) && !this.useMyFaces) && (isLocal || this.mappings.get(uri) != null && !TldScanner.systemUris.contains(uri) && (!TldScanner.systemUrisJsf.contains(uri) || this.useMyFaces))) break block13;
                    if (TldScanner.log.isLoggable(Level.FINE)) {
                        TldScanner.log.fine("Add tld map from tld in " + (isLocal != false ? "WEB-INF" : "jar: ") + uri + "=>" + resourcePath + "," + entryName);
                    }
                    this.mappings.put(uri, new String[]{resourcePath, entryName});
                    if (this.scanListeners) break block16;
                }
                var12_9 = null;
                if (stream == null) ** GOTO lbl-1000
                try {
                    stream.close();
                }
                catch (Throwable t) {
                    // empty catch block
                }
lbl-1000:
                // 3 sources

                {
                    block16: {
                        return;
                    }
                    listener = tld.findChild("listener");
                    if (listener == null || (listenerClass = listener.findChild("listener-class")) == null || (listenerClassName = listenerClass.getBody()) == null) break block13;
                    if (TldScanner.log.isLoggable(Level.FINE)) {
                        TldScanner.log.fine("Add tld listener " + listenerClassName);
                    }
                    this.ctxt.addListener(listenerClassName);
                }
            }
            var12_10 = null;
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (Throwable t) {}
            }
            break block17;
            catch (Throwable var11_21) {
                var12_11 = null;
                if (stream != null) {
                    try {
                        stream.close();
                    }
                    catch (Throwable t) {
                        // empty catch block
                    }
                }
                throw var11_21;
            }
        }
    }

    private void scanJars() throws Exception {
        ClassLoader webappLoader;
        for (ClassLoader loader = webappLoader = Thread.currentThread().getContextClassLoader(); loader != null; loader = loader.getParent()) {
            if (!(loader instanceof URLClassLoader)) continue;
            URL[] urls = ((URLClassLoader)loader).getURLs();
            for (int i = 0; i < urls.length; ++i) {
                URLConnection conn = urls[i].openConnection();
                if (conn instanceof JarURLConnection) {
                    this.scanJar((JarURLConnection)conn, null);
                    continue;
                }
                String urlStr = urls[i].toString();
                if (!urlStr.startsWith(FILE_PROTOCOL) || !urlStr.endsWith(JAR_FILE_SUFFIX)) continue;
                URL jarURL = new URL("jar:" + urlStr + "!/");
                this.scanJar((JarURLConnection)jarURL.openConnection(), null);
            }
        }
        Map tldMap = (Map)this.ctxt.getAttribute("com.sun.appserv.tld.map");
        if (tldMap != null) {
            for (URI uri : tldMap.keySet()) {
                URL jarURL = new URL("jar:" + uri.toString() + "!/");
                this.scanJar((JarURLConnection)jarURL.openConnection(), (List)tldMap.get(uri));
            }
        }
    }

    static {
        systemUrisJsf.add("http://java.sun.com/jsf/core");
        systemUrisJsf.add("http://java.sun.com/jsf/html");
        systemUris.add("http://java.sun.com/jsp/jstl/core");
    }
}

