/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.impl.protocol.giopmsgheaders;

import com.sun.corba.ee.impl.encoding.CDRInputStream;
import com.sun.corba.ee.impl.encoding.CDROutputStream;
import com.sun.corba.ee.impl.logging.ORBUtilSystemException;
import com.sun.corba.ee.impl.orbutil.ORBUtility;
import com.sun.corba.ee.impl.orbutil.newtimer.generated.TimingPoints;
import com.sun.corba.ee.impl.protocol.giopmsgheaders.AddressingDispositionHelper;
import com.sun.corba.ee.impl.protocol.giopmsgheaders.MessageBase;
import com.sun.corba.ee.impl.protocol.giopmsgheaders.MessageHandler;
import com.sun.corba.ee.impl.protocol.giopmsgheaders.Message_1_2;
import com.sun.corba.ee.impl.protocol.giopmsgheaders.ReplyMessage;
import com.sun.corba.ee.spi.ior.IOR;
import com.sun.corba.ee.spi.ior.IORFactories;
import com.sun.corba.ee.spi.ior.iiop.GIOPVersion;
import com.sun.corba.ee.spi.orb.ORB;
import com.sun.corba.ee.spi.servicecontext.ServiceContextDefaults;
import com.sun.corba.ee.spi.servicecontext.ServiceContexts;
import java.io.IOException;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.SystemException;
import org.omg.CORBA_2_3.portable.InputStream;
import org.omg.CORBA_2_3.portable.OutputStream;

public final class ReplyMessage_1_2
extends Message_1_2
implements ReplyMessage {
    private ORB orb = null;
    private TimingPoints tp = null;
    private ORBUtilSystemException wrapper = null;
    private int reply_status = 0;
    private ServiceContexts service_contexts = null;
    private IOR ior = null;
    private String exClassName = null;
    private int minorCode = 0;
    private CompletionStatus completionStatus = null;
    private short addrDisposition = 0;

    ReplyMessage_1_2(ORB orb) {
        this.service_contexts = ServiceContextDefaults.makeServiceContexts(orb);
        this.orb = orb;
        this.tp = (TimingPoints)orb.getTimerManager().points();
        this.wrapper = orb.getLogWrapperTable().get_RPC_PROTOCOL_ORBUtil();
    }

    ReplyMessage_1_2(ORB orb, int _request_id, int _reply_status, ServiceContexts _service_contexts, IOR _ior) {
        super(1195986768, GIOPVersion.V1_2, (byte)0, (byte)1, 0);
        this.orb = orb;
        this.tp = (TimingPoints)orb.getTimerManager().points();
        this.wrapper = orb.getLogWrapperTable().get_RPC_PROTOCOL_ORBUtil();
        this.request_id = _request_id;
        this.reply_status = _reply_status;
        this.service_contexts = _service_contexts;
        if (this.service_contexts == null) {
            this.service_contexts = ServiceContextDefaults.makeServiceContexts(orb);
        }
        this.ior = _ior;
    }

    @Override
    public int getRequestId() {
        return this.request_id;
    }

    @Override
    public int getReplyStatus() {
        return this.reply_status;
    }

    @Override
    public short getAddrDisposition() {
        return this.addrDisposition;
    }

    @Override
    public ServiceContexts getServiceContexts() {
        return this.service_contexts;
    }

    @Override
    public SystemException getSystemException(String message) {
        return MessageBase.getSystemException(this.exClassName, this.minorCode, this.completionStatus, message, this.wrapper);
    }

    @Override
    public IOR getIOR() {
        return this.ior;
    }

    @Override
    public void setIOR(IOR ior) {
        this.ior = ior;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void read(org.omg.CORBA.portable.InputStream istream) {
        this.tp.enter_giopHeaderReadReply();
        try {
            super.read(istream);
            this.request_id = istream.read_ulong();
            this.reply_status = istream.read_long();
            ReplyMessage_1_2.isValidReplyStatus(this.reply_status);
            this.service_contexts = ServiceContextDefaults.makeServiceContexts((InputStream)istream);
            ((CDRInputStream)istream).setHeaderPadding(true);
            if (this.reply_status == 2) {
                String reposId = istream.read_string();
                this.exClassName = ORBUtility.classNameOf(reposId);
                this.minorCode = istream.read_long();
                int status = istream.read_long();
                switch (status) {
                    case 0: {
                        this.completionStatus = CompletionStatus.COMPLETED_YES;
                        break;
                    }
                    case 1: {
                        this.completionStatus = CompletionStatus.COMPLETED_NO;
                        break;
                    }
                    case 2: {
                        this.completionStatus = CompletionStatus.COMPLETED_MAYBE;
                        break;
                    }
                    default: {
                        throw this.wrapper.badCompletionStatusInReply(CompletionStatus.COMPLETED_MAYBE, (Object)status);
                    }
                }
            } else if (this.reply_status == 1) {
            } else if (this.reply_status == 3 || this.reply_status == 4) {
                CDRInputStream cdr = (CDRInputStream)istream;
                this.ior = IORFactories.makeIOR(this.orb, cdr);
            } else if (this.reply_status == 5) {
                this.addrDisposition = AddressingDispositionHelper.read(istream);
            }
        }
        finally {
            this.tp.exit_giopHeaderReadReply();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(org.omg.CORBA.portable.OutputStream ostream) {
        this.tp.enter_giopHeaderReadReply();
        try {
            super.write(ostream);
            ostream.write_ulong(this.request_id);
            ostream.write_long(this.reply_status);
            this.service_contexts.write((OutputStream)ostream, GIOPVersion.V1_2);
            ((CDROutputStream)ostream).setHeaderPadding(true);
        }
        finally {
            this.tp.exit_giopHeaderReadReply();
        }
    }

    public static void isValidReplyStatus(int replyStatus) {
        switch (replyStatus) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                break;
            }
            default: {
                ORBUtilSystemException localWrapper = ORB.getStaticLogWrapperTable().get_RPC_PROTOCOL_ORBUtil();
                throw localWrapper.illegalReplyStatus(CompletionStatus.COMPLETED_MAYBE);
            }
        }
    }

    @Override
    public void callback(MessageHandler handler) throws IOException {
        handler.handleInput(this);
    }
}

