/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admingui.common.handlers;

import com.sun.jsftemplating.layout.descriptors.handler.HandlerContext;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.glassfish.admingui.common.util.GuiUtil;
import org.glassfish.admingui.common.util.V3AMX;

public class JdbcTempHandler {
    public static final String REASON_FAILED_KEY = "ReasonFailedKey";
    public static final String SET_KEY = "SetKey";
    public static final String BOOLEAN_KEY = "BooleanKey";
    private static final String PROPERTY_MAP_KEY = "PropertyMapKey";
    private static final String DATA_SOURCE = "javax.sql.DataSource";
    private static final String XADATA_SOURCE = "javax.sql.XADataSource";
    private static final String CCDATA_SOURCE = "javax.sql.ConnectionPoolDataSource";
    private static final String DRIVER = "java.sql.Driver";
    private static final String JAVADB = "JavaDB";
    private static final String ORACLE = "Oracle";
    private static final String DERBY = "Derby";
    private static final String SYBASE = "Sybase";
    private static final String DB2 = "DB2";
    private static final String POINTBASE = "PointBase";
    private static final String POSTGRESQL = "PostgreSQL";
    private static final String INFORMIX = "Informix";
    private static final String CLOUDSCAPE = "Cloudscape";
    private static final String MSSQL = "Microsoft SQL Server";
    private static final String MYSQL = "MySQL";
    private static List resTypeList = new ArrayList();
    private static List dbVendorList = new ArrayList();

    public static void pingConnectionPool(HandlerContext handlerCtx) {
        String jndiName = (String)handlerCtx.getInputValue("jndiName");
        try {
            Map statusMap = V3AMX.getInstance().getConnectorRuntime().pingJDBCConnectionPool(jndiName);
            if (((Boolean)statusMap.get(BOOLEAN_KEY)).booleanValue()) {
                GuiUtil.prepareAlert(handlerCtx, "success", GuiUtil.getMessage("msg.PingSucceed"), null);
            } else {
                GuiUtil.prepareAlert(handlerCtx, "error", GuiUtil.getMessage("msg.Error"), statusMap.get(REASON_FAILED_KEY).toString());
            }
        }
        catch (Exception ex) {
            GuiUtil.handleException(handlerCtx, ex);
        }
    }

    public static void flushConnectionPool(HandlerContext handlerCtx) {
        String jndiName = (String)handlerCtx.getInputValue("jndiName");
        try {
            Map statusMap = V3AMX.getInstance().getConnectorRuntime().flushConnectionPool(jndiName);
            if (((Boolean)statusMap.get(BOOLEAN_KEY)).booleanValue()) {
                GuiUtil.prepareAlert(handlerCtx, "success", GuiUtil.getMessage("msg.FlushSucceed"), null);
            } else {
                GuiUtil.prepareAlert(handlerCtx, "error", GuiUtil.getMessage("msg.Error"), statusMap.get(REASON_FAILED_KEY).toString());
            }
        }
        catch (Exception ex) {
            GuiUtil.handleException(handlerCtx, ex);
        }
    }

    public static void getTableNames(HandlerContext handlerCtx) {
        try {
            Set keys;
            String name = (String)handlerCtx.getInputValue("name");
            ArrayList result = new ArrayList();
            Map tn = V3AMX.getInstance().getConnectorRuntime().getValidationTableNames(name);
            if (tn != null && (keys = (Set)tn.get(SET_KEY)) != null) {
                Iterator iter = keys.iterator();
                while (iter.hasNext()) {
                    result.add(iter.next());
                }
            }
            handlerCtx.setOutputValue("result", result);
        }
        catch (Exception ex) {
            GuiUtil.handleException(handlerCtx, ex);
        }
    }

    public static void setJDBCPoolWizard(HandlerContext handlerCtx) {
        Boolean fromStep2 = (Boolean)handlerCtx.getInputValue("fromStep2");
        if (fromStep2 == null || !fromStep2.booleanValue()) {
            Map attrMap = (Map)handlerCtx.getInputValue("attrMap");
            Map<String, Object> sessionMap = handlerCtx.getFacesContext().getExternalContext().getSessionMap();
            sessionMap.put("valueMap", attrMap);
            sessionMap.put("wizardPoolExtra", new HashMap());
        }
        handlerCtx.setOutputValue("ResTypeList", (Object)resTypeList);
        handlerCtx.setOutputValue("DBVendorList", (Object)dbVendorList);
    }

    public static void updateJDBCPoolWizardStep1(HandlerContext handlerCtx) {
        Map extra = (Map)handlerCtx.getFacesContext().getExternalContext().getSessionMap().get("wizardPoolExtra");
        String resType = (String)extra.get("ResType");
        String dbVendor = (String)extra.get("DBVendor");
        String previousResType = (String)extra.get("PreviousResType");
        String previousDB = (String)extra.get("PreviousDB");
        if (!resType.equals(previousResType) || !dbVendor.equals(previousDB) || GuiUtil.isEmpty((String)extra.get("DatasourceClassname"))) {
            if (!GuiUtil.isEmpty(resType) && !GuiUtil.isEmpty(dbVendor)) {
                try {
                    String classname2 = "";
                    Map dcn = V3AMX.getInstance().getConnectorRuntime().getJdbcDriverClassNames(dbVendor, resType);
                    if (dcn != null) {
                        Set keys = (Set)dcn.get(SET_KEY);
                        for (String classname2 : keys) {
                        }
                    }
                    if (resType.equals(DRIVER)) {
                        extra.put("DriverClassname", classname2);
                        extra.put("DatasourceClassname", "");
                        extra.put("dsClassname", Boolean.FALSE);
                    } else {
                        extra.put("DatasourceClassname", classname2);
                        extra.put("DriverClassname", "");
                        extra.put("dsClassname", Boolean.TRUE);
                    }
                    ArrayList noprops = new ArrayList();
                    if (!GuiUtil.isEmpty(classname2)) {
                        Map result = V3AMX.getInstance().getConnectorRuntime().getConnectionDefinitionPropertiesAndDefaults(classname2, resType);
                        if (result != null) {
                            Map props = (Map)result.get(PROPERTY_MAP_KEY);
                            handlerCtx.getFacesContext().getExternalContext().getSessionMap().put("wizardPoolProperties", GuiUtil.convertMapToListOfMap(props));
                        }
                    } else {
                        handlerCtx.getFacesContext().getExternalContext().getSessionMap().put("wizardPoolProperties", noprops);
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            extra.put("PreviousResType", resType);
            extra.put("PreviousDB", dbVendor);
        }
    }

    public static void updateJdbcConnectionPoolWizardStep2(HandlerContext handlerCtx) {
        Map extra = (Map)handlerCtx.getFacesContext().getExternalContext().getSessionMap().get("wizardPoolExtra");
        Map attrs = (Map)handlerCtx.getFacesContext().getExternalContext().getSessionMap().get("valueMap");
        String resType = (String)extra.get("ResType");
        String classname = (String)extra.get("DatasourceClassname");
        String driver = (String)extra.get("DriverClassname");
        String name = (String)extra.get("Name");
        attrs.put("Name", name);
        attrs.put("DatasourceClassname", classname);
        attrs.put("DriverClassname", driver);
        attrs.put("ResType", resType);
    }

    static {
        resTypeList.add("");
        resTypeList.add(DATA_SOURCE);
        resTypeList.add(XADATA_SOURCE);
        resTypeList.add(CCDATA_SOURCE);
        resTypeList.add(DRIVER);
        dbVendorList.add("");
        dbVendorList.add(JAVADB);
        dbVendorList.add(ORACLE);
        dbVendorList.add(DERBY);
        dbVendorList.add(SYBASE);
        dbVendorList.add(DB2);
        dbVendorList.add(POINTBASE);
        dbVendorList.add(POSTGRESQL);
        dbVendorList.add(INFORMIX);
        dbVendorList.add(CLOUDSCAPE);
        dbVendorList.add(MSSQL);
        dbVendorList.add(MYSQL);
    }
}

