/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.util;

import com.sun.messaging.jmq.util.log.Logger;
import com.sun.messaging.jmq.util.selector.Selector;
import com.sun.messaging.jmq.util.selector.SelectorFormatException;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;

public abstract class RuntimeFaultInjection {
    private Logger logger = null;
    private java.util.logging.Logger jlogger = null;
    private Set injections = Collections.synchronizedSet(new HashSet());
    private Map injectionSelectors = Collections.synchronizedMap(new HashMap());
    private Map injectionProps = Collections.synchronizedMap(new HashMap());
    private String shutdownMsg = "SHUTING DOWN BECAUSE OF FAULT ";
    private String haltMsg = "HALT BECAUSE OF FAULT ";
    public boolean FAULT_INJECTION = false;

    public void setProcessName(String string) {
        this.shutdownMsg = "SHUTING DOWN " + string + " BECAUSE OF" + " FAULT ";
        this.haltMsg = "HALT " + string + " BECAUSE OF" + " FAULT ";
    }

    protected void setLogger(Object object) {
        if (object instanceof Logger) {
            this.logger = (Logger)object;
        } else if (object instanceof java.util.logging.Logger) {
            this.jlogger = (java.util.logging.Logger)object;
        }
    }

    public void setFault(String string, String string2) throws SelectorFormatException {
        this.setFault(string, string2, null);
    }

    public void setFault(String string, String string2, Map map) throws SelectorFormatException {
        this.logInfo("Setting Fault " + string + "[ selector=" + string2 + "], [props=" + map + "]");
        this.injections.add(string);
        if (string2 != null && string2.length() != 0) {
            Selector selector = Selector.compile(string2);
            this.injectionSelectors.put(string, selector);
        }
        if (map != null) {
            this.injectionProps.put(string, map);
        }
    }

    public void unsetFault(String string) {
        this.logInfo("Removing Fault " + string);
        this.injections.remove(string);
        this.injectionSelectors.remove(string);
        this.injectionProps.remove(string);
    }

    public void setFaultInjection(boolean bl) {
        if (this.FAULT_INJECTION != bl) {
            if (bl) {
                this.logInfo("Turning on Fault Injection");
            } else {
                this.logInfo("Turning off Fault Injection");
            }
            this.FAULT_INJECTION = bl;
        }
    }

    private void logInjection(String string, Selector selector) {
        String string2 = "Fault Injection: triggered " + string;
        if (selector != null) {
            string2 = string2 + " selector [ " + selector.toString() + "]";
        }
        FaultInjectionException faultInjectionException = new FaultInjectionException();
        faultInjectionException.fillInStackTrace();
        this.logInfo(string2, faultInjectionException);
    }

    private Map checkFaultGetProps(String string, Map map) {
        if (!this.FAULT_INJECTION) {
            return null;
        }
        boolean bl = this.checkFault(string, map);
        if (!bl) {
            return null;
        }
        HashMap hashMap = (HashMap)this.injectionProps.get(string);
        if (hashMap == null) {
            hashMap = new HashMap();
        }
        return hashMap;
    }

    public boolean checkFault(String string, Map map) {
        return this.checkFault(string, map, false);
    }

    private boolean checkFault(String string, Map map, boolean bl) {
        if (!this.FAULT_INJECTION) {
            return false;
        }
        if (this.injections.contains(string)) {
            Selector selector = (Selector)this.injectionSelectors.get(string);
            if (selector == null) {
                this.logInjection(string, null);
                if (bl) {
                    this.injections.remove(string);
                }
                return true;
            }
            try {
                boolean bl2 = selector.match(map, null);
                if (bl2) {
                    this.logInjection(string, selector);
                    if (bl) {
                        this.injections.remove(string);
                    }
                    return true;
                }
                return false;
            }
            catch (Exception exception) {
                this.logWarn("Unable to apply fault ", exception);
                return false;
            }
        }
        return false;
    }

    public void checkFaultAndThrowIOException(String string, Map map) throws IOException {
        if (!this.FAULT_INJECTION) {
            return;
        }
        if (this.checkFault(string, map)) {
            IOException iOException = new IOException("Fault Insertion: " + string);
            throw iOException;
        }
    }

    public void checkFaultAndThrowException(String string, Map map, String string2) throws Exception {
        this.checkFaultAndThrowException(string, map, string2, false);
    }

    public void checkFaultAndThrowException(String string, Map map, String string2, boolean bl) throws Exception {
        if (!this.FAULT_INJECTION) {
            return;
        }
        if (this.checkFault(string, map, bl)) {
            Class<?> clazz = Class.forName(string2);
            Class[] classArray = new Class[]{String.class};
            Constructor<?> constructor = clazz.getConstructor(classArray);
            Object[] objectArray = new Object[]{new String("Fault Injection: " + string)};
            Exception exception = (Exception)constructor.newInstance(objectArray);
            throw exception;
        }
    }

    public void checkFaultAndThrowError(String string, Map map) throws Error {
        if (!this.FAULT_INJECTION) {
            return;
        }
        if (this.checkFault(string, map)) {
            Error error = new Error("Fault Insertion: " + string);
            throw error;
        }
    }

    public void checkFaultAndExit(String string, Map map, int n, boolean bl) {
        if (!this.FAULT_INJECTION) {
            return;
        }
        if (this.checkFault(string, map)) {
            if (bl) {
                this.logInfo(this.shutdownMsg + string);
                this.exit(n);
            } else {
                this.logInfo(this.haltMsg + string);
                Runtime.getRuntime().halt(n);
            }
        }
    }

    protected abstract void exit(int var1);

    protected abstract String sleepIntervalPropertyName();

    protected abstract int sleepIntervalDefault();

    public void checkFaultAndSleep(String string, Map map) {
        if (!this.FAULT_INJECTION) {
            return;
        }
        Map map2 = this.checkFaultGetProps(string, map);
        if (map2 == null) {
            return;
        }
        String string2 = (String)map2.get(this.sleepIntervalPropertyName());
        int n = this.sleepIntervalDefault();
        if (string2 != null) {
            try {
                n = Integer.valueOf(string2);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (n <= 0) {
            n = this.sleepIntervalDefault();
        }
        this.logInfo("BEFORE SLEEP " + n + "(seconds) BECAUSE OF FAULT " + string);
        try {
            Thread.sleep(n);
        }
        catch (Exception exception) {
            this.logInfo("SLEEP " + n + "(seconds) FAULT (" + string + ") interrupted: " + exception.getMessage());
        }
        this.logInfo("AFTER SLEEP " + n + "(seconds) BECAUSE OF FAULT " + string);
    }

    private void logInfo(String string) {
        this.logInfo(string, null);
    }

    protected void logInfo(String string, Throwable throwable) {
        if (this.logger != null) {
            if (throwable == null) {
                this.logger.log(8, string);
            } else {
                this.logger.logStack(8, string, throwable);
            }
        } else if (this.jlogger != null) {
            if (throwable == null) {
                this.jlogger.log(Level.INFO, string);
            } else {
                this.jlogger.log(Level.INFO, string, throwable);
            }
        }
    }

    protected void logWarn(String string, Throwable throwable) {
        if (this.logger != null) {
            if (throwable == null) {
                this.logger.log(16, string);
            } else {
                this.logger.log(16, string, throwable);
            }
        } else if (this.jlogger != null) {
            if (throwable == null) {
                this.jlogger.log(Level.WARNING, string);
            } else {
                this.jlogger.log(Level.WARNING, string, throwable);
            }
        }
    }

    class FaultInjectionException
    extends Exception {
        FaultInjectionException() {
        }

        public String toString() {
            return "FaultInjectionTrace";
        }
    }
}

