/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.cli.optional.commands;

import com.sun.enterprise.admin.cli.CLICommand;
import com.sun.enterprise.admin.cli.Environment;
import com.sun.enterprise.admin.cli.ProgramOptions;
import com.sun.enterprise.admin.servermgmt.DomainConfig;
import com.sun.enterprise.admin.servermgmt.pe.PEDomainsManager;
import com.sun.enterprise.cli.framework.CommandException;
import com.sun.enterprise.cli.framework.CommandValidationException;
import com.sun.enterprise.universal.i18n.LocalStringsImpl;
import java.util.Collections;
import java.util.LinkedHashSet;

public final class DeleteDomainCommand
extends CLICommand {
    private static final String DOMAINDIR = "domaindir";
    private static final LocalStringsImpl strings = new LocalStringsImpl(DeleteDomainCommand.class);

    public DeleteDomainCommand(String name, ProgramOptions programOpts, Environment env) {
        super(name, programOpts, env);
    }

    protected void prepare() throws CommandException, CommandValidationException {
        LinkedHashSet opts = new LinkedHashSet();
        DeleteDomainCommand.addOption(opts, (String)DOMAINDIR, (char)'\u0000', (String)"STRING", (boolean)false, null);
        DeleteDomainCommand.addOption(opts, (String)"terse", (char)'\u0000', (String)"BOOLEAN", (boolean)false, (String)"false");
        DeleteDomainCommand.addOption(opts, (String)"echo", (char)'\u0000', (String)"BOOLEAN", (boolean)false, (String)"false");
        DeleteDomainCommand.addOption(opts, (String)"help", (char)'?', (String)"BOOLEAN", (boolean)false, (String)"false");
        this.commandOpts = Collections.unmodifiableSet(opts);
        this.operandName = "domain_name";
        this.operandType = "STRING";
        this.operandMin = 1;
        this.operandMax = 1;
    }

    protected void validate() throws CommandException, CommandValidationException {
        super.validate();
        if (this.options.containsKey("echo")) {
            this.programOpts.setEcho(this.getBooleanOption("echo"));
        }
        if (this.options.containsKey("terse")) {
            this.programOpts.setTerse(this.getBooleanOption("terse"));
        }
    }

    protected int executeCommand() throws CommandException, CommandValidationException {
        String domainName = null;
        try {
            domainName = (String)this.operands.get(0);
            DomainConfig domainConfig = new DomainConfig(domainName, this.getDomainsRoot());
            PEDomainsManager manager = new PEDomainsManager();
            manager.deleteDomain(domainConfig);
            this.deleteLoginInfo();
        }
        catch (Exception e) {
            logger.printDetailMessage(e.getLocalizedMessage());
            throw new CommandException(strings.get("CouldNotDeleteDomain", new Object[]{domainName}));
        }
        logger.printDetailMessage(strings.get("DomainDeleted", new Object[]{domainName}));
        return 0;
    }

    protected String getDomainsRoot() throws CommandException {
        String domainDir = this.getOption(DOMAINDIR);
        if (domainDir == null) {
            domainDir = this.getSystemProperty("com.sun.aas.domainsRoot");
        }
        if (domainDir == null) {
            throw new CommandException(strings.get("InvalidDomainPath", new Object[]{domainDir}));
        }
        return domainDir;
    }

    private void deleteLoginInfo() throws CommandValidationException {
    }
}

