/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xml.internal.security.c14n.implementations;

import com.sun.org.apache.xml.internal.security.c14n.CanonicalizationException;
import com.sun.org.apache.xml.internal.security.c14n.helper.C14nHelper;
import com.sun.org.apache.xml.internal.security.c14n.implementations.CanonicalizerBase;
import com.sun.org.apache.xml.internal.security.c14n.implementations.NameSpaceSymbTable;
import com.sun.org.apache.xml.internal.security.signature.XMLSignatureInput;
import com.sun.org.apache.xml.internal.security.utils.XMLUtils;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public abstract class Canonicalizer11
extends CanonicalizerBase {
    boolean firstCall = true;
    final SortedSet result = new TreeSet(COMPARE);
    static final String XMLNS_URI = "http://www.w3.org/2000/xmlns/";
    static final String XML_LANG_URI = "http://www.w3.org/XML/1998/namespace";
    static Logger log = Logger.getLogger(Canonicalizer11.class.getName());
    XmlAttrStack xmlattrStack = new XmlAttrStack();

    public Canonicalizer11(boolean bl) {
        super(bl);
    }

    Iterator handleAttributesSubtree(Element element, NameSpaceSymbTable nameSpaceSymbTable) throws CanonicalizationException {
        if (!element.hasAttributes() && !this.firstCall) {
            return null;
        }
        SortedSet sortedSet = this.result;
        sortedSet.clear();
        NamedNodeMap namedNodeMap = element.getAttributes();
        int n = namedNodeMap.getLength();
        for (int i = 0; i < n; ++i) {
            Node node;
            Attr attr = (Attr)namedNodeMap.item(i);
            String string2 = attr.getNamespaceURI();
            if (XMLNS_URI != string2) {
                sortedSet.add(attr);
                continue;
            }
            String string3 = attr.getLocalName();
            String string4 = attr.getValue();
            if ("xml".equals(string3) && XML_LANG_URI.equals(string4) || (node = nameSpaceSymbTable.addMappingAndRender(string3, string4, attr)) == null) continue;
            sortedSet.add(node);
            if (!C14nHelper.namespaceIsRelative(attr)) continue;
            Object[] objectArray = new Object[]{element.getTagName(), string3, attr.getNodeValue()};
            throw new CanonicalizationException("c14n.Canonicalizer.RelativeNamespace", objectArray);
        }
        if (this.firstCall) {
            nameSpaceSymbTable.getUnrenderedNodes(sortedSet);
            this.xmlattrStack.getXmlnsAttr(sortedSet);
            this.firstCall = false;
        }
        return sortedSet.iterator();
    }

    Iterator handleAttributes(Element element, NameSpaceSymbTable nameSpaceSymbTable) throws CanonicalizationException {
        Node node;
        this.xmlattrStack.push(nameSpaceSymbTable.getLevel());
        boolean bl = this.isVisibleDO(element, nameSpaceSymbTable.getLevel()) == 1;
        NamedNodeMap namedNodeMap = null;
        int n = 0;
        if (element.hasAttributes()) {
            namedNodeMap = element.getAttributes();
            n = namedNodeMap.getLength();
        }
        SortedSet sortedSet = this.result;
        sortedSet.clear();
        for (int i = 0; i < n; ++i) {
            node = (Attr)namedNodeMap.item(i);
            String string2 = node.getNamespaceURI();
            if (XMLNS_URI != string2) {
                if (XML_LANG_URI == string2) {
                    if (node.getLocalName().equals("id")) {
                        if (!bl) continue;
                        sortedSet.add(node);
                        continue;
                    }
                    this.xmlattrStack.addXmlnsAttr((Attr)node);
                    continue;
                }
                if (!bl) continue;
                sortedSet.add(node);
                continue;
            }
            String string3 = node.getLocalName();
            String string4 = node.getValue();
            if ("xml".equals(string3) && XML_LANG_URI.equals(string4)) continue;
            if (this.isVisible(node)) {
                Node node2;
                if (!bl && nameSpaceSymbTable.removeMappingIfRender(string3) || (node2 = nameSpaceSymbTable.addMappingAndRender(string3, string4, (Attr)node)) == null) continue;
                sortedSet.add(node2);
                if (!C14nHelper.namespaceIsRelative((Attr)node)) continue;
                Object[] objectArray = new Object[]{element.getTagName(), string3, node.getNodeValue()};
                throw new CanonicalizationException("c14n.Canonicalizer.RelativeNamespace", objectArray);
            }
            if (bl && string3 != "xmlns") {
                nameSpaceSymbTable.removeMapping(string3);
                continue;
            }
            nameSpaceSymbTable.addMapping(string3, string4, (Attr)node);
        }
        if (bl) {
            Attr attr = element.getAttributeNodeNS(XMLNS_URI, "xmlns");
            node = null;
            if (attr == null) {
                node = nameSpaceSymbTable.getMapping("xmlns");
            } else if (!this.isVisible(attr)) {
                node = nameSpaceSymbTable.addMappingAndRender("xmlns", "", nullNode);
            }
            if (node != null) {
                sortedSet.add(node);
            }
            this.xmlattrStack.getXmlnsAttr(sortedSet);
            nameSpaceSymbTable.getUnrenderedNodes(sortedSet);
        }
        return sortedSet.iterator();
    }

    public byte[] engineCanonicalizeXPathNodeSet(Set set, String string2) throws CanonicalizationException {
        throw new CanonicalizationException("c14n.Canonicalizer.UnsupportedOperation");
    }

    public byte[] engineCanonicalizeSubTree(Node node, String string2) throws CanonicalizationException {
        throw new CanonicalizationException("c14n.Canonicalizer.UnsupportedOperation");
    }

    void circumventBugIfNeeded(XMLSignatureInput xMLSignatureInput) throws CanonicalizationException, ParserConfigurationException, IOException, SAXException {
        if (!xMLSignatureInput.isNeedsToBeExpanded()) {
            return;
        }
        Document document = null;
        document = xMLSignatureInput.getSubNode() != null ? XMLUtils.getOwnerDocument(xMLSignatureInput.getSubNode()) : XMLUtils.getOwnerDocument(xMLSignatureInput.getNodeSet());
        XMLUtils.circumventBug2650(document);
    }

    void handleParent(Element element, NameSpaceSymbTable nameSpaceSymbTable) {
        if (!element.hasAttributes()) {
            return;
        }
        this.xmlattrStack.push(-1);
        NamedNodeMap namedNodeMap = element.getAttributes();
        int n = namedNodeMap.getLength();
        for (int i = 0; i < n; ++i) {
            Attr attr = (Attr)namedNodeMap.item(i);
            if (XMLNS_URI != attr.getNamespaceURI()) {
                if (XML_LANG_URI != attr.getNamespaceURI()) continue;
                this.xmlattrStack.addXmlnsAttr(attr);
                continue;
            }
            String string2 = attr.getLocalName();
            String string3 = attr.getNodeValue();
            if ("xml".equals(string2) && XML_LANG_URI.equals(string3)) continue;
            nameSpaceSymbTable.addMapping(string2, string3, attr);
        }
    }

    private static String joinURI(String string2, String string3) throws URISyntaxException {
        String string4;
        String string5;
        String string6;
        String string7;
        URI uRI;
        String string8 = null;
        String string9 = null;
        String string10 = "";
        String string11 = null;
        String string12 = null;
        if (string2 != null) {
            if (string2.endsWith("..")) {
                string2 = string2 + "/";
            }
            uRI = new URI(string2);
            string8 = uRI.getScheme();
            string9 = uRI.getAuthority();
            string10 = uRI.getPath();
            string11 = uRI.getQuery();
            string12 = uRI.getFragment();
        }
        uRI = new URI(string3);
        String string13 = uRI.getScheme();
        String string14 = uRI.getAuthority();
        String string15 = uRI.getPath();
        String string16 = uRI.getQuery();
        String string17 = null;
        if (string13 != null && string13.equals(string8)) {
            string13 = null;
        }
        if (string13 != null) {
            string7 = string13;
            string6 = string14;
            string5 = Canonicalizer11.removeDotSegments(string15);
            string4 = string16;
        } else {
            if (string14 != null) {
                string6 = string14;
                string5 = Canonicalizer11.removeDotSegments(string15);
                string4 = string16;
            } else {
                if (string15.length() == 0) {
                    string5 = string10;
                    string4 = string16 != null ? string16 : string11;
                } else {
                    if (string15.startsWith("/")) {
                        string5 = Canonicalizer11.removeDotSegments(string15);
                    } else {
                        int n;
                        string5 = string9 != null && string10.length() == 0 ? "/" + string15 : ((n = string10.lastIndexOf(47)) == -1 ? string15 : string10.substring(0, n + 1) + string15);
                        string5 = Canonicalizer11.removeDotSegments(string5);
                    }
                    string4 = string16;
                }
                string6 = string9;
            }
            string7 = string8;
        }
        String string18 = string17;
        return new URI(string7, string6, string5, string4, string18).toString();
    }

    private static String removeDotSegments(String string2) {
        log.log(Level.FINE, "STEP   OUTPUT BUFFER\t\tINPUT BUFFER");
        String string3 = string2;
        while (string3.indexOf("//") > -1) {
            string3 = string3.replaceAll("//", "/");
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (string3.charAt(0) == '/') {
            stringBuffer.append("/");
            string3 = string3.substring(1);
        }
        Canonicalizer11.printStep("1 ", stringBuffer.toString(), string3);
        while (string3.length() != 0) {
            String string4;
            int n;
            if (string3.startsWith("./")) {
                string3 = string3.substring(2);
                Canonicalizer11.printStep("2A", stringBuffer.toString(), string3);
                continue;
            }
            if (string3.startsWith("../")) {
                string3 = string3.substring(3);
                if (!stringBuffer.toString().equals("/")) {
                    stringBuffer.append("../");
                }
                Canonicalizer11.printStep("2A", stringBuffer.toString(), string3);
                continue;
            }
            if (string3.startsWith("/./")) {
                string3 = string3.substring(2);
                Canonicalizer11.printStep("2B", stringBuffer.toString(), string3);
                continue;
            }
            if (string3.equals("/.")) {
                string3 = string3.replaceFirst("/.", "/");
                Canonicalizer11.printStep("2B", stringBuffer.toString(), string3);
                continue;
            }
            if (string3.startsWith("/../")) {
                string3 = string3.substring(3);
                if (stringBuffer.length() == 0) {
                    stringBuffer.append("/");
                } else if (stringBuffer.toString().endsWith("../")) {
                    stringBuffer.append("..");
                } else if (stringBuffer.toString().endsWith("..")) {
                    stringBuffer.append("/..");
                } else {
                    n = stringBuffer.lastIndexOf("/");
                    if (n == -1) {
                        stringBuffer = new StringBuffer();
                        if (string3.charAt(0) == '/') {
                            string3 = string3.substring(1);
                        }
                    } else {
                        stringBuffer = stringBuffer.delete(n, stringBuffer.length());
                    }
                }
                Canonicalizer11.printStep("2C", stringBuffer.toString(), string3);
                continue;
            }
            if (string3.equals("/..")) {
                string3 = string3.replaceFirst("/..", "/");
                if (stringBuffer.length() == 0) {
                    stringBuffer.append("/");
                } else if (stringBuffer.toString().endsWith("../")) {
                    stringBuffer.append("..");
                } else if (stringBuffer.toString().endsWith("..")) {
                    stringBuffer.append("/..");
                } else {
                    n = stringBuffer.lastIndexOf("/");
                    if (n == -1) {
                        stringBuffer = new StringBuffer();
                        if (string3.charAt(0) == '/') {
                            string3 = string3.substring(1);
                        }
                    } else {
                        stringBuffer = stringBuffer.delete(n, stringBuffer.length());
                    }
                }
                Canonicalizer11.printStep("2C", stringBuffer.toString(), string3);
                continue;
            }
            if (string3.equals(".")) {
                string3 = "";
                Canonicalizer11.printStep("2D", stringBuffer.toString(), string3);
                continue;
            }
            if (string3.equals("..")) {
                if (!stringBuffer.toString().equals("/")) {
                    stringBuffer.append("..");
                }
                string3 = "";
                Canonicalizer11.printStep("2D", stringBuffer.toString(), string3);
                continue;
            }
            n = -1;
            int n2 = string3.indexOf(47);
            if (n2 == 0) {
                n = string3.indexOf(47, 1);
            } else {
                n = n2;
                n2 = 0;
            }
            if (n == -1) {
                string4 = string3.substring(n2);
                string3 = "";
            } else {
                string4 = string3.substring(n2, n);
                string3 = string3.substring(n);
            }
            stringBuffer.append(string4);
            Canonicalizer11.printStep("2E", stringBuffer.toString(), string3);
        }
        if (stringBuffer.toString().endsWith("..")) {
            stringBuffer.append("/");
            Canonicalizer11.printStep("3 ", stringBuffer.toString(), string3);
        }
        return stringBuffer.toString();
    }

    private static void printStep(String string2, String string3, String string4) {
        log.log(Level.FINE, " " + string2 + ":   " + string3);
        if (string3.length() == 0) {
            log.log(Level.FINE, "\t\t\t\t" + string4);
        } else {
            log.log(Level.FINE, "\t\t\t" + string4);
        }
    }

    static class XmlAttrStack {
        int currentLevel = 0;
        int lastlevel = 0;
        XmlsStackElement cur;
        List levels = new ArrayList();

        XmlAttrStack() {
        }

        void push(int n) {
            this.currentLevel = n;
            if (this.currentLevel == -1) {
                return;
            }
            this.cur = null;
            while (this.lastlevel >= this.currentLevel) {
                this.levels.remove(this.levels.size() - 1);
                if (this.levels.size() == 0) {
                    this.lastlevel = 0;
                    return;
                }
                this.lastlevel = ((XmlsStackElement)this.levels.get((int)(this.levels.size() - 1))).level;
            }
        }

        void addXmlnsAttr(Attr attr) {
            if (this.cur == null) {
                this.cur = new XmlsStackElement();
                this.cur.level = this.currentLevel;
                this.levels.add(this.cur);
                this.lastlevel = this.currentLevel;
            }
            this.cur.nodes.add(attr);
        }

        void getXmlnsAttr(Collection collection) {
            Object object;
            Iterator iterator;
            if (this.cur == null) {
                this.cur = new XmlsStackElement();
                this.cur.level = this.currentLevel;
                this.lastlevel = this.currentLevel;
                this.levels.add(this.cur);
            }
            int n = this.levels.size() - 2;
            boolean bl = false;
            XmlsStackElement xmlsStackElement = null;
            if (n == -1) {
                bl = true;
            } else {
                xmlsStackElement = (XmlsStackElement)this.levels.get(n);
                if (xmlsStackElement.rendered && xmlsStackElement.level + 1 == this.currentLevel) {
                    bl = true;
                }
            }
            if (bl) {
                collection.addAll(this.cur.nodes);
                this.cur.rendered = true;
                return;
            }
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            ArrayList<Object> arrayList = new ArrayList<Object>();
            boolean bl2 = true;
            while (n >= 0) {
                xmlsStackElement = (XmlsStackElement)this.levels.get(n);
                if (xmlsStackElement.rendered) {
                    bl2 = false;
                }
                iterator = xmlsStackElement.nodes.iterator();
                while (iterator.hasNext() && bl2) {
                    object = (Attr)iterator.next();
                    if (object.getLocalName().equals("base")) {
                        if (xmlsStackElement.rendered) continue;
                        arrayList.add(object);
                        continue;
                    }
                    if (hashMap.containsKey(object.getName())) continue;
                    hashMap.put(object.getName(), object);
                }
                --n;
            }
            if (!arrayList.isEmpty()) {
                Attr attr;
                iterator = this.cur.nodes.iterator();
                object = null;
                Attr attr2 = null;
                while (iterator.hasNext()) {
                    attr = (Attr)iterator.next();
                    if (!attr.getLocalName().equals("base")) continue;
                    object = attr.getValue();
                    attr2 = attr;
                    break;
                }
                iterator = arrayList.iterator();
                while (iterator.hasNext()) {
                    attr = (Attr)iterator.next();
                    if (object == null) {
                        object = attr.getValue();
                        attr2 = attr;
                        continue;
                    }
                    try {
                        object = Canonicalizer11.joinURI(attr.getValue(), (String)object);
                    }
                    catch (URISyntaxException uRISyntaxException) {
                        uRISyntaxException.printStackTrace();
                    }
                }
                if (object != null && ((String)object).length() != 0) {
                    attr2.setValue((String)object);
                    collection.add(attr2);
                }
            }
            this.cur.rendered = true;
            collection.addAll(hashMap.values());
        }

        static class XmlsStackElement {
            int level;
            boolean rendered = false;
            List nodes = new ArrayList();

            XmlsStackElement() {
            }
        }
    }
}

