/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.rx.rm.runtime;

import com.sun.istack.NotNull;
import com.sun.istack.Nullable;
import com.sun.istack.logging.Logger;
import com.sun.xml.ws.rx.RxRuntimeException;
import com.sun.xml.ws.rx.rm.protocol.AcknowledgementData;
import com.sun.xml.ws.rx.rm.runtime.ApplicationMessage;
import com.sun.xml.ws.rx.rm.runtime.MessageHandler;
import com.sun.xml.ws.rx.rm.runtime.sequence.DuplicateMessageRegistrationException;
import com.sun.xml.ws.rx.rm.runtime.sequence.Sequence;
import com.sun.xml.ws.rx.rm.runtime.sequence.SequenceManager;
import com.sun.xml.ws.rx.rm.runtime.sequence.UnknownSequenceException;
import java.util.List;
import java.util.logging.Level;

class DestinationMessageHandler
implements MessageHandler {
    private static final Logger LOGGER = Logger.getLogger(DestinationMessageHandler.class);
    private volatile SequenceManager sequenceManager;

    DestinationMessageHandler(@Nullable SequenceManager sequenceManager) {
        this.sequenceManager = sequenceManager;
    }

    void setSequenceManager(SequenceManager sequenceManager) {
        this.sequenceManager = sequenceManager;
    }

    public void registerMessage(@NotNull ApplicationMessage inMessage) throws DuplicateMessageRegistrationException, UnknownSequenceException {
        assert (this.sequenceManager != null);
        assert (inMessage != null);
        Sequence inboundSequence = this.sequenceManager.getSequence(inMessage.getSequenceId());
        inboundSequence.registerMessage(inMessage, true);
        inboundSequence.setAckRequestedFlag();
    }

    public void processAcknowledgements(@Nullable AcknowledgementData acknowledgementData) throws UnknownSequenceException {
        Sequence sequence;
        List<Sequence.AckRange> acknowledgedRanges;
        assert (this.sequenceManager != null);
        if (acknowledgementData == null) {
            return;
        }
        if (acknowledgementData.getAcknowledgedSequenceId() != null && !(acknowledgedRanges = acknowledgementData.getAcknowledgedRanges()).isEmpty() && !(sequence = this.sequenceManager.getSequence(acknowledgementData.getAcknowledgedSequenceId())).isClosed()) {
            sequence.acknowledgeMessageNumbers(acknowledgedRanges);
        }
        if (acknowledgementData.getAckReqestedSequenceId() != null) {
            Sequence inboundSequence = this.sequenceManager.getSequence(acknowledgementData.getAckReqestedSequenceId());
            inboundSequence.setAckRequestedFlag();
        }
    }

    public AcknowledgementData getAcknowledgementData(String inboundSequenceId) throws UnknownSequenceException {
        Sequence outboundSequence;
        assert (this.sequenceManager != null);
        AcknowledgementData.Builder ackDataBuilder = AcknowledgementData.getBuilder();
        Sequence inboundSequence = this.sequenceManager.getSequence(inboundSequenceId);
        if (inboundSequence.isAckRequested()) {
            ackDataBuilder.acknowledgements(inboundSequence.getId(), inboundSequence.getAcknowledgedMessageNumbers());
            inboundSequence.clearAckRequestedFlag();
        }
        if ((outboundSequence = this.sequenceManager.getBoundSequence(inboundSequenceId)) != null && outboundSequence.hasUnacknowledgedMessages()) {
            ackDataBuilder.ackReqestedSequenceId(outboundSequence.getId());
            outboundSequence.updateLastAcknowledgementRequestTime();
        }
        AcknowledgementData acknowledgementData = ackDataBuilder.build();
        return acknowledgementData;
    }

    public void acknowledgeApplicationLayerDelivery(ApplicationMessage inMessage) throws UnknownSequenceException {
        assert (this.sequenceManager != null);
        this.sequenceManager.getSequence(inMessage.getSequenceId()).acknowledgeMessageNumber(inMessage.getMessageNumber());
    }

    public void putToDeliveryQueue(ApplicationMessage message) throws RxRuntimeException, UnknownSequenceException {
        assert (this.sequenceManager != null);
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.finer(String.format("Putting a message with number [ %d ] to the delivery queue of a sequence [ %s ]", message.getMessageNumber(), message.getSequenceId()));
        }
        this.sequenceManager.getSequence(message.getSequenceId()).getDeliveryQueue().put(message);
    }
}

