/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.fileupload;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.rmi.server.UID;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.servlet.http.Part;
import org.apache.catalina.fileupload.DeferredFileOutputStream;
import org.apache.catalina.fileupload.Multipart;
import org.apache.catalina.fileupload.ParameterParser;
import org.apache.catalina.fileupload.PartHeaders;
import org.apache.catalina.fileupload.Streams;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class PartItem
implements Serializable,
Part {
    private static final long serialVersionUID = 2237570099615271025L;
    public static final String DEFAULT_CHARSET = "ISO-8859-1";
    private static final String UID = new UID().toString().replace(':', '_').replace('-', '_');
    private static int counter = 0;
    private String fieldName;
    private String contentType;
    private boolean isFormField;
    private String fileName;
    private long size = -1L;
    private int sizeThreshold;
    private File repository;
    private byte[] cachedContent;
    private transient DeferredFileOutputStream dfos;
    private transient File tempFile;
    private File dfosFile;
    private PartHeaders headers;
    private Multipart multipart;

    public PartItem(Multipart multipart, PartHeaders headers, String fieldName, String contentType, boolean isFormField, String fileName) {
        this.multipart = multipart;
        this.headers = headers;
        this.fieldName = fieldName;
        this.contentType = contentType;
        this.isFormField = isFormField;
        this.fileName = fileName;
        this.sizeThreshold = multipart.getFileSizeThreshold();
        this.repository = multipart.getRepository();
    }

    @Override
    public InputStream getInputStream() throws IOException {
        if (!this.isInMemory()) {
            return new FileInputStream(this.dfos.getFile());
        }
        if (this.cachedContent == null) {
            this.cachedContent = this.dfos.getData();
        }
        return new ByteArrayInputStream(this.cachedContent);
    }

    @Override
    public String getContentType() {
        return this.contentType;
    }

    public String getCharSet() {
        ParameterParser parser = new ParameterParser();
        parser.setLowerCaseNames(true);
        Map<String, String> params = parser.parse(this.getContentType(), ';');
        return params.get("charset");
    }

    public String getFileName() {
        return this.fileName;
    }

    public boolean isInMemory() {
        if (this.cachedContent != null) {
            return true;
        }
        return this.dfos.isInMemory();
    }

    @Override
    public long getSize() {
        if (this.size >= 0L) {
            return this.size;
        }
        if (this.cachedContent != null) {
            return this.cachedContent.length;
        }
        if (this.dfos.isInMemory()) {
            return this.dfos.getData().length;
        }
        return this.dfos.getFile().length();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public byte[] get() {
        if (this.isInMemory()) {
            if (this.cachedContent != null) return this.cachedContent;
            this.cachedContent = this.dfos.getData();
            return this.cachedContent;
        }
        byte[] fileData = new byte[(int)this.getSize()];
        FileInputStream fis = null;
        fis = new FileInputStream(this.dfos.getFile());
        fis.read(fileData);
        Object var5_3 = null;
        if (fis == null) return fileData;
        try {
            fis.close();
            return fileData;
        }
        catch (IOException e2) {}
        return fileData;
        {
            catch (IOException e) {
                fileData = null;
                Object var5_4 = null;
                if (fis == null) return fileData;
                try {
                    fis.close();
                    return fileData;
                }
                catch (IOException e2) {}
                return fileData;
            }
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (fis == null) throw throwable;
            try {
                fis.close();
                throw throwable;
            }
            catch (IOException e2) {
                // empty catch block
            }
            throw throwable;
        }
    }

    public String getString(String charset) throws UnsupportedEncodingException {
        return new String(this.get(), charset);
    }

    public String getString() {
        byte[] rawdata = this.get();
        String charset = this.getCharSet();
        if (charset == null) {
            charset = DEFAULT_CHARSET;
        }
        try {
            return new String(rawdata, charset);
        }
        catch (UnsupportedEncodingException e) {
            return new String(rawdata);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void write(File file) throws IOException {
        IOException e22;
        FilterOutputStream out;
        block12: {
            if (this.isInMemory()) {
                FileOutputStream fout = null;
                try {
                    fout = new FileOutputStream(file);
                    fout.write(this.get());
                    Object var4_4 = null;
                    if (fout == null) return;
                }
                catch (Throwable throwable) {
                    Object var4_5 = null;
                    if (fout == null) throw throwable;
                    fout.close();
                    throw throwable;
                }
                fout.close();
                return;
            }
            File outputFile = this.getStoreLocation();
            if (outputFile == null) throw new IOException("Cannot write uploaded file to disk!");
            this.size = outputFile.length();
            if (outputFile.renameTo(file)) return;
            BufferedInputStream in = null;
            out = null;
            try {
                in = new BufferedInputStream(new FileInputStream(outputFile));
                out = new BufferedOutputStream(new FileOutputStream(file));
                Streams.copy(in, out, false);
                Object var6_9 = null;
                if (in == null) break block12;
            }
            catch (Throwable throwable) {
                IOException e22;
                Object var6_10 = null;
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException e22) {
                        // empty catch block
                    }
                }
                if (out == null) throw throwable;
                try {
                    out.close();
                    throw throwable;
                }
                catch (IOException e22) {
                    // empty catch block
                }
                throw throwable;
            }
            try {
                in.close();
            }
            catch (IOException e22) {
                // empty catch block
            }
        }
        if (out == null) return;
        try {
            out.close();
            return;
        }
        catch (IOException e22) {}
    }

    @Override
    public void write(String file) throws IOException {
        this.write(new File(this.repository, file));
    }

    @Override
    public void delete() {
        this.cachedContent = null;
        File outputFile = this.getStoreLocation();
        if (outputFile != null && outputFile.exists()) {
            outputFile.delete();
        }
    }

    @Override
    public String getName() {
        return this.fieldName;
    }

    public void setName(String fieldName) {
        this.fieldName = fieldName;
    }

    public boolean isFormField() {
        return this.isFormField;
    }

    public void setFormField(boolean state) {
        this.isFormField = state;
    }

    public OutputStream getOutputStream() throws IOException {
        if (this.dfos == null) {
            File outputFile = this.getTempFile();
            this.dfos = new DeferredFileOutputStream(this.sizeThreshold, outputFile);
        }
        return this.dfos;
    }

    public File getStoreLocation() {
        return this.dfos == null ? null : this.dfos.getFile();
    }

    protected void finalize() {
        File outputFile = this.dfos.getFile();
        if (outputFile != null && outputFile.exists()) {
            outputFile.delete();
        }
    }

    protected File getTempFile() {
        if (this.tempFile == null) {
            File tempDir = this.repository;
            if (tempDir == null) {
                tempDir = new File(System.getProperty("java.io.tmpdir"));
            }
            String tempFileName = "upload_" + UID + "_" + PartItem.getUniqueId() + ".tmp";
            this.tempFile = new File(tempDir, tempFileName);
        }
        return this.tempFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getUniqueId() {
        int limit = 100000000;
        Class<PartItem> clazz = PartItem.class;
        synchronized (PartItem.class) {
            int current = counter++;
            // ** MonitorExit[var2_1] (shouldn't be in output)
            String id = Integer.toString(current);
            if (current < 100000000) {
                id = ("00000000" + id).substring(id.length());
            }
            return id;
        }
    }

    public String toString() {
        return "File name=" + this.getFileName() + ", StoreLocation=" + String.valueOf(this.getStoreLocation()) + ", size=" + this.getSize() + "bytes, " + "isFormField=" + this.isFormField() + ", FieldName=" + this.getName();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        if (this.dfos.isInMemory()) {
            this.cachedContent = this.get();
        } else {
            this.cachedContent = null;
            this.dfosFile = this.dfos.getFile();
        }
        out.defaultWriteObject();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        OutputStream output = this.getOutputStream();
        if (this.cachedContent != null) {
            output.write(this.cachedContent);
        } else {
            FileInputStream input = new FileInputStream(this.dfosFile);
            Streams.copy(input, output, false);
            this.dfosFile.delete();
            this.dfosFile = null;
        }
        output.close();
        this.cachedContent = null;
    }

    @Override
    public String getHeader(String name) {
        return this.headers.getHeader(name);
    }

    @Override
    public Collection<String> getHeaders(String name) {
        List<String> values = this.headers.getHeaders(name);
        if (values != Collections.EMPTY_LIST) {
            values = Collections.unmodifiableList(values);
        }
        return values;
    }

    @Override
    public Collection<String> getHeaderNames() {
        return this.headers.getHeaderNames();
    }
}

