/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webbeans.bootstrap;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.enterprise.inject.spi.Bean;
import org.jboss.webbeans.BeanManagerImpl;
import org.jboss.webbeans.bean.AbstractClassBean;
import org.jboss.webbeans.bean.DecoratorBean;
import org.jboss.webbeans.bean.DisposalMethodBean;
import org.jboss.webbeans.bean.NewBean;
import org.jboss.webbeans.bean.ProducerMethodBean;
import org.jboss.webbeans.bean.RIBean;
import org.jboss.webbeans.ejb.EjbDescriptorCache;
import org.jboss.webbeans.event.ObserverImpl;
import org.jboss.webbeans.introspector.WBAnnotated;
import org.jboss.webbeans.introspector.WBClass;
import org.jboss.webbeans.introspector.WBMethod;
import org.jboss.webbeans.resolution.ResolvableFactory;
import org.jboss.webbeans.resolution.TypeSafeBeanResolver;
import org.jboss.webbeans.resolution.TypeSafeResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeanDeployerEnvironment {
    private final Map<WBClass<?>, AbstractClassBean<?>> classBeanMap = new HashMap();
    private final Map<WBMethod<?>, ProducerMethodBean<?>> producerMethodBeanMap = new HashMap();
    private final Map<WBMethod<?>, DisposalMethodBean<?>> disposalMethodBeanMap = new HashMap();
    private final Set<RIBean<?>> beans;
    private final Set<ObserverImpl<?>> observers;
    private final List<DisposalMethodBean<?>> allDisposalBeans = new ArrayList();
    private final Set<DisposalMethodBean<?>> resolvedDisposalBeans = new HashSet();
    private final Set<DecoratorBean<?>> decorators;
    private final EjbDescriptorCache ejbDescriptors;
    private final TypeSafeResolver disposalMethodResolver;
    private final BeanManagerImpl manager;

    public BeanDeployerEnvironment(EjbDescriptorCache ejbDescriptors, BeanManagerImpl manager) {
        this.beans = new HashSet();
        this.decorators = new HashSet();
        this.observers = new HashSet();
        this.ejbDescriptors = ejbDescriptors;
        this.disposalMethodResolver = new TypeSafeBeanResolver(manager, this.allDisposalBeans);
        this.manager = manager;
    }

    public ProducerMethodBean<?> getProducerMethod(WBMethod<?> method) {
        if (!this.producerMethodBeanMap.containsKey(method)) {
            return null;
        }
        ProducerMethodBean<?> bean = this.producerMethodBeanMap.get(method);
        bean.initialize(this);
        return bean;
    }

    public DisposalMethodBean<?> getDisposalMethod(WBMethod<?> method) {
        if (!this.producerMethodBeanMap.containsKey(method)) {
            return null;
        }
        DisposalMethodBean<?> bean = this.disposalMethodBeanMap.get(method);
        bean.initialize(this);
        return bean;
    }

    public AbstractClassBean<?> getClassBean(WBClass<?> clazz) {
        if (!this.classBeanMap.containsKey(clazz)) {
            return null;
        }
        AbstractClassBean<?> bean = this.classBeanMap.get(clazz);
        bean.initialize(this);
        return bean;
    }

    public void addBean(RIBean<?> value) {
        if (value instanceof AbstractClassBean && !(value instanceof NewBean)) {
            AbstractClassBean bean = (AbstractClassBean)value;
            this.classBeanMap.put((WBClass<?>)bean.getAnnotatedItem(), bean);
        } else if (value instanceof ProducerMethodBean) {
            ProducerMethodBean bean = (ProducerMethodBean)value;
            this.producerMethodBeanMap.put((WBMethod<?>)bean.getAnnotatedItem(), bean);
        } else if (value instanceof DisposalMethodBean) {
            DisposalMethodBean bean = (DisposalMethodBean)value;
            this.disposalMethodBeanMap.put((WBMethod<?>)bean.getAnnotatedItem(), bean);
        }
        this.beans.add(value);
        if (value instanceof DecoratorBean) {
            this.decorators.add((DecoratorBean)value);
        }
    }

    public Set<RIBean<?>> getBeans() {
        return Collections.unmodifiableSet(this.beans);
    }

    public Set<DecoratorBean<?>> getDecorators() {
        return Collections.unmodifiableSet(this.decorators);
    }

    public Set<ObserverImpl<?>> getObservers() {
        return this.observers;
    }

    public List<DisposalMethodBean<?>> getAllDisposalBeans() {
        return this.allDisposalBeans;
    }

    public void addDisposalBean(DisposalMethodBean<?> disposalBean) {
        this.allDisposalBeans.add(disposalBean);
    }

    public void addResolvedDisposalBean(DisposalMethodBean<?> disposalBean) {
        this.resolvedDisposalBeans.add(disposalBean);
    }

    public Set<DisposalMethodBean<?>> getResolvedDisposalBeans() {
        return this.resolvedDisposalBeans;
    }

    public EjbDescriptorCache getEjbDescriptors() {
        return this.ejbDescriptors;
    }

    public <T> Set<DisposalMethodBean<T>> resolveDisposalBeans(WBAnnotated<T, ?> annotatedItem) {
        Set beans = this.disposalMethodResolver.resolve(ResolvableFactory.of(annotatedItem));
        HashSet<DisposalMethodBean<T>> disposalBeans = new HashSet<DisposalMethodBean<T>>();
        for (Bean bean : beans) {
            if (!(bean instanceof DisposalMethodBean)) continue;
            disposalBeans.add((DisposalMethodBean)bean);
        }
        return disposalBeans;
    }
}

