/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.webbeans;

import java.io.IOException;
import java.util.Enumeration;
import org.glassfish.api.container.Sniffer;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.glassfish.deployment.common.DeploymentUtils;
import org.glassfish.internal.deployment.GenericSniffer;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Singleton;

@Service(name="webbeans")
@Scoped(value=Singleton.class)
public class WebBeansSniffer
extends GenericSniffer
implements Sniffer {
    private static final String[] containers = new String[]{"org.glassfish.webbeans.WebBeansContainer"};
    private static char SEPERATOR_CHAR = (char)47;
    private static final String WEB_INF = "WEB-INF";
    private static final String WEB_INF_LIB = "WEB-INF" + SEPERATOR_CHAR + "lib";
    private static final String WEB_INF_CLASSSES = "WEB-INF" + SEPERATOR_CHAR + "classes";
    private static final String WEB_INF_BEANS_XML = "WEB-INF" + SEPERATOR_CHAR + "beans.xml";
    private static final String META_INF_BEANS_XML = "META-INF" + SEPERATOR_CHAR + "beans.xml";
    private static final String JAR_SUFFIX = ".jar";

    public WebBeansSniffer() {
        super("webbeans", null, null);
    }

    public boolean handles(ReadableArchive location, ClassLoader loader) {
        boolean isWebBeansArchive = false;
        if (DeploymentUtils.isWebArchive((ReadableArchive)location) && !(isWebBeansArchive = this.isEntryPresent(location, WEB_INF_BEANS_XML)) && this.isEntryPresent(location, WEB_INF_LIB)) {
            Enumeration entries = location.entries(WEB_INF_LIB);
            while (entries.hasMoreElements() && !isWebBeansArchive) {
                String entryName = (String)entries.nextElement();
                if (!entryName.endsWith(JAR_SUFFIX) || entryName.indexOf(SEPERATOR_CHAR, WEB_INF_LIB.length() + 1) != -1) continue;
                try {
                    ReadableArchive jarInLib = location.getSubArchive(entryName);
                    isWebBeansArchive = this.isEntryPresent(jarInLib, META_INF_BEANS_XML);
                    jarInLib.close();
                }
                catch (IOException e) {}
            }
        }
        return isWebBeansArchive;
    }

    private boolean isEntryPresent(ReadableArchive location, String entry) {
        boolean entryPresent = false;
        try {
            entryPresent = location.exists(entry);
        }
        catch (IOException e) {
            // empty catch block
        }
        return entryPresent;
    }

    public String[] getContainersNames() {
        return containers;
    }
}

