/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.webservices;

import com.sun.enterprise.deployment.WebServiceEndpoint;
import com.sun.enterprise.deployment.runtime.common.MessageSecurityBindingDescriptor;
import com.sun.enterprise.security.SecurityContext;
import com.sun.enterprise.security.audit.AuditManager;
import com.sun.enterprise.security.jauth.AuthException;
import com.sun.enterprise.security.jmac.provider.ServerAuthConfig;
import com.sun.enterprise.security.web.integration.WebPrincipal;
import com.sun.logging.LogDomains;
import com.sun.web.security.RealmAdapter;
import java.security.Principal;
import java.security.cert.X509Certificate;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import org.apache.catalina.util.Base64;
import org.glassfish.internal.api.Globals;
import org.glassfish.webservices.Ejb2RuntimeEndpointInfo;
import org.glassfish.webservices.EjbRuntimeEndpointInfo;
import org.glassfish.webservices.SecurityService;
import org.glassfish.webservices.WebServiceContextImpl;
import org.glassfish.webservices.monitoring.AuthenticationListener;
import org.glassfish.webservices.monitoring.Endpoint;
import org.glassfish.webservices.monitoring.WebServiceEngineImpl;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Singleton;

@Service
@Scoped(value=Singleton.class)
public class SecurityServiceImpl
implements SecurityService {
    protected static final Logger _logger = LogDomains.getLogger(SecurityServiceImpl.class, (String)"javax.enterprise.system.core.security");
    private ServerAuthConfig serverAuthConfig = null;
    private static final Base64 base64Helper = new Base64();
    private static final String AUTHORIZATION_HEADER = "authorization";

    public void mergeSOAPMessageSecurityPolicies(MessageSecurityBindingDescriptor desc) {
        try {
            this.serverAuthConfig = ServerAuthConfig.getConfig("SOAP", desc, null);
        }
        catch (AuthException ae) {
            _logger.log(Level.SEVERE, "EJB Webservice security configuration Failure", ae);
        }
    }

    public boolean doSecurity(HttpServletRequest hreq, EjbRuntimeEndpointInfo epInfo, String realmName, WebServiceContextImpl context) {
        boolean authenticated = false;
        try {
            AuditManager auditManager;
            if (context != null) {
                context.setUserPrincipal(null);
            }
            WebServiceEndpoint endpoint = epInfo.getEndpoint();
            String method = hreq.getMethod();
            if (method.equals("GET") || !endpoint.hasAuthMethod()) {
                return true;
            }
            WebPrincipal webPrincipal = null;
            String endpointName = endpoint.getEndpointName();
            if (endpoint.hasBasicAuth()) {
                String rawAuthInfo = hreq.getHeader(AUTHORIZATION_HEADER);
                if (rawAuthInfo == null) {
                    this.sendAuthenticationEvents(false, hreq.getRequestURI(), null);
                    return false;
                }
                String[] usernamePassword = this.parseUsernameAndPassword(rawAuthInfo);
                if (usernamePassword != null) {
                    webPrincipal = new WebPrincipal(usernamePassword[0], usernamePassword[1], SecurityContext.init());
                } else {
                    _logger.log(Level.WARNING, "BASIC AUTH username/password http header parsing error for " + endpointName);
                }
            } else {
                X509Certificate[] certs = (X509Certificate[])hreq.getAttribute("javax.servlet.request.X509Certificate");
                if (certs == null || certs.length < 1) {
                    certs = (X509Certificate[])hreq.getAttribute("org.apache.coyote.request.X509Certificate");
                }
                if (certs != null) {
                    webPrincipal = new WebPrincipal(certs, SecurityContext.init());
                } else {
                    _logger.log(Level.WARNING, "CLIENT CERT authentication error for " + endpointName);
                }
            }
            if (webPrincipal == null) {
                this.sendAuthenticationEvents(false, hreq.getRequestURI(), null);
                return authenticated;
            }
            RealmAdapter ra = new RealmAdapter(realmName);
            authenticated = ra.authenticate(webPrincipal);
            if (!authenticated) {
                this.sendAuthenticationEvents(false, hreq.getRequestURI(), (Principal)webPrincipal);
                _logger.fine("authentication failed for " + endpointName);
            }
            this.sendAuthenticationEvents(true, hreq.getRequestURI(), (Principal)webPrincipal);
            if (epInfo instanceof Ejb2RuntimeEndpointInfo) {
                return authenticated;
            }
            epInfo.prepareInvocation(false);
            WebServiceContextImpl ctxt = (WebServiceContextImpl)epInfo.getWebServiceContext();
            ctxt.setUserPrincipal((Principal)webPrincipal);
            if (Globals.getDefaultHabitat() != null && (auditManager = (AuditManager)Globals.get(AuditManager.class)).isAuditOn()) {
                auditManager.ejbAsWebServiceInvocation(epInfo.getEndpoint().getEndpointName(), authenticated);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return authenticated;
    }

    private String[] parseUsernameAndPassword(String rawAuthInfo) {
        String[] usernamePassword = null;
        if (rawAuthInfo != null && rawAuthInfo.startsWith("Basic ")) {
            String authString = rawAuthInfo.substring(6).trim();
            String unencoded = new String(Base64.decode((byte[])authString.getBytes()));
            int colon = unencoded.indexOf(58);
            if (colon > 0) {
                usernamePassword = new String[]{unencoded.substring(0, colon).trim(), unencoded.substring(colon + 1).trim()};
            }
        }
        return usernamePassword;
    }

    private void sendAuthenticationEvents(boolean success, String url, Principal principal) {
        Endpoint endpoint = WebServiceEngineImpl.getInstance().getEndpoint(url);
        if (endpoint == null) {
            return;
        }
        for (AuthenticationListener listener : WebServiceEngineImpl.getInstance().getAuthListeners()) {
            if (success) {
                listener.authSucess(endpoint.getDescriptor().getBundleDescriptor(), endpoint, principal);
                continue;
            }
            listener.authFailure(endpoint.getDescriptor().getBundleDescriptor(), endpoint, principal);
        }
    }

    public void resetSecurityContext() {
        SecurityContext.setCurrent(null);
    }
}

