/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.ejb.deployment.annotation.handlers;

import com.sun.enterprise.deployment.EjbReferenceDescriptor;
import com.sun.enterprise.deployment.InjectionTarget;
import com.sun.enterprise.deployment.annotation.context.ResourceContainerContext;
import com.sun.enterprise.deployment.annotation.handlers.AbstractResourceHandler;
import com.sun.enterprise.deployment.types.EjbReference;
import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.logging.Level;
import javax.ejb.EJB;
import javax.ejb.EJBHome;
import javax.ejb.EJBLocalHome;
import javax.ejb.Local;
import javax.ejb.Remote;
import org.glassfish.apf.AnnotationInfo;
import org.glassfish.apf.AnnotationProcessorException;
import org.glassfish.apf.HandlerProcessingResult;
import org.jvnet.hk2.annotations.Service;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service
public class EJBHandler
extends AbstractResourceHandler {
    public Class<? extends Annotation> getAnnotationType() {
        return EJB.class;
    }

    protected HandlerProcessingResult processAnnotation(AnnotationInfo ainfo, ResourceContainerContext[] rcContexts) throws AnnotationProcessorException {
        EJB ejbAn = (EJB)ainfo.getAnnotation();
        return this.processEJB(ainfo, rcContexts, ejbAn);
    }

    protected HandlerProcessingResult processEJB(AnnotationInfo ainfo, ResourceContainerContext[] rcContexts, EJB ejbAn) throws AnnotationProcessorException {
        block7: {
            EjbReferenceDescriptor[] ejbRefs;
            block8: {
                block6: {
                    ejbRefs = null;
                    if (!ElementType.FIELD.equals((Object)ainfo.getElementType())) break block6;
                    Field f = (Field)ainfo.getAnnotatedElement();
                    String targetClassName = f.getDeclaringClass().getName();
                    String logicalName = ejbAn.name();
                    if (logicalName.equals("")) {
                        logicalName = targetClassName + "/" + f.getName();
                    }
                    Class beanInterface = ejbAn.beanInterface() == Object.class ? f.getType() : ejbAn.beanInterface();
                    InjectionTarget target = new InjectionTarget();
                    target.setClassName(targetClassName);
                    target.setFieldName(f.getName());
                    for (EjbReferenceDescriptor ejbRef : ejbRefs = this.getEjbReferenceDescriptors(logicalName, rcContexts)) {
                        ejbRef.addInjectionTarget(target);
                        if (ejbRef.getName().length() != 0) continue;
                        this.processNewEJBAnnotation(ejbRef, beanInterface, logicalName, ejbAn);
                    }
                    break block7;
                }
                if (!ElementType.METHOD.equals((Object)ainfo.getElementType())) break block8;
                Method m = (Method)ainfo.getAnnotatedElement();
                String targetClassName = m.getDeclaringClass().getName();
                String logicalName = ejbAn.name();
                if (logicalName.equals("")) {
                    String propertyName = this.getInjectionMethodPropertyName(m, ainfo);
                    logicalName = targetClassName + "/" + propertyName;
                }
                this.validateInjectionMethod(m, ainfo);
                Class<?>[] params = m.getParameterTypes();
                Class<?> beanInterface = ejbAn.beanInterface() == Object.class ? params[0] : ejbAn.beanInterface();
                InjectionTarget target = new InjectionTarget();
                target.setClassName(targetClassName);
                target.setMethodName(m.getName());
                for (EjbReferenceDescriptor ejbRef : ejbRefs = this.getEjbReferenceDescriptors(logicalName, rcContexts)) {
                    ejbRef.addInjectionTarget(target);
                    if (ejbRef.getName().length() != 0) continue;
                    this.processNewEJBAnnotation(ejbRef, beanInterface, logicalName, ejbAn);
                }
                break block7;
            }
            if (!ElementType.TYPE.equals((Object)ainfo.getElementType())) break block7;
            String logicalName = ejbAn.name();
            Class beanInterface = ejbAn.beanInterface();
            if ("".equals(logicalName) || beanInterface == Object.class) {
                Class c = (Class)ainfo.getAnnotatedElement();
                this.log(Level.SEVERE, ainfo, localStrings.getLocalString("enterprise.deployment.annotation.handlers.invalidtypelevelejb", "Invalid TYPE-level @EJB with name() = [{0}] and beanInterface = [{1}] in {2}.  Each TYPE-level @EJB must specify both name() and beanInterface().", new Object[]{logicalName, beanInterface, c}));
                return this.getDefaultFailedResult();
            }
            for (EjbReferenceDescriptor ejbRef : ejbRefs = this.getEjbReferenceDescriptors(logicalName, rcContexts)) {
                if (ejbRef.getName().length() != 0) continue;
                this.processNewEJBAnnotation(ejbRef, beanInterface, logicalName, ejbAn);
            }
        }
        return this.getDefaultProcessedResult();
    }

    private EjbReferenceDescriptor[] getEjbReferenceDescriptors(String logicalName, ResourceContainerContext[] rcContexts) {
        EjbReferenceDescriptor[] ejbRefs = new EjbReferenceDescriptor[rcContexts.length];
        for (int i = 0; i < rcContexts.length; ++i) {
            EjbReferenceDescriptor ejbRef = (EjbReferenceDescriptor)rcContexts[i].getEjbReference(logicalName);
            if (ejbRef == null) {
                ejbRef = new EjbReferenceDescriptor();
                rcContexts[i].addEjbReferenceDescriptor((EjbReference)ejbRef);
            }
            ejbRefs[i] = ejbRef;
        }
        return ejbRefs;
    }

    private void processNewEJBAnnotation(EjbReferenceDescriptor ejbRef, Class beanInterface, String logicalName, EJB annotation) {
        String ejbAnLookup;
        ejbRef.setName(logicalName);
        String targetBeanType = "Session";
        if (EJBHome.class.isAssignableFrom(beanInterface) || EJBLocalHome.class.isAssignableFrom(beanInterface)) {
            targetBeanType = this.processForHomeInterface(ejbRef, beanInterface);
        } else {
            ejbRef.setEjbInterface(beanInterface.getName());
            if (beanInterface.getAnnotation(Local.class) != null) {
                ejbRef.setLocal(true);
            } else if (beanInterface.getAnnotation(Remote.class) != null) {
                ejbRef.setLocal(false);
            } else {
                ejbRef.setLocal(false);
            }
        }
        String ejbAnBeanName = annotation.beanName();
        if (ejbAnBeanName != null && ejbAnBeanName.length() > 0) {
            ejbRef.setLinkName(ejbAnBeanName);
        }
        if ((ejbAnLookup = annotation.lookupName()) != null && ejbAnLookup.length() > 0 && !ejbRef.hasLookupName()) {
            ejbRef.setLookupName(ejbAnLookup);
        }
        ejbRef.setType(targetBeanType);
        ejbRef.setMappedName(annotation.mappedName());
        ejbRef.setDescription(annotation.description());
    }

    private String processForHomeInterface(EjbReferenceDescriptor ejbRef, Class beanInterface) {
        String targetBeanType;
        block4: {
            targetBeanType = "Session";
            ejbRef.setHomeClassName(beanInterface.getName());
            try {
                Method[] methods;
                for (Method m : methods = beanInterface.getMethods()) {
                    if (!m.getName().equals("create")) continue;
                    ejbRef.setEjbInterface(m.getReturnType().getName());
                    break;
                }
                for (Method m : methods) {
                    if (!m.getName().equals("findByPrimaryKey")) continue;
                    targetBeanType = "Entity";
                    break;
                }
            }
            catch (Exception e) {
                if (!this.logger.isLoggable(Level.FINE)) break block4;
                this.logger.log(Level.FINE, "component intf / ejb type annotation processing error", e);
            }
        }
        ejbRef.setLocal(EJBLocalHome.class.isAssignableFrom(beanInterface));
        return targetBeanType;
    }
}

