/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.amx.impl.config;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.management.ObjectName;
import org.glassfish.external.arc.Stability;
import org.glassfish.external.arc.Taxonomy;
import org.jvnet.hk2.config.ConfigBean;

@Taxonomy(stability=Stability.NOT_AN_INTERFACE)
public final class ConfigBeanRegistry {
    private final ConcurrentMap<ConfigBean, ObjectName> mToObjectName = new ConcurrentHashMap<ConfigBean, ObjectName>();
    private final ConcurrentMap<ObjectName, ConfigBean> mToConfigBean = new ConcurrentHashMap<ObjectName, ConfigBean>();
    private static final ConfigBeanRegistry INSTANCE = new ConfigBeanRegistry();

    private static void debug(String s) {
        System.out.println(s);
    }

    private ConfigBeanRegistry() {
    }

    public static ConfigBeanRegistry getInstance() {
        return INSTANCE;
    }

    public synchronized void add(ConfigBean cb, ObjectName objectName) {
        this.mToObjectName.put(cb, objectName);
        this.mToConfigBean.put(objectName, cb);
    }

    public synchronized void remove(ObjectName objectName) {
        ConfigBean cb = (ConfigBean)this.mToConfigBean.get(objectName);
        this.mToObjectName.remove(objectName);
        if (cb != null) {
            this.mToConfigBean.remove(cb);
        }
    }

    public ConfigBean getConfigBean(ObjectName objectName) {
        return (ConfigBean)this.mToConfigBean.get(objectName);
    }

    public ObjectName getObjectName(ConfigBean cb) {
        return (ObjectName)this.mToObjectName.get(cb);
    }
}

