/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.cli.commands;

import com.sun.enterprise.admin.cli.CLICommand;
import com.sun.enterprise.admin.cli.Environment;
import com.sun.enterprise.admin.cli.ProgramOptions;
import com.sun.enterprise.cli.framework.CommandException;
import com.sun.enterprise.cli.framework.CommandValidationException;
import com.sun.enterprise.cli.framework.ValidOption;
import com.sun.enterprise.universal.i18n.LocalStringsImpl;
import java.util.Collections;
import java.util.HashSet;

public class UnsetCommand
extends CLICommand {
    private static final LocalStringsImpl strings = new LocalStringsImpl(UnsetCommand.class);

    public UnsetCommand(String name, ProgramOptions programOpts, Environment env) throws CommandException {
        super(name, programOpts, env);
    }

    protected void prepare() throws CommandException, CommandValidationException {
        HashSet<ValidOption> opts = new HashSet<ValidOption>();
        UnsetCommand.addOption(opts, "help", '?', "BOOLEAN", false, "false");
        this.commandOpts = Collections.unmodifiableSet(opts);
        this.operandName = "environment-variable";
        this.operandType = "STRING";
        this.operandMin = 1;
        this.operandMax = Integer.MAX_VALUE;
    }

    public int executeCommand() throws CommandException, CommandValidationException {
        int ret = 0;
        for (String name : this.operands) {
            if (!name.startsWith("AS_ADMIN_")) {
                logger.printMessage(strings.get("badEnvVarUnset", new Object[]{name}));
                ret = -1;
                continue;
            }
            if (this.env.get(name) == null) {
                logger.printMessage(strings.get("cantRemoveEnvVar", new Object[]{name}));
                ret = -1;
                continue;
            }
            this.env.remove(name);
        }
        return ret;
    }
}

