/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.flashlight.provider;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.glassfish.flashlight.client.ProbeClientInvoker;
import org.glassfish.flashlight.client.ProbeHandle;

public class FlashlightProbe
implements ProbeHandle {
    private int id;
    private Class providerClazz;
    private String moduleProviderName;
    private String moduleName;
    private String probeName;
    private String probeProviderName;
    private String[] probeParamNames;
    private Class[] paramTypes;
    private List<ProbeClientInvoker> invokerList = new ArrayList<ProbeClientInvoker>(2);
    private String providerJavaMethodName;
    private AtomicBoolean enabled = new AtomicBoolean(false);
    private String probeDesc;

    public FlashlightProbe(int id, Class providerClazz, String moduleProviderName, String moduleName, String probeProviderName, String probeName, String[] probeParamNames, Class[] paramTypes) {
        this.id = id;
        this.providerClazz = providerClazz;
        this.moduleProviderName = moduleProviderName;
        this.moduleName = moduleName;
        this.probeProviderName = probeProviderName;
        this.probeName = probeName;
        this.probeParamNames = probeParamNames;
        this.paramTypes = paramTypes;
        this.probeDesc = moduleProviderName + ":" + moduleName + ":" + probeProviderName + ":" + probeName;
    }

    public synchronized boolean addInvoker(ProbeClientInvoker invoker) {
        boolean isFirst = this.invokerList.size() == 0;
        this.invokerList.add(invoker);
        this.enabled.set(true);
        return isFirst;
    }

    public synchronized boolean removeInvoker(ProbeClientInvoker invoker) {
        this.invokerList.remove(invoker);
        this.enabled.set(this.invokerList.size() > 0);
        return this.enabled.get();
    }

    public void fireProbe(Object[] params) {
        for (ProbeClientInvoker invoker : this.invokerList) {
            invoker.invoke(params);
        }
    }

    public boolean isEnabled() {
        return this.enabled.get();
    }

    public int getId() {
        return this.id;
    }

    public String getModuleProviderName() {
        return this.moduleProviderName;
    }

    public String getModuleName() {
        return this.moduleProviderName;
    }

    public String getProbeProviderName() {
        return this.probeProviderName;
    }

    public String getProbeName() {
        return this.probeName;
    }

    public String[] getProbeParamNames() {
        return this.probeParamNames;
    }

    public Class[] getParamTypes() {
        return this.paramTypes;
    }

    public String getProviderJavaMethodName() {
        return this.providerJavaMethodName;
    }

    public void setProviderJavaMethodName(String providerJavaMethodName) {
        this.providerJavaMethodName = providerJavaMethodName;
    }

    public String getProbeDesc() {
        return this.probeDesc;
    }

    public Class getProviderClazz() {
        return this.providerClazz;
    }

    public String toString() {
        StringBuilder sbldr = new StringBuilder(this.moduleProviderName + ":" + this.moduleName + ":" + this.probeProviderName + ":" + this.probeName);
        sbldr.append(" ").append(this.providerJavaMethodName).append("(");
        String delim = "";
        for (int index = 0; index < this.paramTypes.length; ++index) {
            String type = this.paramTypes[index] == null ? " " : this.paramTypes[index].getName();
            String name = this.probeParamNames[index] == null ? " " : this.probeParamNames[index];
            sbldr.append(delim).append(type).append(" ").append(name);
            delim = ", ";
        }
        sbldr.append(")");
        return sbldr.toString();
    }
}

