/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.api.embedded;

import com.sun.enterprise.module.bootstrap.ModuleStartup;
import com.sun.enterprise.module.bootstrap.PlatformMain;
import com.sun.enterprise.module.bootstrap.StartupContext;
import com.sun.hk2.component.ExistingSingletonInhabitant;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.container.Sniffer;
import org.glassfish.api.embedded.ContainerBuilder;
import org.glassfish.api.embedded.EmbeddedContainer;
import org.glassfish.api.embedded.EmbeddedDeployer;
import org.glassfish.api.embedded.EmbeddedFileSystem;
import org.glassfish.api.embedded.EmbeddedLifecycle;
import org.glassfish.api.embedded.LifecycleException;
import org.glassfish.api.embedded.Port;
import org.glassfish.api.embedded.Ports;
import org.jvnet.hk2.annotations.Contract;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.Inhabitant;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Contract
public class Server {
    private static final Map<String, Server> servers = new HashMap<String, Server>();
    public final String serverName;
    public final boolean loggerEnabled;
    public final boolean verbose;
    public final File loggerFile;
    public final Inhabitant<EmbeddedFileSystem> fileSystem;
    private final Habitat habitat;
    private final List<Container> containers = new ArrayList<Container>();

    private Server(Builder builder) {
        EmbeddedFileSystem fs;
        File f;
        this.serverName = builder.serverName;
        this.loggerEnabled = builder.loggerEnabled;
        this.verbose = builder.verbose;
        this.loggerFile = builder.loggerFile;
        File instanceRoot = null;
        if (builder.fileSystem == null || builder.fileSystem.instanceRoot == null) {
            f = null;
            try {
                f = File.createTempFile("gfembed", "tmp", new File(System.getProperty("user.dir")));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            f.delete();
            instanceRoot = new File(f.getParent(), f.getName());
            EmbeddedFileSystem.Builder fsBuilder = new EmbeddedFileSystem.Builder();
            if (builder.fileSystem != null) {
                fsBuilder.setInstallRoot(builder.fileSystem.installRoot);
                fsBuilder.setConfigurationFile(builder.fileSystem.configFile);
            }
            fsBuilder.setInstanceRoot(instanceRoot);
            fsBuilder.setAutoDelete(true);
            fs = fsBuilder.build();
        } else {
            fs = builder.fileSystem;
        }
        if (!fs.instanceRoot.exists()) {
            fs.instanceRoot.mkdirs();
            f = new File(fs.instanceRoot, "docroot");
            f.mkdirs();
        }
        this.fileSystem = new ExistingSingletonInhabitant((Object)fs);
        PlatformMain embedded = this.getMain();
        if (embedded == null) {
            throw new RuntimeException("Embedded startup not found, classpath is probably incomplete");
        }
        if (fs.installRoot == null) {
            embedded.setContext((Object)new StartupContext(fs.instanceRoot, fs.instanceRoot, new String[0]));
            System.setProperty("com.sun.aas.installRoot", fs.instanceRoot.getAbsolutePath());
        } else {
            embedded.setContext((Object)new StartupContext(fs.installRoot, fs.instanceRoot, new String[0]));
            System.setProperty("com.sun.aas.installRoot", fs.installRoot.getAbsolutePath());
        }
        System.setProperty("com.sun.aas.instanceRoot", fs.instanceRoot.getAbsolutePath());
        embedded.setContext((Object)this);
        embedded.setLogger(Logger.getAnonymousLogger());
        try {
            embedded.start(new String[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.habitat = (Habitat)embedded.getStartedService(Habitat.class);
        this.habitat.addIndex(this.fileSystem, EmbeddedFileSystem.class.getName(), null);
        for (EmbeddedLifecycle lifecycle : this.habitat.getAllByContract(EmbeddedLifecycle.class)) {
            try {
                lifecycle.creation(this);
            }
            catch (Exception e) {
                Logger.getAnonymousLogger().log(Level.WARNING, "Exception while notifying of embedded server startup", e);
            }
        }
    }

    public ContainerBuilder<EmbeddedContainer> getConfig(ContainerBuilder.Type type2) {
        return (ContainerBuilder)this.habitat.getComponent(ContainerBuilder.class, type2.toString());
    }

    public <T extends ContainerBuilder<?>> T createConfig(Class<T> configType) {
        return (T)((ContainerBuilder)this.habitat.getComponent(configType));
    }

    public void addContainer(final ContainerBuilder.Type type2) {
        this.containers.add(new Container(new EmbeddedContainer(){
            final List<Container> delegates = new ArrayList<Container>();
            final ArrayList<Sniffer> sniffers = new ArrayList();

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<Sniffer> getSniffers() {
                ArrayList<Sniffer> arrayList = this.sniffers;
                synchronized (arrayList) {
                    if (this.sniffers.isEmpty()) {
                        if (type2 == ContainerBuilder.Type.all) {
                            for (ContainerBuilder.Type t : ContainerBuilder.Type.values()) {
                                if (t == ContainerBuilder.Type.all) continue;
                                this.delegates.add(this.getContainerFor(t));
                            }
                        } else {
                            this.delegates.add(this.getContainerFor(type2));
                        }
                    }
                    for (Container c : this.delegates) {
                        this.sniffers.addAll(c.container.getSniffers());
                    }
                }
                return this.sniffers;
            }

            private Container getContainerFor(final ContainerBuilder.Type type22) {
                ContainerBuilder<EmbeddedContainer> b = Server.this.getConfig(type22);
                if (b != null) {
                    return new Container(b.create(Server.this));
                }
                return new Container(new EmbeddedContainer(){

                    @Override
                    public List<Sniffer> getSniffers() {
                        ArrayList<Sniffer> sniffers = new ArrayList<Sniffer>();
                        Sniffer s = (Sniffer)Server.this.habitat.getComponent(Sniffer.class, type22.toString());
                        if (s != null) {
                            sniffers.add(s);
                        }
                        return sniffers;
                    }

                    @Override
                    public void start() throws LifecycleException {
                    }

                    @Override
                    public void stop() throws LifecycleException {
                    }
                });
            }

            @Override
            public void start() throws LifecycleException {
                for (Container c : this.delegates) {
                    if (c.started) continue;
                    c.container.start();
                    c.started = true;
                }
            }

            @Override
            public void stop() throws LifecycleException {
                for (Container c : this.delegates) {
                    if (!c.started) continue;
                    c.container.stop();
                    c.started = false;
                }
            }
        }));
    }

    public <T extends EmbeddedContainer> T addContainer(ContainerBuilder<T> info) {
        T container = info.create(this);
        if (container != null && this.containers.add(new Container((EmbeddedContainer)container))) {
            return container;
        }
        return null;
    }

    public Collection<EmbeddedContainer> getContainers() {
        ArrayList<EmbeddedContainer> copy = new ArrayList<EmbeddedContainer>();
        for (Container c : this.containers) {
            copy.add(c.container);
        }
        return copy;
    }

    public Port createPort(int portNumber) throws IOException {
        Ports ports = (Ports)this.habitat.getComponent(Ports.class);
        return ports.open(portNumber);
    }

    public Habitat getHabitat() {
        return this.habitat;
    }

    public String getName() {
        return this.serverName;
    }

    public EmbeddedFileSystem getFileSystem() {
        return (EmbeddedFileSystem)this.fileSystem.get();
    }

    public void start() throws LifecycleException {
        for (Container c : this.containers) {
            try {
                c.container.start();
                c.started = true;
            }
            catch (LifecycleException e) {
                e.printStackTrace();
                c.started = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() throws LifecycleException {
        for (Container container : this.containers) {
            try {
                if (!container.started) continue;
                container.container.stop();
            }
            finally {
                container.started = false;
            }
        }
        this.habitat.getClass();
        ModuleStartup ms = (ModuleStartup)this.habitat.getComponent(ModuleStartup.class, "_HABITAT_DEFAULT");
        if (ms != null) {
            ms.stop();
        }
        Map<String, Server> map = servers;
        synchronized (map) {
            servers.remove(this.serverName);
        }
        for (EmbeddedLifecycle lifecycle : this.habitat.getAllByContract(EmbeddedLifecycle.class)) {
            try {
                lifecycle.destruction(this);
            }
            catch (Exception e) {
                Logger.getAnonymousLogger().log(Level.WARNING, "Exception while notifying of embedded server destruction", e);
            }
        }
        ((EmbeddedFileSystem)this.fileSystem.get()).preDestroy();
    }

    public EmbeddedDeployer getDeployer() {
        return (EmbeddedDeployer)this.habitat.getByContract(EmbeddedDeployer.class);
    }

    private PlatformMain getMain() {
        String platformName = ((EmbeddedFileSystem)this.fileSystem.get()).installRoot != null && ((EmbeddedFileSystem)this.fileSystem.get()).instanceRoot.exists() ? "Static" : "Embedded";
        ServiceLoader<PlatformMain> mains = ServiceLoader.load(PlatformMain.class, Server.class.getClassLoader());
        for (PlatformMain main : mains) {
            if (!platformName.equals(main.getName())) continue;
            return main;
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Builder {
        final String serverName;
        boolean loggerEnabled;
        boolean verbose;
        File loggerFile;
        EmbeddedFileSystem fileSystem;

        public Builder(String id) {
            this.serverName = id;
        }

        public Builder setLogger(boolean enabled) {
            this.loggerEnabled = enabled;
            return this;
        }

        public Builder setLogFile(File f) {
            this.loggerFile = f;
            return this;
        }

        public Builder setVerbose(boolean b) {
            this.verbose = b;
            return this;
        }

        public Builder setEmbeddedFileSystem(EmbeddedFileSystem fileSystem) {
            this.fileSystem = fileSystem;
            return this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Server build() {
            Map map = servers;
            synchronized (map) {
                if (!servers.containsKey(this.serverName)) {
                    servers.put(this.serverName, new Server(this));
                }
                return (Server)servers.get(this.serverName);
            }
        }

        public static List<String> getServerNames() {
            ArrayList<String> names = new ArrayList<String>();
            names.addAll(servers.keySet());
            return names;
        }
    }

    private class Container {
        private final EmbeddedContainer container;
        boolean started;

        private Container(EmbeddedContainer container) {
            this.container = container;
        }
    }
}

