/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.admin.apps.console;

import com.sun.messaging.jmq.admin.apps.console.BlankInspector;
import com.sun.messaging.jmq.admin.apps.console.ConsoleObj;
import com.sun.messaging.jmq.admin.apps.console.InspectorPanel;
import com.sun.messaging.jmq.admin.apps.console.SplashScreenInspector;
import com.sun.messaging.jmq.admin.apps.console.event.AdminEvent;
import com.sun.messaging.jmq.admin.apps.console.event.AdminEventListener;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.Hashtable;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.EventListenerList;

public class AInspector
extends JScrollPane {
    private static String SPLASH_SCREEN = "SplashScreen";
    private static String BLANK = "Blank";
    private EventListenerList aListeners = new EventListenerList();
    private InspectorPanel currentCard = null;
    private CardLayout cardLayout;
    private JPanel cardPanel;
    private Hashtable cardList;

    public AInspector() {
        this.initGui();
    }

    public void addAdminEventListener(AdminEventListener adminEventListener) {
        this.aListeners.add(AdminEventListener.class, adminEventListener);
    }

    public void removeAdminEventListener(AdminEventListener adminEventListener) {
        this.aListeners.remove(AdminEventListener.class, adminEventListener);
    }

    public void inspect(ConsoleObj consoleObj) {
        if (consoleObj == null) {
            this.cardLayout.show(this.cardPanel, BLANK);
            return;
        }
        InspectorPanel inspectorPanel = this.getInspectorPanel(consoleObj);
        if (inspectorPanel == null && (inspectorPanel = this.addInspectorPanel(consoleObj)) == null) {
            System.err.println("Cannot inspect object: " + consoleObj + "\nFailed to create inspector panel");
            return;
        }
        this.currentCard = inspectorPanel;
        this.currentCard.inspectConsoleObj(consoleObj, this.aListeners);
        this.showInspectorPanel(consoleObj);
    }

    public void refresh() {
        if (this.currentCard != null) {
            this.currentCard.refresh();
        }
    }

    public void selectedObjectUpdated() {
        if (this.currentCard != null) {
            this.currentCard.selectedObjectUpdated();
        }
    }

    public void clearSelection() {
        if (this.currentCard != null) {
            this.currentCard.clearSelection();
        }
    }

    private void showInspectorPanel(ConsoleObj consoleObj) {
        this.cardLayout.show(this.cardPanel, consoleObj.getInspectorPanelId());
    }

    private InspectorPanel getInspectorPanel(ConsoleObj consoleObj) {
        String string = consoleObj.getInspectorPanelId();
        Object v = this.cardList.get(string);
        if (v != null && v instanceof InspectorPanel) {
            return (InspectorPanel)v;
        }
        return null;
    }

    private InspectorPanel addInspectorPanel(ConsoleObj consoleObj) {
        String string = consoleObj.getInspectorPanelId();
        String string2 = consoleObj.getInspectorPanelClassName();
        InspectorPanel inspectorPanel = null;
        try {
            inspectorPanel = (InspectorPanel)Class.forName(string2).newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
            System.err.println("ConsoleObj does not name a valid inspector panel classname: " + classNotFoundException);
        }
        catch (InstantiationException instantiationException) {
            System.err.println("Failed to intantiate inspector panel : " + instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            System.err.println("Illegal Access Exception while trying to intantiate inspector panel : " + illegalAccessException);
        }
        if (inspectorPanel == null) {
            return null;
        }
        this.cardPanel.add((Component)inspectorPanel, string);
        this.cardList.put(string, inspectorPanel);
        return inspectorPanel;
    }

    private void fireAdminEventDispatched(AdminEvent adminEvent) {
        Object[] objectArray = this.aListeners.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != AdminEventListener.class) continue;
            ((AdminEventListener)objectArray[i + 1]).adminEventDispatched(adminEvent);
        }
    }

    private void initGui() {
        this.cardPanel = new JPanel();
        this.cardLayout = new CardLayout();
        this.cardPanel.setLayout(this.cardLayout);
        this.initLayers(this.cardPanel);
        this.setViewportView(this.cardPanel);
        Dimension dimension = new Dimension(100, 50);
        this.setMinimumSize(dimension);
    }

    private void initLayers(JPanel jPanel) {
        JPanel jPanel2 = new JPanel();
        this.cardList = new Hashtable();
        jPanel2 = new SplashScreenInspector();
        jPanel.add((Component)jPanel2, SPLASH_SCREEN);
        this.cardList.put(SPLASH_SCREEN, jPanel2);
        jPanel2 = new BlankInspector();
        jPanel.add((Component)jPanel2, BLANK);
        this.cardList.put(BLANK, jPanel2);
        this.cardLayout.show(jPanel, SPLASH_SCREEN);
    }
}

