/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.webservices.monitoring;

import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.WebServiceEndpoint;
import com.sun.xml.ws.api.server.WSEndpoint;
import com.sun.xml.ws.transport.http.servlet.ServletAdapter;
import javax.xml.namespace.QName;
import org.glassfish.gmbal.Description;
import org.glassfish.gmbal.ManagedAttribute;
import org.glassfish.gmbal.ManagedData;

@ManagedData
@Description(value="109 deployed endpoint info")
public class DeployedEndpointData {
    @ManagedAttribute
    @Description(value="Application Name")
    public final String appName;
    @ManagedAttribute
    @Description(value="Endpoint Name")
    public final String endpointName;
    @ManagedAttribute
    @Description(value="Target Namespace of the Web Service")
    public final String namespace;
    @ManagedAttribute
    @Description(value="Web Service name")
    public final String serviceName;
    @ManagedAttribute
    @Description(value="Web Service port name")
    public final String portName;
    @ManagedAttribute
    @Description(value="Service Implementation Class")
    public final String implClass;
    @ManagedAttribute
    @Description(value="Address for Web Service")
    public final String address;
    @ManagedAttribute
    @Description(value="WSDL for Web Service")
    public final String wsdl;
    @ManagedAttribute
    @Description(value="Tester for Web Service")
    public final String tester;
    @ManagedAttribute
    @Description(value="Implementation Type: EJB or SERVLET")
    public final String implType;
    @ManagedAttribute
    @Description(value="Deployment Type: 109 or RI")
    public final String deploymentType;

    public DeployedEndpointData(Application app, WebServiceEndpoint endpoint) {
        this.appName = app.getAppName();
        this.endpointName = endpoint.getEndpointName();
        this.namespace = endpoint.getServiceName().getNamespaceURI();
        this.serviceName = endpoint.getServiceName().getLocalPart();
        QName pName = endpoint.getWsdlPort();
        this.portName = pName != null ? pName.getLocalPart() : "";
        this.implClass = endpoint.implementedByEjbComponent() ? endpoint.getEjbComponentImpl().getEjbImplClassName() : endpoint.getServletImplClass();
        this.address = endpoint.getEndpointAddressPath();
        this.wsdl = this.address + "?wsdl";
        this.tester = this.address + "?Tester";
        this.implType = endpoint.implementedByEjbComponent() ? "EJB" : "SERVLET";
        this.deploymentType = "109";
    }

    public DeployedEndpointData(ServletAdapter adapter) {
        WSEndpoint endpoint = adapter.getEndpoint();
        this.appName = "";
        this.endpointName = adapter.getName();
        this.namespace = endpoint.getServiceName().getNamespaceURI();
        this.serviceName = endpoint.getServiceName().getLocalPart();
        this.portName = endpoint.getPortName().getLocalPart();
        this.implClass = endpoint.getImplementationClass().getName();
        this.address = adapter.getValidPath();
        this.wsdl = this.address + "?wsdl";
        this.tester = "";
        this.implType = "SERVLET";
        this.deploymentType = "RI";
    }
}

