/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.webservices.monitoring;

import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.WebServiceEndpoint;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.ConcurrentHashMap;
import org.glassfish.external.probe.provider.annotations.ProbeListener;
import org.glassfish.external.probe.provider.annotations.ProbeParam;
import org.glassfish.gmbal.Description;
import org.glassfish.gmbal.ManagedAttribute;
import org.glassfish.gmbal.ManagedObject;
import org.glassfish.webservices.monitoring.DeployedEndpointData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ManagedObject
@Description(value="Stats for Web Services deployed")
public class WebServiceStatsProvider {
    private final ConcurrentHashMap<String, DeployedEndpointData> endpoints = new ConcurrentHashMap();

    @ProbeListener(value="glassfish:webservices:109:deploy")
    public void eeDeploy(@ProbeParam(value="app") Application app, @ProbeParam(value="endpoint") WebServiceEndpoint endpoint) {
        String path = endpoint.getEndpointAddressPath();
        if (!this.endpoints.containsKey(path)) {
            DeployedEndpointData data = new DeployedEndpointData(app, endpoint);
            this.endpoints.put(path, data);
        }
    }

    @ProbeListener(value="glassfish:webservices:109:undeploy")
    public void eeUndeploy(@ProbeParam(value="path") String path) {
        this.endpoints.remove(path);
    }

    @ManagedAttribute
    @Description(value="Deployed Web Service Endpoints")
    public Collection<DeployedEndpointData> getEndpoints() {
        return Collections.unmodifiableCollection(this.endpoints.values());
    }
}

