/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.auth.acl;

import com.sun.messaging.jmq.auth.api.server.model.AccessControlModel;
import com.sun.messaging.jmq.auth.jaas.PermissionFactory;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.util.log.Logger;
import java.security.AccessControlException;
import java.security.AccessController;
import java.security.Permission;
import java.security.Policy;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.util.Properties;
import javax.security.auth.Subject;

public class JAASAccessControlModel
implements AccessControlModel {
    public static final String TYPE = "jaas";
    public static final String PROP_PERMISSION_FACTORY = "jaas.permissionFactory";
    public static final String PROP_PERMISSION_FACTORY_PRIVATE = "jaas.permissionFactoryPrivate";
    public static final String PROP_POLICY_PROVIDER = "jaas.policyProvider";
    private static boolean DEBUG = false;
    private Logger logger = Globals.getLogger();
    private String type;
    private Properties authProps;
    private PermissionFactory permFactory = null;
    private String permFactoryPrivate = null;
    private Policy policyProvider = null;

    public String getType() {
        return TYPE;
    }

    public void initialize(String string, Properties properties) throws AccessControlException {
        this.type = string;
        if (!string.equals(TYPE)) {
            Object[] objectArray = new String[]{string, TYPE, this.getClass().getName()};
            String string2 = Globals.getBrokerResources().getKString("B4072", objectArray);
            this.logger.log(32, string2);
            throw new AccessControlException(string2);
        }
        this.authProps = properties;
        String string3 = this.authProps.getProperty("imq.accesscontrol.jaas.permissionFactory");
        assert (string3 != null);
        String string4 = this.authProps.getProperty("imq.accesscontrol.jaas.policyProvider");
        try {
            if (string3 != null) {
                this.permFactory = (PermissionFactory)Class.forName(string3).newInstance();
            }
            if (string4 != null) {
                this.policyProvider = (Policy)Class.forName(string4).newInstance();
            }
        }
        catch (Exception exception) {
            this.logger.logStack(32, exception.getMessage(), exception);
            throw new AccessControlException(exception.getClass().getName() + ": " + exception.getMessage());
        }
        this.permFactoryPrivate = this.authProps.getProperty("imq.accesscontrol.jaas.permissionFactoryPrivate");
        this.load();
    }

    public void load() throws AccessControlException {
        try {
            Policy.getPolicy().refresh();
        }
        catch (SecurityException securityException) {
            AccessControlException accessControlException = new AccessControlException(securityException.toString());
            accessControlException.initCause(securityException);
            throw accessControlException;
        }
    }

    public void checkConnectionPermission(Principal principal, String string, String string2, Subject subject) throws AccessControlException {
        Permission permission;
        try {
            permission = this.permFactory.newPermission(this.permFactoryPrivate, "mq-conn::" + string2, null, null);
        }
        catch (Exception exception) {
            this.logger.logStack(32, exception.toString(), exception);
            AccessControlException accessControlException = new AccessControlException(exception.toString());
            accessControlException.initCause(exception);
            throw accessControlException;
        }
        try {
            this.checkPermission(subject, permission);
        }
        catch (AccessControlException accessControlException) {
            AccessControlException accessControlException2 = new AccessControlException(accessControlException.getMessage() + ": " + principal + " [" + subject.getPrincipals() + "]");
            accessControlException2.initCause(accessControlException);
            throw accessControlException2;
        }
    }

    public void checkDestinationPermission(Principal principal, String string, String string2, Subject subject, String string3, String string4, String string5) throws AccessControlException {
        Permission permission;
        try {
            permission = string3.equals("create") ? this.permFactory.newPermission(this.permFactoryPrivate, "mq-auto::queue", null, null) : this.permFactory.newPermission(this.permFactoryPrivate, "mq-dest::queue:" + string4, string3, null);
        }
        catch (Exception exception) {
            this.logger.logStack(32, exception.toString(), exception);
            AccessControlException accessControlException = new AccessControlException(exception.toString());
            accessControlException.initCause(exception);
            throw accessControlException;
        }
        try {
            this.checkPermission(subject, permission);
        }
        catch (AccessControlException accessControlException) {
            AccessControlException accessControlException2 = new AccessControlException(accessControlException.getMessage() + ": " + principal + " [" + subject.getPrincipals() + "]");
            accessControlException2.initCause(accessControlException);
            throw accessControlException2;
        }
    }

    private void checkPermission(Subject subject, Permission permission) throws AccessControlException {
        final Permission permission2 = permission;
        Subject.doAsPrivileged(subject, new PrivilegedAction(){

            public Object run() {
                AccessController.checkPermission(permission2);
                return null;
            }
        }, null);
    }
}

