/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.data;

import com.sun.messaging.jmq.jmsserver.data.BaseTransaction;
import com.sun.messaging.jmq.jmsserver.data.TransactionBroker;
import com.sun.messaging.jmq.jmsserver.data.TransactionState;
import com.sun.messaging.jmq.jmsserver.data.TransactionUID;
import com.sun.messaging.jmq.jmsserver.data.TransactionWork;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class ClusterTransaction
extends BaseTransaction {
    TransactionBroker[] transactionBrokers;

    public ClusterTransaction() {
        super(3);
    }

    public ClusterTransaction(TransactionUID transactionUID, TransactionState transactionState, TransactionWork transactionWork, TransactionBroker[] transactionBrokerArray) {
        this();
        this.transactionDetails.setTid(transactionUID);
        this.transactionDetails.setXid(transactionState.getXid());
        this.transactionDetails.setState(5);
        this.setTransactionWork(transactionWork);
        this.setTransactionState(transactionState);
        this.setTransactionBrokers(transactionBrokerArray);
    }

    public void readData(DataInputStream dataInputStream) throws IOException, BrokerException {
        this.transactionDetails.readContent(dataInputStream);
        this.transactionWork.readWork(dataInputStream);
    }

    public void readObjects(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.transactionState = (TransactionState)objectInputStream.readObject();
        this.transactionBrokers = (TransactionBroker[])objectInputStream.readObject();
    }

    public void writeData(DataOutputStream dataOutputStream) throws IOException {
        this.transactionDetails.writeContent(dataOutputStream);
        this.transactionWork.writeWork(dataOutputStream);
    }

    public void writeObjects(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeObject(this.transactionState);
        objectOutputStream.writeObject(this.transactionBrokers);
    }

    public TransactionBroker[] getTransactionBrokers() {
        return this.transactionBrokers;
    }

    public void setTransactionBrokers(TransactionBroker[] transactionBrokerArray) {
        this.transactionBrokers = transactionBrokerArray;
    }

    String getPrefix() {
        return "ClusterTransaction: " + Thread.currentThread().getName() + " " + this.getTid();
    }
}

