/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.appclient.server.core;

import com.sun.enterprise.deployment.runtime.JnlpDocDescriptor;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLConnection;
import java.util.Map;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathFactory;
import org.glassfish.appclient.server.core.CombinedXPath;
import org.glassfish.appclient.server.core.jws.servedcontent.DynamicContent;
import org.glassfish.appclient.server.core.jws.servedcontent.FixedContent;
import org.glassfish.appclient.server.core.jws.servedcontent.SimpleDynamicContentImpl;
import org.glassfish.appclient.server.core.jws.servedcontent.StaticContent;
import org.glassfish.appclient.server.core.jws.servedcontent.TokenHelper;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeveloperContentHandler {
    private final ClassLoader loader;
    private final JnlpDocDescriptor jnlpDoc;
    private final Map<String, StaticContent> staticContent;
    private final Map<String, DynamicContent> dynamicContent;
    private final TokenHelper tHelper;
    private final File appRootDir;
    private final URI appRootURI;
    private static DocumentBuilderFactory dbf = null;
    private static final XPathFactory xPathFactory = XPathFactory.newInstance();
    private static final XPath xPath = xPathFactory.newXPath();
    private final XPathToDeveloperProvidedContent[] xPathsToDevContent = new XPathToDeveloperProvidedContent[]{new XPathToStaticContent("jnlp/information/homepage/@href"), new XPathToStaticContent("jnlp/information/icon/@href"), new XPathToStaticContent("jnlp/resources/java/resources/jar/@href"), new XPathToStaticContent("jnlp/resources/jar/@href"), new XPathToStaticContent("jnlp/resources/nativelib/@href"), new XPathToStaticContent("jnlp/related-content/@href"), new XPathToDynamicContent("jnlp/resources/extension/@href")};
    private static final CombinedXPath[] xPaths = new CombinedXPath[]{new CombinedXPath.OwnedXPath(xPath, "/jnlp", "/@codebase"), new CombinedXPath.OwnedXPath(xPath, "/jnlp", "/@href"), new CombinedXPath.OwnedXPath(xPath, "/jnlp", "/security"), new CombinedXPath.OwnedXPath(xPath, "/jnlp", "/application-desc"), new CombinedXPath.DefaultedXPath(xPath, "/jnlp", "/@spec"), new CombinedXPath.DefaultedXPath(xPath, "/jnlp", "/@version"), new CombinedXPath.DefaultedXPath(xPath, "/jnlp", "/information"), new CombinedXPath.DefaultedXPath(xPath, "/jnlp", "/resources/javase"), new CombinedXPath.DefaultedXPath(xPath, "/jnlp", "/resources/javase/@version"), new CombinedXPath.DefaultedXPath(xPath, "/jnlp", "/resources/javase/@java-vm-args"), new CombinedXPath.MergedXPath(xPath, "/jnlp/resources", "/jar"), new CombinedXPath.MergedXPath(xPath, "/jnlp/resources", "/property"), new CombinedXPath.MergedXPath(xPath, "/jnlp/resources", "/extension")};

    public static DeveloperContentHandler addDeveloperContent(ClassLoader loader, JnlpDocDescriptor jnlpDoc, TokenHelper tHelper, File appRootDir, Map<String, StaticContent> staticContent, Map<String, DynamicContent> dynamicContent) {
        DeveloperContentHandler h = new DeveloperContentHandler(loader, jnlpDoc, tHelper, appRootDir, staticContent, dynamicContent);
        h.process();
        return h;
    }

    private DeveloperContentHandler(ClassLoader loader, JnlpDocDescriptor jnlpDoc, TokenHelper tHelper, File appRootDir, Map<String, StaticContent> staticContent, Map<String, DynamicContent> dynamicContent) {
        this.loader = loader;
        this.jnlpDoc = jnlpDoc;
        this.tHelper = tHelper;
        this.appRootDir = appRootDir;
        this.appRootURI = appRootDir.toURI();
        this.staticContent = staticContent;
        this.dynamicContent = dynamicContent;
    }

    private void processDeveloperJNLP() {
        String href;
        if (this.jnlpDoc == null || (href = this.jnlpDoc.getHref()) == null) {
            return;
        }
        InputStream devJNLPStream = this.loader.getResourceAsStream(href);
        if (devJNLPStream == null) {
            return;
        }
        String generatedJNLP = this.dynamicContent.get(this.tHelper.mainJNLP()).getOrCreateInstance(new Properties()).getText();
        InputSource generatedJNLPSource = new InputSource(new StringReader(generatedJNLP));
        try {
            DocumentBuilder db = DeveloperContentHandler.getDocumentBuilderFactory().newDocumentBuilder();
            Document developerDOM = db.parse(devJNLPStream);
            Document gfDOM = db.parse(generatedJNLPSource);
            for (CombinedXPath combinedXPath : xPaths) {
                combinedXPath.process(developerDOM, gfDOM);
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    private void process() {
        String jnlpDocHref;
        if (this.jnlpDoc == null || (jnlpDocHref = this.jnlpDoc.getHref()) == null) {
            return;
        }
        InputStream devJNLPStream = this.loader.getResourceAsStream(jnlpDocHref);
        if (devJNLPStream == null) {
            return;
        }
        try {
            URI codebaseURI = new URI(this.tHelper.appCodebasePath());
            DocumentBuilder db = DeveloperContentHandler.getDocumentBuilderFactory().newDocumentBuilder();
            Document developerDOM = db.parse(devJNLPStream);
            for (XPathToDeveloperProvidedContent c : this.xPathsToDevContent) {
                NodeList nodes = (NodeList)c.xPathExpr().evaluate(developerDOM, XPathConstants.NODESET);
                if (nodes.getLength() <= 0) continue;
                for (int i = 0; i < nodes.getLength(); ++i) {
                    String href = nodes.item(i).getNodeValue();
                    c.addToContentIfInApp(codebaseURI, href, this.loader);
                }
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    private static synchronized DocumentBuilderFactory getDocumentBuilderFactory() {
        if (dbf == null) {
            dbf = DocumentBuilderFactory.newInstance();
        }
        return dbf;
    }

    private abstract class XPathToDeveloperProvidedContent {
        private final XPathExpression xPathExpr;

        XPathToDeveloperProvidedContent(String path) {
            try {
                this.xPathExpr = xPath.compile(path);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        XPathExpression xPathExpr() {
            return this.xPathExpr;
        }

        abstract void addToContentIfInApp(URI var1, String var2, ClassLoader var3) throws URISyntaxException, IOException;
    }

    private class XPathToDynamicContent
    extends XPathToDeveloperProvidedContent {
        XPathToDynamicContent(String path) {
            super(path);
        }

        void addToContentIfInApp(URI codebase, String pathToContent, ClassLoader loader) throws URISyntaxException, IOException {
            int bytesRead;
            URI uriToContent = new URI(pathToContent);
            URI absURI = codebase.resolve(uriToContent);
            if (absURI.equals(uriToContent)) {
                return;
            }
            InputStream is = loader.getResourceAsStream(pathToContent);
            if (is == null) {
                return;
            }
            byte[] buffer = new byte[1024];
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            while ((bytesRead = is.read(buffer)) != -1) {
                baos.write(buffer, 0, bytesRead);
            }
            is.close();
            DeveloperContentHandler.this.dynamicContent.put(pathToContent, new SimpleDynamicContentImpl(baos.toString(), URLConnection.guessContentTypeFromName(pathToContent)));
        }
    }

    private class XPathToStaticContent
    extends XPathToDeveloperProvidedContent {
        XPathToStaticContent(String path) {
            super(path);
        }

        void addToContentIfInApp(URI codebase, String pathToContent, ClassLoader loader) throws URISyntaxException {
            URI uriToContent = new URI(pathToContent);
            URI absURI = codebase.resolve(uriToContent);
            if (absURI.equals(uriToContent)) {
                return;
            }
            URI fileURI = DeveloperContentHandler.this.appRootURI.resolve(pathToContent);
            File f = new File(fileURI);
            DeveloperContentHandler.this.staticContent.put(pathToContent, new FixedContent(f));
        }
    }
}

