/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.appclient.server.core;

import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.ApplicationClientDescriptor;
import com.sun.enterprise.deployment.archivist.AppClientArchivist;
import com.sun.enterprise.deployment.deploy.shared.InputJarArchive;
import com.sun.enterprise.deployment.deploy.shared.Util;
import com.sun.enterprise.deployment.util.ModuleDescriptor;
import com.sun.logging.LogDomains;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.net.URI;
import java.text.MessageFormat;
import java.util.HashSet;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.glassfish.api.ActionReport;
import org.glassfish.api.deployment.DeployCommandParameters;
import org.glassfish.api.deployment.DeploymentContext;
import org.glassfish.appclient.server.core.AppClientDeployerHelper;
import org.glassfish.appclient.server.core.jws.servedcontent.FixedContent;
import org.glassfish.deployment.common.DownloadableArtifacts;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NestedAppClientDeployerHelper
extends AppClientDeployerHelper {
    private Set<DownloadableArtifacts.FullAndPartURIs> libraryAndClassPathJARs = new HashSet<DownloadableArtifacts.FullAndPartURIs>();
    private StringBuilder classPathForFacade = new StringBuilder();
    private final URI earURI;
    private static Logger logger = LogDomains.getLogger(NestedAppClientDeployerHelper.class, (String)"javax.enterprise.system.container.appclient");
    private final Set<DownloadableArtifacts.FullAndPartURIs> clientLevelDownloads = new HashSet<DownloadableArtifacts.FullAndPartURIs>();
    private final Set<DownloadableArtifacts.FullAndPartURIs> earLevelDownloads = new HashSet<DownloadableArtifacts.FullAndPartURIs>();
    private static final Pattern submoduleURIPattern = Pattern.compile("(.*)_([wcrj]ar)$");

    NestedAppClientDeployerHelper(DeploymentContext dc, ApplicationClientDescriptor bundleDesc, AppClientArchivist archivist, ClassLoader gfClientModuleClassLoader, String defaultAlias, Application application) throws IOException {
        super(dc, bundleDesc, archivist, gfClientModuleClassLoader, defaultAlias, application);
        this.earURI = dc.getSource().getParentArchive().getURI();
        this.processDependencies();
    }

    @Override
    public FixedContent fixedContentWithinEAR(String uriString) {
        return new FixedContent(new File(this.earDirUserURI(this.dc()).resolve(uriString)));
    }

    private void processDependencies() throws IOException {
        File libDirFile;
        URI appClientURI = URI.create(Util.getURIName((URI)this.appClientUserURI(this.dc())));
        this.classPathForFacade.append(appClientURI);
        this.clientLevelDownloads.add(new DownloadableArtifacts.FullAndPartURIs(this.facadeServerURI(this.dc()), this.facadeUserURI(this.dc())));
        HashSet<URI> dependencyURIsProcessed = new HashSet<URI>();
        String appClientURIWithinEAR = this.appClientDesc().getModuleDescriptor().getArchiveUri();
        this.processDependencies(this.earURI, URI.create(appClientURIWithinEAR), this.earLevelDownloads, dependencyURIsProcessed, appClientURI);
        String libDir = this.appClientDesc().getApplication().getLibraryDirectory();
        if (libDir != null && (libDirFile = new File(new File(this.earURI), libDir)).exists() && libDirFile.isDirectory()) {
            for (File libJar : libDirFile.listFiles(new FileFilter(){

                public boolean accept(File pathname) {
                    return pathname.getName().endsWith(".jar") && !pathname.isDirectory();
                }
            })) {
                URI libJarURIForFacade = this.earURI.relativize(libJar.toURI());
                this.classPathForFacade.append(' ').append(libJarURIForFacade.toASCIIString());
                URI jarURI = URI.create("file:" + libJar.toURI().getRawSchemeSpecificPart());
                this.processDependencies(this.earURI, jarURI, this.earLevelDownloads, dependencyURIsProcessed, libJarURIForFacade);
            }
        }
    }

    private void processDependencies(URI baseURI, URI dependencyURI, Set<DownloadableArtifacts.FullAndPartURIs> downloads, Set<URI> dependencyURIsProcessed, URI containingJARURI) throws IOException {
        if (dependencyURIsProcessed.contains(dependencyURI)) {
            return;
        }
        URI dependencyFileURI = baseURI.resolve(dependencyURI);
        String scheme = dependencyFileURI.getScheme();
        if (scheme != null && scheme.equals("jar")) {
            dependencyFileURI = URI.create("file:" + dependencyFileURI.getRawSchemeSpecificPart());
        } else {
            if (scheme == null) {
                scheme = "file";
            }
            dependencyFileURI = URI.create(scheme + ":" + dependencyFileURI.getRawSchemeSpecificPart());
        }
        File dependentFile = new File(dependencyFileURI);
        if (!dependentFile.exists()) {
            if (this.isSubmodule(dependencyURI)) {
                dependentFile = this.JAROfExpandedSubmodule(dependencyURI);
                dependencyFileURI = dependentFile.toURI();
            } else {
                return;
            }
        }
        if (!dependentFile.exists()) {
            return;
        }
        if (dependentFile.isDirectory() && !this.isSubmodule(dependencyURI)) {
            if (!dependencyURI.getPath().endsWith("/")) {
                String format = logger.getResourceBundle().getString("enterprise.deployment.appclient.dirURLnoSlash");
                String msg = MessageFormat.format(format, dependencyURI.getPath(), containingJARURI.toASCIIString());
                logger.log(Level.WARNING, msg);
                ActionReport warning = this.dc().getActionReport();
                warning.setMessage(msg);
                warning.setActionExitCode(ActionReport.ExitCode.WARNING);
            } else {
                this.processDependentDirectory(dependentFile, baseURI, dependencyURIsProcessed, downloads);
            }
        } else {
            this.processDependentJAR(dependentFile, baseURI, dependencyURI, dependencyFileURI, dependencyURIsProcessed, downloads, containingJARURI);
        }
    }

    private void processDependentDirectory(File dependentDirFile, URI baseURI, Set<URI> dependencyURIsProcessed, Set<DownloadableArtifacts.FullAndPartURIs> downloads) {
        for (File f : dependentDirFile.listFiles()) {
            if (f.isDirectory()) {
                this.processDependentDirectory(f, baseURI, dependencyURIsProcessed, downloads);
                continue;
            }
            URI dependencyFileURI = f.toURI();
            DownloadableArtifacts.FullAndPartURIs fileDependency = new DownloadableArtifacts.FullAndPartURIs(dependencyFileURI, this.earDirUserURI(this.dc()).resolve(this.earURI.relativize(dependencyFileURI)));
            downloads.add(fileDependency);
        }
    }

    private void processDependentJAR(File dependentFile, URI baseURI, URI dependencyURI, URI dependencyFileURI, Set<URI> dependencyURIsProcessed, Set<DownloadableArtifacts.FullAndPartURIs> downloads, URI containingJARURI) throws IOException {
        DownloadableArtifacts.FullAndPartURIs jarFileDependency = new DownloadableArtifacts.FullAndPartURIs(dependencyFileURI, this.earDirUserURI(this.dc()).resolve(this.earURI.relativize(baseURI.resolve(dependencyURI))));
        downloads.add(jarFileDependency);
        URI jarURI = URI.create("jar:" + dependencyFileURI.getRawSchemeSpecificPart());
        InputJarArchive dependentJar = new InputJarArchive();
        dependentJar.open(jarURI);
        Manifest jarManifest = dependentJar.getManifest();
        dependentJar.close();
        Attributes mainAttrs = jarManifest.getMainAttributes();
        String jarClassPath = mainAttrs.getValue(Attributes.Name.CLASS_PATH);
        if (jarClassPath != null) {
            for (String elt : jarClassPath.split(" ")) {
                if (elt.trim().length() <= 0) continue;
                this.processDependencies(dependencyFileURI, URI.create(elt), downloads, dependencyURIsProcessed, containingJARURI);
            }
        }
    }

    private boolean isSubmodule(URI candidateURI) {
        for (ModuleDescriptor desc : this.appClientDesc().getApplication().getModules()) {
            if (!URI.create(desc.getArchiveUri()).equals(candidateURI)) continue;
            return true;
        }
        return false;
    }

    private boolean matchesSubmoduleURI(URI candidateURI, String submoduleURIText) {
        Matcher candidateMatcher = submoduleURIPattern.matcher(candidateURI.getPath());
        URI normalizedCandidateURI = candidateMatcher.matches() ? URI.create(candidateMatcher.group(1) + "." + candidateMatcher.group(2)) : candidateURI;
        candidateMatcher.reset(submoduleURIText);
        URI normalizedSubmoduleURI = candidateMatcher.matches() ? URI.create(candidateMatcher.group(1) + "." + candidateMatcher.group(2)) : URI.create(submoduleURIText);
        return normalizedCandidateURI.equals(normalizedSubmoduleURI);
    }

    private URI convertExpandedDirToJarURI(String submoduleURI) {
        URI result = null;
        Matcher m = submoduleURIPattern.matcher(submoduleURI);
        if (m.matches()) {
            result = URI.create(m.group(1) + "." + m.group(2));
        }
        return result;
    }

    @Override
    protected URI facadeServerURI(DeploymentContext dc) {
        File genXMLDir = dc.getScratchDir("xml");
        return genXMLDir.toURI().resolve(this.relativeFacadeURI(dc));
    }

    @Override
    protected Set<DownloadableArtifacts.FullAndPartURIs> earLevelDownloads() {
        return this.earLevelDownloads;
    }

    @Override
    protected Set<DownloadableArtifacts.FullAndPartURIs> clientLevelDownloads() throws IOException {
        return this.clientLevelDownloads;
    }

    @Override
    protected String facadeClassPath() {
        return this.classPathForFacade.toString();
    }

    @Override
    protected void addGroupFacadeToEARDownloads() {
        DownloadableArtifacts.FullAndPartURIs earFacadeDownload = (DownloadableArtifacts.FullAndPartURIs)this.dc().getTransientAppMetaData("earFacadeDownload", DownloadableArtifacts.FullAndPartURIs.class);
        this.earLevelDownloads.add(earFacadeDownload);
    }

    private String appName(DeploymentContext dc) {
        DeployCommandParameters params = (DeployCommandParameters)dc.getCommandParameters(DeployCommandParameters.class);
        return params.name();
    }

    @Override
    protected URI facadeUserURI(DeploymentContext dc) {
        return URI.create(this.appName(dc) + "Client/" + this.relativeFacadeURI(dc));
    }

    private URI relativeFacadeURI(DeploymentContext dc) {
        return this.moduleURI().resolve(this.facadeFileNameAndType(dc));
    }

    @Override
    protected String facadeFileNameAndType(DeploymentContext dc) {
        return this.moduleNameOnly() + "Client.jar";
    }

    @Override
    protected URI appClientUserURI(DeploymentContext dc) {
        return this.earDirUserURI(dc).resolve(this.moduleURI());
    }

    @Override
    protected URI appClientUserURIForFacade(DeploymentContext dc) {
        return URI.create(Util.getURIName((URI)this.appClientUserURI(dc)));
    }

    private URI earDirUserURI(DeploymentContext dc) {
        return URI.create(this.appName(dc) + "Client/");
    }

    @Override
    protected URI appClientServerURI(DeploymentContext dc) {
        String appClientURIWithinEAR = this.appClientDesc().getModuleDescriptor().getArchiveUri();
        Matcher m = submoduleURIPattern.matcher(appClientURIWithinEAR);
        File userProvidedJarFile = new File(new File(this.earURI), appClientURIWithinEAR);
        URI result = m.matches() ? new File(dc.getScratchDir("xml"), m.group(1) + "." + m.group(2)).toURI() : (!userProvidedJarFile.exists() ? new File(dc.getScratchDir("xml"), appClientURIWithinEAR).toURI() : userProvidedJarFile.toURI());
        return result;
    }

    @Override
    protected URI appClientURIWithinApp(DeploymentContext dc) {
        return URI.create(this.appClientDesc().getModuleDescriptor().getArchiveUri());
    }

    private URI moduleURI() {
        return URI.create(this.appClientDesc().getModuleDescriptor().getArchiveUri());
    }

    private String moduleNameAndType() {
        return Util.getURIName((URI)this.moduleURI());
    }

    private String moduleNameOnly() {
        String nameAndType = this.moduleNameAndType();
        return nameAndType.substring(0, nameAndType.lastIndexOf(".jar"));
    }
}

