/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.appclient.server.core.jws;

import com.sun.enterprise.deployment.ApplicationClientDescriptor;
import com.sun.enterprise.deployment.runtime.JavaWebStartAccessDescriptor;

public class NamingConventions {
    private static final String JWSAPPCLIENT_PREFIX = "/___JWSappclient";
    public static final String JWSAPPCLIENT_SYSTEM_PREFIX = "/___JWSappclient/___system";
    private static final String JWSAPPCLIENT_APP_PREFIX = "/___JWSappclient/___app";
    private static final String JWSAPPCLIENT_DOMAIN_PREFIX = "/___JWSappclient/___domain";
    public static final String DYN_PREFIX = "___dyn";

    public static String contextRootForAppAdapter(String appName) {
        return "/___JWSappclient/___app/" + appName;
    }

    public static String domainContentURIString(String domainRelativeURIString) {
        return "/___JWSappclient/___domain/" + domainRelativeURIString;
    }

    public static String generatedEARFacadeName(String earName) {
        return NamingConventions.generatedEARFacadePrefix(earName) + ".jar";
    }

    public static String generatedEARFacadePrefix(String earName) {
        return earName + "Client";
    }

    public static String anchorSubpathForNestedClient(String clientName) {
        return clientName + "Client/";
    }

    public static String systemJNLPURI() {
        return "___dyn/___system.jnlp";
    }

    public static String uriToNestedClient(ApplicationClientDescriptor descriptor) {
        String uriToClientWithinEar = descriptor.getModuleDescriptor().getArchiveUri();
        uriToClientWithinEar = uriToClientWithinEar.substring(0, uriToClientWithinEar.length() - ".jar".length());
        return uriToClientWithinEar;
    }

    public static String defaultUserFriendlyContextRoot(ApplicationClientDescriptor descriptor) {
        String ufContextRoot = descriptor.getApplication().isVirtual() ? descriptor.getApplication().getAppName() : descriptor.getApplication().getAppName() + "/" + NamingConventions.uriToNestedClient(descriptor);
        JavaWebStartAccessDescriptor jws = descriptor.getJavaWebStartAccessDescriptor();
        if (jws != null && jws.getContextRoot() != null) {
            ufContextRoot = jws.getContextRoot();
        }
        return ufContextRoot;
    }
}

