/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.enterprise.iiop.impl;

import com.sun.corba.ee.spi.copyobject.CopierManager;
import com.sun.corba.ee.spi.copyobject.CopyobjectDefaults;
import com.sun.corba.ee.spi.orb.DataCollector;
import com.sun.corba.ee.spi.orb.ORB;
import com.sun.corba.ee.spi.orb.ORBConfigurator;
import com.sun.corba.ee.spi.orbutil.copyobject.ObjectCopierFactory;
import com.sun.corba.ee.spi.orbutil.threadpool.ThreadPoolManager;
import com.sun.corba.ee.spi.presentation.rmi.InvocationInterceptor;
import java.util.logging.Logger;
import org.glassfish.enterprise.iiop.util.S1ASThreadPoolManager;

public class PEORBConfigurator
implements ORBConfigurator {
    private static final Logger logger = Logger.getLogger("javax.enterprise.resource.corba");
    private static ORB theORB;
    private static ThreadPoolManager threadpoolMgr;
    private static boolean txServiceInitialized;

    public void configure(DataCollector dc, ORB orb) {
        if (threadpoolMgr != null) {
            orb.setThreadPoolManager(threadpoolMgr);
        }
        PEORBConfigurator.configureCopiers(orb);
        PEORBConfigurator.configureCallflowInvocationInterceptor(orb);
    }

    private static void configureCopiers(ORB orb) {
        CopierManager cpm = orb.getCopierManager();
        ObjectCopierFactory stream = CopyobjectDefaults.makeORBStreamObjectCopierFactory(orb);
        ObjectCopierFactory reflect = CopyobjectDefaults.makeReflectObjectCopierFactory(orb);
        ObjectCopierFactory fallback = CopyobjectDefaults.makeFallbackObjectCopierFactory(reflect, stream);
        ObjectCopierFactory reference = CopyobjectDefaults.getReferenceObjectCopierFactory();
        cpm.registerObjectCopierFactory(fallback, 0);
        cpm.registerObjectCopierFactory(reference, 1);
        cpm.setDefaultId(0);
    }

    public static void setThreadPoolManager() {
        threadpoolMgr = S1ASThreadPoolManager.getThreadPoolManager();
    }

    private static void configureCallflowInvocationInterceptor(ORB orb) {
        orb.setInvocationInterceptor(new InvocationInterceptor(){

            public void preInvoke() {
            }

            public void postInvoke() {
            }
        });
    }

    static {
        threadpoolMgr = null;
        txServiceInitialized = false;
    }
}

