/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.common;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import javax.security.auth.callback.CallbackHandler;
import org.glassfish.api.admin.ProcessEnvironment;
import org.glassfish.api.embedded.Server;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.Singleton;

@Service
@Scoped(value=Singleton.class)
public class Util {
    @Inject
    private static Habitat habitat;
    @Inject
    private ProcessEnvironment penv;
    private CallbackHandler callbackHandler;
    private Object appClientMsgSecConfigs;

    public static Habitat getDefaultHabitat() {
        return habitat;
    }

    public static Util getInstance() {
        return (Util)habitat.getComponent(Util.class);
    }

    public boolean isACC() {
        return this.penv.getProcessType().equals((Object)ProcessEnvironment.ProcessType.ACC);
    }

    public boolean isServer() {
        return this.penv.getProcessType().equals((Object)ProcessEnvironment.ProcessType.Server);
    }

    public boolean isNotServerORACC() {
        return this.penv.getProcessType().equals((Object)ProcessEnvironment.ProcessType.Other);
    }

    public CallbackHandler getCallbackHandler() {
        return this.callbackHandler;
    }

    public void setCallbackHandler(CallbackHandler callbackHandler) {
        this.callbackHandler = callbackHandler;
    }

    public Object getAppClientMsgSecConfigs() {
        return this.appClientMsgSecConfigs;
    }

    public void setAppClientMsgSecConfigs(Object appClientMsgSecConfigs) {
        this.appClientMsgSecConfigs = appClientMsgSecConfigs;
    }

    public static boolean isEmbeddedServer() {
        List servers = Server.Builder.getServerNames();
        return !servers.isEmpty();
    }

    public static File writeConfigFileToTempDir(String fileName) throws IOException {
        String userHome = System.getProperty("user.home");
        InputStream iStream = Util.class.getClassLoader().getResourceAsStream("config" + File.separator + fileName);
        String embeddedServerName = Util.getCurrentEmbeddedServerName();
        File tempDir = new File(userHome + File.separator + ".glassfishv3-" + embeddedServerName + File.separator + "config");
        boolean mkDirSuccess = true;
        if (!tempDir.exists()) {
            mkDirSuccess = tempDir.mkdirs();
        }
        File localFile = new File(tempDir.getAbsoluteFile() + File.separator + fileName);
        if (mkDirSuccess && !localFile.exists()) {
            localFile.createNewFile();
        }
        FileOutputStream oStream = new FileOutputStream(localFile);
        while (iStream.available() > 0) {
            oStream.write(iStream.read());
        }
        oStream.close();
        iStream.close();
        return localFile;
    }

    public static String getCurrentEmbeddedServerName() {
        List embeddedServerNames = Server.Builder.getServerNames();
        String embeddedServerName = embeddedServerNames.get(0) == null ? "embedded" : (String)embeddedServerNames.get(0);
        return embeddedServerName;
    }
}

